<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<h4 class="customer-profile-group-heading"><?php echo _l('client_add_edit_profile'); ?></h4>
<div class="row">
   <?php echo form_open($this->uri->uri_string(),array('class'=>'client-form','autocomplete'=>'off')); ?>
   <div class="additional"></div>
   <div class="col-md-12">
      <div class="horizontal-scrollable-tabs">
         <div class="scroller arrow-left"><i class="fa fa-angle-left"></i></div>
         <div class="scroller arrow-right"><i class="fa fa-angle-right"></i></div>
         <div class="horizontal-tabs">
            <ul class="nav nav-tabs profile-tabs row customer-profile-tabs nav-tabs-horizontal" role="tablist">
               <li role="presentation" class="<?php if(!$this->input->get('tab')){echo 'active';}; ?>">
                  <a href="#contact_info" aria-controls="contact_info" role="tab" data-toggle="tab">
                  <?php echo _l( 'customer_profile_details'); ?>
                  </a>
               </li>

               <li role="presentation">
                   <a href="#customer_type" aria-controls="customer_type" role="tab" data-toggle="tab">
                       <?php echo _l( 'additional_info' ); ?>
                   </a>
               </li>

               <?php
                  $customer_custom_fields = false;
                  if(total_rows(db_prefix().'customfields',array('fieldto'=>'customers','active'=>1)) > 0 ){
                       $customer_custom_fields = true;
                   ?>
               <li role="presentation" class="<?php if($this->input->get('tab') == 'custom_fields'){echo 'active';}; ?>">
                  <a href="#custom_fields" aria-controls="custom_fields" role="tab" data-toggle="tab">
                  <?php echo hooks()->apply_filters('customer_profile_tab_custom_fields_text', _l( 'custom_fields')); ?>
                  </a>
               </li>
               <?php } ?>
               <li role="presentation">
                  <a href="#billing_and_shipping" aria-controls="billing_and_shipping" role="tab" data-toggle="tab">
                  <?php echo _l( 'billing_shipping'); ?>
                  </a>
               </li>
               <?php hooks()->do_action('after_customer_billing_and_shipping_tab', isset($client) ? $client : false); ?>
               <?php if(isset($client)){ ?>
               <li role="presentation">
                  <a href="#customer_admins" aria-controls="customer_admins" role="tab" data-toggle="tab">
                  <?php echo _l( 'customer_admins' ); ?>
                  <?php if(count($customer_admins) > 0 ) { ?>
                     <span class="badge bg-default"><?php echo count($customer_admins) ?></span>
                  <?php } ?>
                  </a>
               </li>
               <?php hooks()->do_action('after_customer_admins_tab',$client); ?>

               <?php // hooks()->do_action('after_customer_admins_tab',$client); ?>

               <?php } ?>
            </ul>
         </div>
      </div>
      <div class="tab-content mtop15">
         <?php hooks()->do_action('after_custom_profile_tab_content',isset($client) ? $client : false); ?>
         <?php if($customer_custom_fields) { ?>
         <div role="tabpanel" class="tab-pane <?php if($this->input->get('tab') == 'custom_fields'){echo ' active';}; ?>" id="custom_fields">
            <?php $rel_id=( isset($client) ? $client->userid : false); ?>
            <?php echo render_custom_fields( 'customers',$rel_id); ?>
         </div>
         <?php } ?>
                        <!-- // 2022-02-25 -->
               <div role="tabpanel" class="tab-pane" id="customer_type">
                   <?php
                      $ctOptions = [
                              [ 'key' => 'Individual',  'value' =>  _l("opt_individual") ],
                              [ 'key' => 'Company',  'value' => _l('opt_company') ]];
                      $itOptions = [
                              [ 'key' => 'ID Card',  'value' => _l("opt_id_card") ],
                              [ 'key' => 'Passport',  'value' => _l("opt_passport") ],
                              [ 'key' => 'Business Registration',  'value' => _l("opt_business_registration") ],
                              [ 'key' => 'Others',  'value' => _l("opt_others") ]
                      ];
                      $attb = array('key', array('value'));
                   ?>
                <?php $value=( isset($client) ? $client->customers_customer_type : ''); ?>
                <?php echo render_select('customers_customer_type', $ctOptions, $attb, 'customer_type', $value); ?>
                <?php $value=( isset($client) ? $client->customers_identification_type : ''); ?>
                <?php echo render_select('customers_identification_type', $itOptions, $attb, 'identification_type', $value); ?>
                <?php $value=( isset($client) ? $client->customers_business_registration : ''); ?>
                <?php echo render_textarea( 'customers_business_registration', 'business_registration',$value); ?>
                <?php $value=( isset($client) ? $client->customers_identification_notes : ''); ?>
                <?php echo render_textarea( 'customers_identification_notes', 'identification_notes',$value); ?>
               </div>


         <div role="tabpanel" class="tab-pane<?php if(!$this->input->get('tab')){echo ' active';}; ?>" id="contact_info">
            <div class="row">
               <div class="col-md-12 mtop15 <?php if(isset($client) && (!is_empty_customer_company($client->userid) && total_rows(db_prefix().'contacts',array('userid'=>$client->userid,'is_primary'=>1)) > 0)) { echo ''; } else {echo ' hide';} ?>" id="client-show-primary-contact-wrapper">
                  <div class="checkbox checkbox-info mbot20 no-mtop">
                     <input type="checkbox" name="show_primary_contact"<?php if(isset($client) && $client->show_primary_contact == 1){echo ' checked';}?> value="1" id="show_primary_contact">
                     <label for="show_primary_contact"><?php echo _l('show_primary_contact',_l('invoices').', '._l('estimates').', '._l('payments').', '._l('credit_notes')); ?></label>
                  </div>
               </div>
               <div class="col-md-6">
                  <?php $value=( isset($client) ? $client->company : ''); ?>
                  <?php $attrs = (isset($client) ? array() : array('autofocus'=>true)); ?>
                  <?php echo render_input( 'company', 'client_company',$value,'text',$attrs); ?>
                  <div id="company_exists_info" class="hide"></div>

                  <?php
//                  if(get_option('company_requires_vat_number_field') == 1){
//                     $value=( isset($client) ? $client->vat : '');
//                     echo render_input( 'vat', 'client_vat_number',$value);
//                     }
                  ?>

                  <?php $value=( isset($client) ? $client->phonenumber : ''); ?>
                  <?php echo render_input( 'phonenumber', 'client_phonenumber',$value); ?>
                  <?php if((isset($client) && empty($client->website)) || !isset($client)){
                     $value=( isset($client) ? $client->website : '');
                     echo render_input( 'website', 'client_website',$value);
                     } else { ?>
                  <div class="form-group">
                     <label for="website"><?php echo _l('client_website'); ?></label>
                     <div class="input-group">
                        <input type="text" name="website" id="website" value="<?php echo $client->website; ?>" class="form-control">
                        <div class="input-group-addon">
                           <span><a href="<?php echo maybe_add_http($client->website); ?>" target="_blank" tabindex="-1"><i class="fa fa-globe"></i></a></span>
                        </div>
                     </div>
                  </div>
                  <?php }
                     $selected = array();
                     if(isset($customer_groups)){
                       foreach($customer_groups as $group){
                          array_push($selected,$group['groupid']);
                       }
                     }
                     if(is_admin() || get_option('staff_members_create_inline_customer_groups') == '1'){
                      echo render_select_with_input_group('groups_in[]',$groups,array('id','name'),'customer_groups',$selected,'<a href="#" data-toggle="modal" data-target="#customer_group_modal"><i class="fa fa-plus"></i></a>',array('multiple'=>true,'data-actions-box'=>true),array(),'','',false);
                      } else {
                        echo render_select('groups_in[]',$groups,array('id','name'),'customer_groups',$selected,array('multiple'=>true,'data-actions-box'=>true),array(),'','',false);
                      }
                     ?>
                  <?php if(!isset($client)){ ?>
                  <i class="fa fa-question-circle pull-left" data-toggle="tooltip" data-title="<?php echo _l('customer_currency_change_notice'); ?>"></i>
                  <?php }
                     $s_attrs = array('data-none-selected-text'=>_l('system_default_string'));
                     $selected = '';
                     if(isset($client) && client_have_transactions($client->userid)){
                        $s_attrs['disabled'] = true;
                     }
                     foreach($currencies as $currency){
                        if(isset($client)){
                          if($currency['id'] == $client->default_currency){
                            $selected = $currency['id'];
                         }
                      }
                     }
                            // Do not remove the currency field from the customer profile!
                     echo render_select('default_currency',$currencies,array('id','name','symbol'),'invoice_add_edit_currency',$selected,$s_attrs); ?>
                  <?php if(!is_language_disabled()){ ?>
                  <div class="form-group select-placeholder">
                     <label for="default_language" class="control-label"><?php echo _l('localization_default_language'); ?>
                     </label>
                     <select name="default_language" id="default_language" class="form-control selectpicker" data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>">
                        <option value=""><?php echo _l('system_default_string'); ?></option>
                        <?php foreach($this->app->get_available_languages() as $availableLanguage){
                           $selected = '';
                           if(isset($client)){
                              if($client->default_language == $availableLanguage){
                                 $selected = 'selected';
                              }
                           }
                           ?>
                        <option value="<?php echo $availableLanguage; ?>" <?php echo $selected; ?>><?php echo ucfirst($availableLanguage); ?></option>
                        <?php } ?>
                     </select>
                  </div>
                  <?php } ?>
               </div>
               <div class="col-md-6">
                  <?php $value=( isset($client) ? $client->address : ''); ?>
                  <?php echo render_textarea( 'address', 'client_address',$value); ?>
                  <?php $value=( isset($client) ? $client->city : ''); ?>
                  <?php echo render_input( 'city', 'client_city',$value); ?>
                  <?php $value=( isset($client) ? $client->state : ''); ?>
                  <?php echo render_input( 'state', 'client_state',$value); ?>
                  <?php $value=( isset($client) ? $client->zip : ''); ?>
                  <?php echo render_input( 'zip', 'client_postal_code',$value); ?>
                  <?php $countries= get_all_countries();
                     $customer_default_country = get_option('customer_default_country');
                     $selected =( isset($client) ? $client->country : $customer_default_country);
                     echo render_select( 'country',$countries,array( 'country_id',array( 'short_name')), 'clients_country',$selected,array('data-none-selected-text'=>_l('dropdown_non_selected_tex')));
                     ?>
               </div>
            </div>
         </div>
         <?php if(isset($client)){ ?>
         <div role="tabpanel" class="tab-pane" id="customer_admins">
            <?php if (has_permission('customers', '', 'create') || has_permission('customers', '', 'edit')) { ?>
            <a href="#" data-toggle="modal" data-target="#customer_admins_assign" class="btn btn-info mbot30"><?php echo _l('assign_admin'); ?></a>
            <?php } ?>
            <table class="table dt-table" style="width:100%;  margin: 40px 20px;"><!-- // 2022-04-04 -->
               <thead>
                  <tr>
                     <th><?php echo _l('staff_member'); ?></th>
                     <th><?php echo _l('customer_admin_date_assigned'); ?></th>
                     <?php if(has_permission('customers','','create') || has_permission('customers','','edit')){ ?>
                     <th><?php echo _l('options'); ?></th>
                     <?php } ?>
                  </tr>
               </thead>
               <tbody>
                  <?php foreach($customer_admins as $c_admin){ ?>
                  <tr>
                     <td><a href="<?php echo admin_url('profile/'.$c_admin['staff_id']); ?>">
                        <?php echo staff_profile_image($c_admin['staff_id'], array(
                           'staff-profile-image-small',
                           'mright5'
                           ));
                           echo get_staff_full_name($c_admin['staff_id']); ?></a>
                     </td>
                     <td data-order="<?php echo $c_admin['date_assigned']; ?>"><?php echo _dt($c_admin['date_assigned']); ?></td>
                     <?php if(has_permission('customers','','create') || has_permission('customers','','edit')){ ?>
                     <td>
                        <a href="<?php echo admin_url('clients/delete_customer_admin/'.$client->userid.'/'.$c_admin['staff_id']); ?>" class="btn btn-danger _delete btn-icon"><i class="fa fa-remove"></i></a>
                     </td>
                     <?php } ?>
                  </tr>
                  <?php } ?>
               </tbody>
            </table>
         </div>
         <?php } ?>
          <style>
              td button {
                  height: 38px;
                  width: 42px;
                  margin:0.5px;
              }

              .address-list { width:100% }
              .address-list td { padding: 10px; }
              .address-list th { padding: 10px; }
              .list-bottom-btn { margin: 5px;}
              .address-list th td:last-child {   text-align: center }
              .address-list tr td:last-child {   text-align: center }
              
              .search-params label {
                  margin: 5px;
              }
          </style>

         <div role="tabpanel" class="tab-pane" id="billing_and_shipping">
             <?php if (defined('MULTIADDR_MODULE_NAME')) { ?>
            <div class="row address-pane2 hide">
                <table class="address-list">
                    <tr>
                        <th> <?php echo _l('multiaddr_order_no'); ?> </th>
                        <th> <?php echo _l('multiaddr_name'); ?></th>
                        <th> <?php echo _l('multiaddr_address'); ?></th>
                        <th style="text-align: center; "> <?php echo _l('multiaddr_action'); ?></th>
                    </tr>
                    <tbody id="address-receiver">
                        <?php foreach ($addressList as $key => $address) {
                            $json = json_encode($address);
                         ?>
                            <tr class="row-order">
                                <td><span class="ui-icon ui-icon-arrowthick-2-n-s"></span><?php echo $address['seq'] ?></td>
                                <td><?php echo $address['address_name'] ?></td>
                                <td><?php echo $address['address_display'] ?></td>
                                <td data-userid="<?php echo $address['userid']; ?>" data-addrid="<?php echo $address['id'] ?>" data-json='<?php echo $json; ?>' style="text-align: center; ">
                                    <?php

//                                    $actions = [];
//                                    if (has_permission('customers','','delete')) {
//									    $actions[] ='<a href="#" class="addr-del">'. _l('delete').'</a>';
//									}
//									if (has_permission('customers','','edit')) {
//										$actions[] ='<a href="#" class="addr-edit">'. _l('edit').'</a>';
//									}
//									if (has_permission('customers','','view')) {
//										$actions[] ='<a href="#" class="addr-view">'. _l('view').'</a>';
//									}
//									if (has_permission('customers','','edit')) {
//										$actions[] ='<a href="#" class="addr-bill">'. _l('multiaddr_set_billing').'</a>';
//										$actions[] ='<a href="#" class="addr-ship">'. _l('multiaddr_set_shipping').'</a>';
//									}
//									echo implode(' | ', $actions);

									$actions = [];
									if (has_permission('customers','','delete')) {
										$actions[] ='<a href="#" class="addr-del" title="'._l('delete').'"><button type="button" class="btn btn-danger" onclick="return false;"><i class="fa fa-close"></i></button></a>';
									}
									if (has_permission('customers','','edit')) {
										$actions[] ='<a href="#" class="addr-edit" title="'._l('edit').'"><button type="button" class="btn btn-primary" onclick="return false;"><i class="fa fa-pencil"></i></button></a>';
									}
									if (has_permission('customers','','view')) {
										$actions[] ='<a href="#" class="addr-view" title="'._l('view').'"><button type="button" class="btn btn-info" onclick="return false;"><i class="fa fa-eye"></i></button></a>';
									}
									if (has_permission('customers','','edit')) {
										$actions[] ='<a href="#" class="addr-bill" title="'._l('multiaddr_set_billing').'"><button type="button" class="btn btn-info" onclick="return false;"><i class="fa fa-money"></i></button></a>';
										$actions[] ='<a href="#" class="addr-ship" title="'._l('multiaddr_set_shipping').'"><button type="button" class="btn btn-info" onclick="return false;"><i class="fa fa-truck"></i></button></a>';
									}
									echo implode('', $actions);

									?>
                                    <input type="hidden" class="order_addr"  value="<?php echo $address['id']; ?>">
                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
                <?php if (has_permission('customers','','create')) {  ?>
                <button class="btn btn-info pull-right list-bottom-btn"  onclick="addNewAddress(); return false;"><?php echo _l('multiaddr_add_address'); ?></button>
                <?php } ?>
                <button class="btn btn-info pull-right list-bottom-btn"  onclick="switchAddressBack(); return false;"><?php echo _l('multiaddr_return'); ?></button>
            </div>
            <?php } ?>

            <div class="row address-pane1">
               <div class="col-md-12">
                  <div class="row">
                     <div class="col-md-6">
                        <h4 class="no-mtop"><?php echo _l('billing_address'); ?>
                            <?php if (defined('MULTIADDR_MODULE_NAME')) { ?>
                            <a href="#" onclick="switchAddress1()" class="btn btn-info pull-right" ><?php echo _l('multiaddr_switch'); ?></a> <!-- // 2022-03-25 -->
                            <a href="#" onclick="searchAddress('billing')" id="b_search" class="btn btn-info pull-right" ><?php echo _l('multiaddr_address_search'); ?></a> <!-- // 2022-03-25 -->
                            <?php } else { ?>
                            <a href="#" class="pull-right billing-same-as-customer"><small class="font-medium-xs"><?php echo _l('customer_billing_same_as_profile'); ?></small></a></h4>
                            <?php } ?>
                        <hr />
                        <?php $value=( isset($client) ? $client->billing_street : ''); ?>
                        <?php echo render_textarea( 'billing_street', 'billing_street',$value); ?>
                        <?php $value=( isset($client) ? $client->billing_city : ''); ?>
                        <?php echo render_input( 'billing_city', 'billing_city',$value); ?>
                        <?php $value=( isset($client) ? $client->billing_state : ''); ?>
                        <?php echo render_input( 'billing_state', 'billing_state',$value); ?>
                        <?php $value=( isset($client) ? $client->billing_zip : ''); ?>
                        <?php echo render_input( 'billing_zip', 'billing_zip',$value); ?>
                        <?php $selected=( isset($client) ? $client->billing_country : '' ); ?>
                        <?php echo render_select( 'billing_country',$countries,array( 'country_id',array( 'short_name')), 'billing_country',$selected,array('data-none-selected-text'=>_l('dropdown_non_selected_tex'))); ?>
                     </div>
                     <div class="col-md-6">
                        <h4 class="no-mtop">
                           <i class="fa fa-question-circle" data-toggle="tooltip" data-title="<?php echo _l('customer_shipping_address_notice'); ?>"></i>
                           <?php echo _l('shipping_address'); ?>
                            <?php if (defined('MULTIADDR_MODULE_NAME')) { ?>
                            <a href="#" onclick="switchAddress2()"  class="btn btn-info pull-right" ><?php echo _l('multiaddr_switch'); ?></a> <!-- // 2022-03-25 -->
                            <a href="#" onclick="searchAddress('shipping')" id="s_search" class="btn btn-info pull-right" ><?php echo _l('multiaddr_address_search'); ?></a> <!-- // 2022-03-25 -->
                            <?php } else { ?>
                            <a href="#" class="pull-right customer-copy-billing-address"><small class="font-medium-xs"><?php echo _l('customer_billing_copy'); ?></small></a>
                            <?php } ?>
                        </h4>
                        <hr />
                        <?php $value=( isset($client) ? $client->shipping_street : ''); ?>
                        <?php echo render_textarea( 'shipping_street', 'shipping_street',$value); ?>
                        <?php $value=( isset($client) ? $client->shipping_city : ''); ?>
                        <?php echo render_input( 'shipping_city', 'shipping_city',$value); ?>
                        <?php $value=( isset($client) ? $client->shipping_state : ''); ?>
                        <?php echo render_input( 'shipping_state', 'shipping_state',$value); ?>
                        <?php $value=( isset($client) ? $client->shipping_zip : ''); ?>
                        <?php echo render_input( 'shipping_zip', 'shipping_zip',$value); ?>
                        <?php $selected=( isset($client) ? $client->shipping_country : '' ); ?>
                        <?php echo render_select( 'shipping_country',$countries,array( 'country_id',array( 'short_name')), 'shipping_country',$selected,array('data-none-selected-text'=>_l('dropdown_non_selected_tex'))); ?>
                     </div>
                     <?php if(isset($client) &&
                        (total_rows(db_prefix().'invoices',array('clientid'=>$client->userid)) > 0 || total_rows(db_prefix().'estimates',array('clientid'=>$client->userid)) > 0 || total_rows(db_prefix().'creditnotes',array('clientid'=>$client->userid)) > 0)){ ?>
                     <div class="col-md-12">
                        <div class="alert alert-warning">
                           <div class="checkbox checkbox-default">
                              <input type="checkbox" name="update_all_other_transactions" id="update_all_other_transactions">
                              <label for="update_all_other_transactions">
                              <?php echo _l('customer_update_address_info_on_invoices'); ?><br />
                              </label>
                           </div>
                           <b><?php echo _l('customer_update_address_info_on_invoices_help'); ?></b>
                           <div class="checkbox checkbox-default">
                              <input type="checkbox" name="update_credit_notes" id="update_credit_notes">
                              <label for="update_credit_notes">
                              <?php echo _l('customer_profile_update_credit_notes'); ?><br />
                              </label>
                           </div>
                        </div>
                     </div>
                     <?php } ?>
                  </div>
               </div>
            </div>
         </div>

      </div>
   </div>
   <?php echo form_close(); ?>
</div>
<?php if(isset($client)){ ?>
<?php if (has_permission('customers', '', 'create') || has_permission('customers', '', 'edit')) { ?>
<div class="modal fade" id="customer_admins_assign" tabindex="-1" role="dialog">
   <div class="modal-dialog">
      <?php echo form_open(admin_url('clients/assign_admins/'.$client->userid)); ?>
      <div class="modal-content">
         <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title"><?php echo _l('assign_admin'); ?></h4>
         </div>
         <div class="modal-body">
            <?php
               $selected = array();
               foreach($customer_admins as $c_admin){
                  array_push($selected,$c_admin['staff_id']);
               }
               echo render_select('customer_admins[]',$staff,array('staffid',array('firstname','lastname')),'',$selected,array('multiple'=>true),array(),'','',false); ?>
         </div>
         <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
            <button type="submit" class="btn btn-info"><?php echo _l('submit'); ?></button>
         </div>
      </div>
      <!-- /.modal-content -->
      <?php echo form_close(); ?>
   </div>
   <!-- /.modal-dialog -->
</div>
<!-- /.modal -->
<?php } ?>
<?php } ?>
<?php $this->load->view('admin/clients/client_group'); ?>

<?php // 2022-01-18 ?>
<style>
    .customer-profile-btn {
        position: relative;
        top: -10px;
    }

    #s_search,
    #b_search {
        margin-right:  5px;
    }
</style>

<script>
    document.addEventListener("DOMContentLoaded", function(event) {
        let $customerType2 =  $('#customers_customer_type');
        let $identificationType2 =  $('#customers_identification_type');
        let companyOptions2 = [['', ''],
            ['Business Registration', '<?php echo _l('opt_business_registration') ?>'],
            ['Others','<?php echo _l('opt_others') ?>']];
        let individualOptions2 = [['',''],
            ['ID Card','<?php echo _l('opt_id_card'); ?>'],
            ['Passport', '<?php echo _l('opt_passport'); ?>'], ['Others', '<?php echo _l('opt_others'); ?>']];

        function initIdentificationType2() {

            if ($customerType2.val() === 'Individual') {
                let currList = [];
                $identificationType2.find('option').each(function(){
                    let val = $(this).val();
                    if ( findValue(val, individualOptions2) === -1 ) {
                        $(this).remove();
                    } else {
                        currList.push($(this).val());
                    }
                });
                $.each(individualOptions2, function(i, v) {
                    if ($.inArray(v[0], currList) === -1 ) {
                        let $option = $('<option value="'+v[0]+'" >'+v[1]+'</option>');
                        $identificationType2.find('option:last').before($option);
                    }
                });
            }

            if ($customerType2.val() === 'Company') {
                let currList = [];
                $identificationType2.find('option').each(function(){
                    let val = $(this).val();
                    if ( findValue(val, companyOptions2) === -1 ) {
                        $(this).remove();
                    } else {
                        currList.push($(this).val());
                    }
                });
                $.each(companyOptions2, function(i, v) {
                    if ( $.inArray(v[0], currList) === -1 ) {
                        let $option = $('<option value="'+v[0]+'" >'+v[1]+'</option>');
                        $identificationType2.find('option:last').before($option);
                    }
                });
            }

            $identificationType2.selectpicker('refresh');
        }

        function findValue(val, pairList) {
            for (let i=0 ; i<pairList.length ; i++) {
                let item = pairList[i];
                if (item[0] == val) {
                    return i;
                }
            }
            return -1;
        }

        initIdentificationType2()
        $customerType2.on('change', function(){
            initIdentificationType2();
        });

        //=========================
        let $clientPortalID = $('[name="custom_fields[customers][16]"]'); // 2022-01-20
        let $customerType = $('[name="custom_fields[customers][17]"]');
        let $identificationType = $('[name="custom_fields[customers][22]"]');
        let companyOptions = ['', 'Business Registration', 'Others'];
        let individualOptions = ['', 'ID Card', 'Passport', 'Others'];

        function initIdentificationType() {

            if ($customerType.val() === 'Individual') {
                let currList = [];
                $identificationType.find('option').each(function(){
                    let val = $(this).val();
                    if ( $.inArray(val, individualOptions) === -1 ) {
                        $(this).remove();
                    } else {
                        currList.push($(this).val());
                    }
                });
                $.each(individualOptions, function(i, v) {
                    if ($.inArray(v, currList) === -1 ) {
                        let $option = $('<option value="'+v+'" >'+v+'</option>');
                        $identificationType.find('option:last').before($option);
                    }
                });
                $('[name="custom_fields[customers][16]"]').closest('.col-md-12').show();
                $('.customer-profile-btn').show("slow");
            }

            if ($customerType.val() === 'Company') {
                let currList = [];
                $identificationType.find('option').each(function(){
                    let val = $(this).val();
                    if ( $.inArray(val, companyOptions) === -1 ) {
                        $(this).remove();
                    } else {
                        currList.push($(this).val());
                    }
                });
                $.each(companyOptions, function(i, v) {
                    if ( $.inArray(v, currList) === -1 ) {
                        let $option = $('<option value="'+v+'" >'+v+'</option>');
                        $identificationType.find('option:last').before($option);
                    }
                });
                $('[name="custom_fields[customers][16]"]').closest('.col-md-12').show("slow");
                $('.customer-profile-btn').show("slow");
            }

            // 2022-02-10
            if ($customerType.val() === 'Vendor') {
                $('[name="custom_fields[customers][16]"]:visible').rules('remove', 'required'); //.rules("remove", "required")
                $('[name="custom_fields[customers][16]"]').closest('.col-md-12').hide("slow");
                $('[name="custom_fields[customers][16]"]').val('');
                $('.customer-profile-btn').hide("slow");
            } else {
                $('[name="custom_fields[customers][16]"]:visible').rules('add', { 'required' :  true });
                $('[name="custom_fields[customers][16]"]').closest('.col-md-12').show("slow");
                $('.customer-profile-btn').show("slow");
            }
            // $customerType = $('[name="custom_fields[customers][17]"]');
            //   $customerType.on('change', function(){
            //       initIdentificationType();
            //   });

            $identificationType.selectpicker('refresh');
        }



        initIdentificationType()
        $customerType.on('change', function(){
            initIdentificationType();
        });

        function disableButton($obj) {
            $($obj).prop('disable', true).text('<?php echo _l('checking'); ?>').css('opacity',0.3);
        }
        function enableButton($obj) {
            $($obj).prop('disable', false).text('<?php echo _l('check_id_duplication'); ?>').css('opacity', 1);
        }

        // 2022-01-20
        // Check ID duplication of Client Portal ID
        $('#check_id_depu').on('click', function(){
            checkIdExist(null);
        });

        $('#create_eshop_acc').on('click', function(){
            checkIdExist(function() {
                $('#modalLoginForm').modal('show');
            });
        });

        function checkIdExist(acceptCallBack){
            let url = '<?php echo admin_url('usercontrol/Depucheck/clientportalid/'); ?>';
            let id_code = $clientPortalID.val();
            let cid = $('[name=userid]').val();
            if (id_code.length == 0) {
                alert('<?php echo _l( 'portal_id_cannot_empty'); ?>');
                return;
            }

            // Check client portal id does no one registered in Client ZUU server
            btnObj = $('#check_id_depu');
            disableButton(btnObj);
            $.ajax({
                type: 'POST',
                url: url,
                dataType: 'JSON',
                data: { customer_id : cid, customer_code : id_code },
                success: function(resp) {
                    if (resp.rscode){
                        if (resp.rscode==200) {
                            if (resp.found) {
                                let msg = '<?php echo _l('portalid__found'); ?>';
                                alert_float('warning', msg);
                            } else {
                                if (acceptCallBack != null) {
                                    acceptCallBack();
                                } else {
                                    let msg = '<?php echo _l('portalid_not_found'); ?>';
                                    alert_float('success', msg);
                                }
                            }
                        } else {
                            let msg = '<?php echo _l('access_failed'); ?>';
                            alert_float('danger', msg);
                        }
                    }
                    enableButton(btnObj);
                },
                error: function(){
                    let msg = '<?php echo _l('access_failed'); ?>';
                    alert_float('danger', msg);
                    enableButton(btnObj);
                }
            });
        }

        $('#reg-button').on('click', function(){
                let email = $("#defaultForm-email").val();
                let passw = $("#defaultForm-pass").val();
                if (! ValidateEmail(email)) {
                    alert('Invalid email form, please input again!');
                    return;
                }

                if (passw === undefined || passw.length < 6) {
                    alert('Please input password at least 6 characters long!');
                    return;
                }

                startCreateAcc();
        });

        function startCreateAcc() {
            let email = $("#defaultForm-email").val();
            let passw = $("#defaultForm-pass").val();
            setTimeout(function(){
                $("#defaultForm-email").val('');
                $("#defaultForm-pass").val('');
                sendOutCreateAcc(email, passw);
            }, 500);
            $('#modalLoginForm').modal('hide');
        }

        function ValidateEmail(emailString) {
            if (emailString === undefined) return false;
            var atSymbol = emailString.indexOf("@");
            if(atSymbol < 1) return false;
            var dot = emailString.indexOf(".");
            // if(dot <= atSymbol + 1) return false;
            if (dot === emailString.length - 1) return false;
            return true;
        }

        function sendOutCreateAcc(email, passw) {
            let portal_id = $('[name="custom_fields[customers][16]"').val();
            let cid = $('[name=userid]').val();

            if (portal_id == '') {
                alert('<?php echo _l( 'portal_id_cannot_empty'); ?>');
                return;
            }

            let data = { email : email, password : passw, customer_id : cid, portal_id : portal_id  };

            let url = '<?php echo admin_url('usercontrol/Depucheck/createaccount/'); ?>';

            let btnObj = $('#create_eshop_acc');
            disableButton(btnObj);
            $.ajax({
                type: 'POST',
                url: url,
                dataType: 'JSON',
                data: { email : email, password : passw, customer_id : cid, portal_id : portal_id  },
                success: function (resp) {
                    let msg = '';
                    if (resp.rscode) {
                        if (resp.rscode == 200) {
                            msg = '<?php echo _l('account_created'); ?>';
                            alert(msg);
                            location.reload();
                        } else if (resp.rscode == 400) {
                            msg = resp.error_msg;
                            //alert_float('danger', msg);
                        } else {
                            msg = '<?php echo _l('fail_to_create_acc'); ?>';
                            //alert_float('danger', msg);
                        }
                        //alert(msg);
                    }
                    enableButton(btnObj);
                    alert(msg);
                },
                error: function () {
                    let msg = '<?php echo _l('access_failed'); ?>';
                    //alert_float('danger', msg);
                    enableButton(btnObj,);
                    alert(msg);
                }
            });

        }

    });


</script>
<div class="modal fade" id="modalLoginForm" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
     aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header text-center">
                <h4 class="modal-title w-100 font-weight-bold"><?php echo _l('signin_info'); ?></h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body mx-3">
                <div class="md-form mb-5">
                    <i class="fas fa-envelope prefix grey-text"></i>
                    <input type="email" id="defaultForm-email" class="form-control validate">
                    <label data-error="wrong" data-success="right" for="defaultForm-email"><?php echo _l('your_email'); ?></label>
                </div>

                <div class="md-form mb-4">
                    <i class="fas fa-lock prefix grey-text"></i>
                    <input type="password" id="defaultForm-pass" class="form-control validate">
                    <label data-error="wrong" data-success="right" for="defaultForm-pass"><?php echo _l('your_password'); ?></label>
                </div>

            </div>
            <div class="modal-footer d-flex justify-content-center">
                <button class="btn btn-default" id="reg-button"><?php echo _l('registration'); ?></button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="addrForm" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
     aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header text-center">
                <h4 class="modal-title w-100 font-weight-bold"><?php echo _l('multiaddr_address'); ?></h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body mx-3">
                <div class="row">
                <button class="btn btn-info pull-right" id="find-address" onclick="findAddress()" style="margin-right:15px;"><?php echo _l('multiaddr_address_search'); ?></button>
                </div>
				<form method="post">
				<?php echo render_input( 'proc_address_name', 'multiaddr_name',$value, 'text',['required' => 'required']); ?>
				<?php //$value=( isset($client) ? $client->shipping_street : ''); ?>
				<?php echo render_textarea( 'proc_street', 'multiaddr_clients_street',$value); ?>
				<?php //$value=( isset($client) ? $client->shipping_city : ''); ?>
				<?php echo render_input( 'proc_city', 'clients_city',$value); ?>
				<?php //$value=( isset($client) ? $client->shipping_state : ''); ?>
				<?php echo render_input( 'proc_state', 'clients_state',$value); ?>
				<?php //$value=( isset($client) ? $client->shipping_zip : ''); ?>
				<?php echo render_input( 'proc_zip', 'clients_zip',$value); ?>
				<?php //$selected=( isset($client) ? $client->shipping_country : '' ); ?>
				<?php echo render_select( 'proc_country',$countries,array( 'country_id',array( 'short_name')), 'clients_country',$selected,array('data-none-selected-text'=>_l('dropdown_non_selected_tex')),); ?>
                <input type="hidden" name="proc_userid" id="proc_userid"value="" >
                <input type="hidden" name="proc_addrid" id="proc_addrid" value="" >
                </form>
            </div>
            <div class="modal-footer d-flex justify-content-center">
                <button class="btn btn-default pull-right" id="save-addr-button"><?php echo _l('submit'); ?></button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="find-address-modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
     aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header text-center">
                <h4 class="modal-title w-100 font-weight-bold"><?php echo _l('multiaddr_address_search'); ?></h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body mx-3">
                <div class='row'>
                    <div class="col-md-12 search-params">
						      <label><?php echo _l('multiaddr_chinese');?> <input type='radio' name="return_langs" value="Chi"></label>
                        <label><?php echo _l('multiaddr_english');?> <input type='radio' name="return_langs" value="Eng"></label>
                        <label><?php echo _l('multiaddr_both');?> <input type='radio' name="return_langs" value="Both" checked ></label>
                        <label><?php echo _l('multiaddr_max_rec');?> <input type='number' name="return_max_rec" value="200" min="1" max="200"  style="width:60px;"></label>
                        <label><?php echo _l('multiaddr_tolerance');?> <input type='number' name="return_tolerance" value="20"  min="0" max="80" style="width:60px; "></label>
                        <label class="search-loading" style="display:none;"><?php echo _l('dt_loading_records'); ?></label>
                    </div>
                    <div class="col-md-12">
                        <input type="hidden" id="search_type" value="">
						<?php echo render_input( 'keyword', '', '' , 'text', [ 'onkeypress'=> 'getAddressList()' , 'placeholder' => _l("multiaddr_keyword") ] ); ?>
                    </div>
                    <!--
                    <button class='btn btn-info col-md-1' onclick="getAddressList()">
                        <i class="fa fa-search" ></i>
                    </button>
                    -->
                </div>
                <div style="width:100%; height:300px; overflow:scroll">
                    <ul id='address-list' style="width: 100%">
                        <li>
							<?php echo _l('multiaddr_please_select');?>
                        </li>

                    </ul>
                </div>
            </div>
            <div class="modal-footer d-flex justify-content-center">
                <!-- <button class="btn btn-default pull-right" id="save-addr-button"><?php echo _l('submit'); ?></button> -->
            </div>
        </div>
    </div>
</div>


<!--
<div class="text-center">
    <a href="" class="btn btn-default btn-rounded mb-4" data-toggle="modal" data-target="#modalLoginForm">
        <?php echo _l('portal_registration_form'); ?></a>
</div>
-->
<?php if (defined('MULTIADDR_MODULE_NAME')) { ?>
<style>
    table.address-list {
        width: 100%;
    }
</style>

    <script>

    // 2022-03-25
    document.addEventListener("DOMContentLoaded", function() {

        remakeHandlers();

        function remakeHandlers() {
            $('.addr-del').on('click', function(){
                if (confirm('<?php echo _l('confirm_action_prompt'); ?>')) {
                    let userid = $(this).parent().data('userid');
                    let addrid = $(this).parent().data('addrid');
                    // renewAddrs('del', userid, addrid);
                    renewAddrs({ action: "del", userid: userid, addrid: addrid });
                }
            });
            $('.addr-edit').on('click', function(){
                let userid = $(this).parent().data('userid');
                let addrid = $(this).parent().data('addrid');

                let info = $(this).parent().data('json');
                $('#addrForm .modal-title').text(info.address_name);

                $('#addrForm textarea').prop('readonly', false);
                $('#addrForm input').prop('readonly', false);
                $('#addrForm select').prop('readonly', false);

                //$('#addrForm').modal().find('form')[0].reset();
                $('#proc_address_name').val(info.address_name);
                $('#proc_street').val(info.street);
                $('#proc_city').val(info.city);
                $('#proc_state').val(info.state);
                $('#proc_zip').val(info.zip);
                $('#proc_country').val(info.country).prop('disabled', false).change();
                $('#proc_country').selectpicker('refresh');
                $('#proc_userid').val(userid);
                $('#proc_addrid').val(addrid);
                $('#addrForm').modal('show');
                $('#save-addr-button').show();
                $('#find-address').removeClass('hide');
                return false;
            });
            $('.addr-view').on('click', function(){
                let userid = $(this).parent().data('userid');
                let addrid = $(this).parent().data('addrid');
                let info = $(this).parent().data('json');
                //$('#addrForm').modal().find('form')[0].reset();
                $('#addrForm .modal-title').text(info.address_name);

                $('#proc_address_name').val(info.address_name);
                $('#proc_street').val(info.street);
                $('#proc_city').val(info.city);
                $('#proc_state').val(info.state);
                $('#proc_zip').val(info.zip);
                $('#proc_country').val(info.country).prop('disabled', true).change();
                $('#proc_country').selectpicker('refresh');
                $('#proc_userid').val(userid);
                $('#proc_addrid').val(addrid);
                $('#addrForm').modal('show');
                $('#save-addr-button').hide();
                $('#find-address').addClass('hide');

                $('#addrForm textarea').prop('readonly', true);
                $('#addrForm input').prop('readonly', true);
                $('#addrForm select').prop('readonly', true);
                return false;
            });
            $('.addr-bill').on('click', function() {
                let info = $(this).parent().data('json');
                $('#billing_street').val( info.street );
                $('#billing_city').val( info.city );
                $('#billing_state').val( info.state );
                $('#billing_zip').val( info.zip );
                $('#billing_country').val( info.country ).change();
                switchAddressBack();
                return false;
            });
            $('.addr-ship').on('click', function() {
                let info = $(this).parent().data('json');
                $('#shipping_street').val( info.street );
                $('#shipping_city').val( info.city );
                $('#shipping_state').val( info.state );
                $('#shipping_zip').val( info.zip );
                $('#shipping_country').val( info.country ).change();
                switchAddressBack();
                return false;
            });

            $( "#address-receiver" ).sortable({
                update: function(event, ui) {
					<?php $userid=( isset($client) ? $client->userid : false); ?>
                    let userid = '<?php echo $userid ?>';
                    let ordering = [];
                    $('.order_addr').each(function(){
                        ordering.push($(this).val());
                    });
                    let action = 'order';
                    let data = {
                        action: action,
                        userid: userid,
                        addrid: ordering,
                    };
                    renewAddrs(data);
                }
            });

        }

        $("#proc_country").on("changed.bs.select",
            function(e, clickedIndex, newValue, oldValue) {
                if (this.value == 99) {
                    $('#find-address').show();
                } else {
                    $('#find-address').hide();
                }
            });

        $("#billing_country").on("changed.bs.select",
            function(e, clickedIndex, newValue, oldValue) {
                if (this.value == 99) {
                    $('#b_search').show();
                } else {
                    $('#b_search').hide();
                }
            });
        if ($("#billing_country").val() == 99) {
            $('#b_search').show();
        } else {
            $('#b_search').hide();
        }

        $("#shipping_country").on("changed.bs.select",
            function(e, clickedIndex, newValue, oldValue) {
                if (this.value == 99) {
                    $('#s_search').show();
                } else {
                    $('#s_search').hide();
                }
            });
        if ($("#shipping_country").val() == 99) {
            $('#s_search').show();
        } else {
            $('#s_search').hide();
        }

        $('#save-addr-button').on('click', function(){
            if ($('#proc_address_name').val() == '') {
                alert_float('danger', '<?php echo _l('Must not empty'); ?>');
                $('#proc_address_name').focus();
                return;
            }

            let action = $('#proc_addrid').val() == 0 ? 'add' : 'upd';
            let data = {
                action: action,
                userid: $('#proc_userid').val(),
                addrid: $('#proc_addrid').val(),
                address_name: $('#proc_address_name').val(),
                street: $('#proc_street').val(),
                city: $('#proc_city').val(),
                state: $('#proc_state').val(),
                zip: $('#proc_zip').val(),
                country: $('#proc_country').val(),
            };
            renewAddrs(data);
        });

        $('#find-address-modal').on('hidden.bs.modal', function () {
            $('#address-list').html('');
            $('[name=keyword]').val('');
        });

        function renewAddrs(dataSet) {
            let url = '<?php echo admin_url('multiaddr/update') ?>';
            $.ajax({
                type: 'POST',
                url: url,
                dataType: 'JSON',
                data: dataSet,
                success: function (resp) {
                    let msg = '';
                    if (resp.rscode) {
                        if (resp.rscode == 200) {
                            //$('#addrForm').modal().find('form')[0].reset();
                            $('#addrForm').modal('hide');
                            $('#address-receiver').first().html(resp.html);
                            remakeHandlers();
                        }
                    }
                },
                error: function () {
                }
            });
        }

        $('[name=return_max_rec]').on('change', function(){
            if ($(this).val() > 200) {
                $(this).val(200);
            }
            if ($(this).val() < 1) {
                $(this).val(1);
            }
        });
        $('[name=return_tolerance]').on('change', function(){
            if ($(this).val() > 80) {
                $(this).val(80);
            }
            if ($(this).val() < 0) {
                $(this).val(0);
            }
        });

        // Radio button also can trigger list
        $('[name=return_langs]').on('click',function(){
           getAddressList();
        });

        // 2022-04-28  Handling paste
        $(document).on('input', 'input, textarea', function(e){
            if (e.originalEvent.inputType == 'insertFromPaste') {
                getAddressList();
            }
        });

    });

    function searchAddress(type) {
        $('#find-address-modal').modal('show');
        $('#search_type').val(type);
    }

    function getAddressList() {
        // https://geodata.gov.hk/gs/api/v1.0.0/locationSearch?q=cultural%20centre
        let keyword = $('[name=keyword]').val();
        let langs   = $('[name=return_langs]:checked').val();
        let len   = $('[name=return_max_rec]').val();
        let tol   = $('[name=return_tolerance]').val();
        //let url = 'https://geodata.gov.hk/gs/api/v1.0.0/locationSearch';
        let url = '<?php echo admin_url('multiaddr/get_addresses'); ?>';
        //url += 'q='+encodeURIComponent(keyword);
        $('#address-list').html('');
        $('.search-loading').show();

        $.ajax({
            method: 'POST',
            url: url,
            data: {  q: keyword, langs: langs, n : len, t: tol  },
            dataType: 'JSON',
            success: function(resp) {
                 $('.search-loading').hide();
                for (let idx in resp) {
                    let item = resp[idx];
                    let line = '';
                    let html = '';
                    if (item.hasOwnProperty('Eng')) {
                        item =  item.Eng;
                    } else if (item.hasOwnProperty('Chi')) {
                        item = item.Chi;
                    }

                    line = item.State + ', ' + item.City + ', ' +item.Street;
                    html = '<li data-state="' + encodeURIComponent(item.State) + '" data-city="' + encodeURIComponent(item.City) + '" data-street="' + encodeURIComponent(item.Street) + '" >' + line + '</li>';
                    $('#address-list').append(html);
                }

                if ($('#search_type').val() == 'multi') {
                    $('#address-list li').css('cursor', 'pointer').on('click', function () {
                        $('#proc_street').val(decodeURIComponent($(this).data('street')));
                        $('#proc_city').val(decodeURIComponent($(this).data('city')));
                        $('#proc_state').val(decodeURIComponent($(this).data('state')));
                        $('#address-list').html('');
                        $('#find-address-modal').modal('hide');
                    });
                }
                if ($('#search_type').val() == 'shipping') {
                    $('#address-list li').css('cursor', 'pointer').on('click', function () {
                        $('#shipping_street').val(decodeURIComponent($(this).data('street')));
                        $('#shipping_city').val(decodeURIComponent($(this).data('city')));
                        $('#shipping_state').val(decodeURIComponent($(this).data('state')));
                        $('#address-list').html('');
                        $('#find-address-modal').modal('hide');
                    });
                }
                if ($('#search_type').val() == 'billing') {
                    $('#address-list li').css('cursor', 'pointer').on('click', function () {
                        $('#billing_street').val(decodeURIComponent($(this).data('street')));
                        $('#billing_city').val(decodeURIComponent($(this).data('city')));
                        $('#billing_state').val(decodeURIComponent($(this).data('state')));
                        $('#address-list').html('');
                        $('#find-address-modal').modal('hide');
                    });
                }
            },
            error: function(){
                let msg = '<?php echo _l('access_failed'); ?>';
                alert_float('danger', msg);
                enableButton(btnObj);
            }
        });
    }

    function switchAddress1() {
        $('.address-pane1').addClass('hide');
        $('.address-pane2').removeClass('hide');
    }

    function switchAddress2() {
        $('.address-pane1').addClass('hide');
        $('.address-pane2').removeClass('hide');
    }

    function switchAddressBack() {
        $('.address-pane2').addClass('hide');
        $('.address-pane1').removeClass('hide');
    }

    function addNewAddress() {
        if ($('#address-receiver tr').length >= '<?php echo MULTIADDR_MAX_ADDRESS; ?>') {
               alert_float('danger', '<?php echo _l('multiaddr_allow_max_6_address'); ?>'+$('#address-receiver tr').length );
               return false;
        }

		<?php $userid=( isset($client) ? $client->userid : false); ?>
        let userid = '<?php echo $userid ?>';
        let addrid = 0;
        $('#addrForm textarea').prop('readonly', false);
        $('#addrForm input').prop('readonly', false);
        $('#addrForm select').prop('readonly', false);
        $('#addrForm .modal-title').text('<?php echo _l('address'); ?>');
        $('#find-address').removeClass('hide');

        //$('#addrForm').modal().find('form')[0].reset();
        $('#proc_address_name').val('');
        $('#proc_street').val('');
        $('#proc_city').val('');
        $('#proc_state').val('');
        $('#proc_zip').val('');
        $('#proc_country').val(99).change();
        $('#proc_userid').val(userid);
        $('#proc_addrid').val(addrid);
        $('#addrForm').modal('show');
        $('#save-addr-button').show();

        return false;
    }

    function findAddress() {
        $('#find-address-modal').modal('show');
        $('#search_type').val('multi');
    }

</script>
<?php } ?>