<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<h4 class="customer-profile-group-heading"><?php echo _l('client_add_edit_profile'); ?></h4>
<div class="row">
   <?php echo form_open($this->uri->uri_string(),array('class'=>'client-form','autocomplete'=>'off')); ?>
   <div class="additional"></div>
   <div class="col-md-12">
      <div class="horizontal-scrollable-tabs">
         <div class="scroller arrow-left"><i class="fa fa-angle-left"></i></div>
         <div class="scroller arrow-right"><i class="fa fa-angle-right"></i></div>
         <div class="horizontal-tabs">
            <ul class="nav nav-tabs profile-tabs row customer-profile-tabs nav-tabs-horizontal" role="tablist">
               <li role="presentation" class="<?php if(!$this->input->get('tab')){echo 'active';}; ?>">
                  <a href="#contact_info" aria-controls="contact_info" role="tab" data-toggle="tab">
                  <?php echo _l( 'customer_profile_details'); ?>
                  </a>
               </li>

               <li role="presentation">
                   <a href="#customer_type" aria-controls="customer_type" role="tab" data-toggle="tab">
                       <?php echo _l( 'additional_info' ); ?>
                   </a>
               </li>

               <?php
                  $customer_custom_fields = false;
                  if(total_rows(db_prefix().'customfields',array('fieldto'=>'customers','active'=>1)) > 0 ){
                       $customer_custom_fields = true;
                   ?>
               <li role="presentation" class="<?php if($this->input->get('tab') == 'custom_fields'){echo 'active';}; ?>">
                  <a href="#custom_fields" aria-controls="custom_fields" role="tab" data-toggle="tab">
                  <?php echo hooks()->apply_filters('customer_profile_tab_custom_fields_text', _l( 'custom_fields')); ?>
                  </a>
               </li>
               <?php } ?>
               <li role="presentation">
                  <a href="#billing_and_shipping" aria-controls="billing_and_shipping" role="tab" data-toggle="tab">
                  <?php echo _l( 'billing_shipping'); ?>
                  </a>
               </li>
               <?php hooks()->do_action('after_customer_billing_and_shipping_tab', isset($client) ? $client : false); ?>
               <?php if(isset($client)){ ?>
               <li role="presentation">
                  <a href="#customer_admins" aria-controls="customer_admins" role="tab" data-toggle="tab">
                  <?php echo _l( 'customer_admins' ); ?>
                  <?php if(count($customer_admins) > 0 ) { ?>
                     <span class="badge bg-default"><?php echo count($customer_admins) ?></span>
                  <?php } ?>
                  </a>
               </li>
               <?php hooks()->do_action('after_customer_admins_tab',$client); ?>

               <?php // hooks()->do_action('after_customer_admins_tab',$client); ?>

               <?php } ?>
            </ul>
         </div>
      </div>
      <div class="tab-content mtop15">
         <?php hooks()->do_action('after_custom_profile_tab_content',isset($client) ? $client : false); ?>
         <?php if($customer_custom_fields) { ?>
         <div role="tabpanel" class="tab-pane <?php if($this->input->get('tab') == 'custom_fields'){echo ' active';}; ?>" id="custom_fields">
            <?php $rel_id=( isset($client) ? $client->userid : false); ?>
            <?php echo render_custom_fields( 'customers',$rel_id); ?>
         </div>
         <?php } ?>
                        <!-- // 2022-02-25 -->
               <div role="tabpanel" class="tab-pane" id="customer_type">
                   <?php
                      $ctOptions = [
                              [ 'key' => 'Individual',  'value' =>  _l("opt_individual") ],
                              [ 'key' => 'Company',  'value' => _l('opt_company') ]];
                      $itOptions = [
                              [ 'key' => 'ID Card',  'value' => _l("opt_id_card") ],
                              [ 'key' => 'Passport',  'value' => _l("opt_passport") ],
                              [ 'key' => 'Business Registration',  'value' => _l("opt_business_registration") ],
                              [ 'key' => 'Others',  'value' => _l("opt_others") ]
                      ];
                      $attb = array('key', array('value'));
                   ?>
                <?php $value=( isset($client) ? $client->customers_customer_type : ''); ?>
                <?php echo render_select('customers_customer_type', $ctOptions, $attb, 'customer_type', $value, array('required'=>'true')); ?>
                <?php $value=( isset($client) ? $client->customers_identification_type : ''); ?>
                <?php echo render_select('customers_identification_type', $itOptions, $attb, 'identification_type', $value,[], array('required'=>'true')); ?>
                <?php $value=( isset($client) ? $client->customers_business_registration : ''); ?>
                <?php echo render_textarea( 'customers_business_registration', 'business_registration',$value, array('required'=>'true')); ?>
                <?php $value=( isset($client) ? $client->customers_identification_notes : ''); ?>
                <?php echo render_textarea( 'customers_identification_notes', 'identification_notes',$value); ?>
               </div>


         <div role="tabpanel" class="tab-pane<?php if(!$this->input->get('tab')){echo ' active';}; ?>" id="contact_info">
            <div class="row">
               <div class="col-md-12 mtop15 <?php if(isset($client) && (!is_empty_customer_company($client->userid) && total_rows(db_prefix().'contacts',array('userid'=>$client->userid,'is_primary'=>1)) > 0)) { echo ''; } else {echo ' hide';} ?>" id="client-show-primary-contact-wrapper">
                  <div class="checkbox checkbox-info mbot20 no-mtop">
                     <input type="checkbox" name="show_primary_contact"<?php if(isset($client) && $client->show_primary_contact == 1){echo ' checked';}?> value="1" id="show_primary_contact">
                     <label for="show_primary_contact"><?php echo _l('show_primary_contact',_l('invoices').', '._l('estimates').', '._l('payments').', '._l('credit_notes')); ?></label>
                  </div>
               </div>
               <div class="col-md-6">
                  <?php $value=( isset($client) ? $client->company : ''); ?>
                  <?php $attrs = (isset($client) ? array() : array('autofocus'=>true)); ?>
                  <?php echo render_input( 'company', 'client_company',$value,'text',$attrs); ?>
                  <div id="company_exists_info" class="hide"></div>
                  <?php if(false && get_option('company_requires_vat_number_field') == 1){ // 2022-03-24
                     $value=( isset($client) ? $client->vat : '');
                     echo render_input( 'vat', 'client_vat_number',$value);
                     } ?>
                  <?php $value=( isset($client) ? $client->phonenumber : ''); ?>
                  <?php echo render_input( 'phonenumber', 'client_phonenumber',$value); ?>
                  <?php if((isset($client) && empty($client->website)) || !isset($client)){
                     $value=( isset($client) ? $client->website : '');
                     echo render_input( 'website', 'client_website',$value);
                     } else { ?>
                  <div class="form-group">
                     <label for="website"><?php echo _l('client_website'); ?></label>
                     <div class="input-group">
                        <input type="text" name="website" id="website" value="<?php echo $client->website; ?>" class="form-control">
                        <div class="input-group-addon">
                           <span><a href="<?php echo maybe_add_http($client->website); ?>" target="_blank" tabindex="-1"><i class="fa fa-globe"></i></a></span>
                        </div>
                     </div>
                  </div>
                  <?php }
                     $selected = array();
                     if(isset($customer_groups)){
                       foreach($customer_groups as $group){
                          array_push($selected,$group['groupid']);
                       }
                     }
                     if(is_admin() || get_option('staff_members_create_inline_customer_groups') == '1'){
                      echo render_select_with_input_group('groups_in[]',$groups,array('id','name'),'customer_groups',$selected,'<a href="#" data-toggle="modal" data-target="#customer_group_modal"><i class="fa fa-plus"></i></a>',array('multiple'=>true,'data-actions-box'=>true),array(),'','',false);
                      } else {
                        echo render_select('groups_in[]',$groups,array('id','name'),'customer_groups',$selected,array('multiple'=>true,'data-actions-box'=>true),array(),'','',false);
                      }
                     ?>
                  <?php if(!isset($client)){ ?>
                  <i class="fa fa-question-circle pull-left" data-toggle="tooltip" data-title="<?php echo _l('customer_currency_change_notice'); ?>"></i>
                  <?php }
                     $s_attrs = array('data-none-selected-text'=>_l('system_default_string'));
                     $selected = '';
                     if(isset($client) && client_have_transactions($client->userid)){
                        $s_attrs['disabled'] = true;
                     }
                     foreach($currencies as $currency){
                        if(isset($client)){
                          if($currency['id'] == $client->default_currency){
                            $selected = $currency['id'];
                         }
                      }
                     }
                            // Do not remove the currency field from the customer profile!
                     echo render_select('default_currency',$currencies,array('id','name','symbol'),'invoice_add_edit_currency',$selected,$s_attrs); ?>
                  <?php if(!is_language_disabled()){ ?>
                  <div class="form-group select-placeholder">
                     <label for="default_language" class="control-label"><?php echo _l('localization_default_language'); ?>
                     </label>
                     <select name="default_language" id="default_language" class="form-control selectpicker" data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>">
                        <option value=""><?php echo _l('system_default_string'); ?></option>
                        <?php foreach($this->app->get_available_languages() as $availableLanguage){
                           $selected = '';
                           if(isset($client)){
                              if($client->default_language == $availableLanguage){
                                 $selected = 'selected';
                              }
                           }
                           ?>
                        <option value="<?php echo $availableLanguage; ?>" <?php echo $selected; ?>><?php echo ucfirst($availableLanguage); ?></option>
                        <?php } ?>
                     </select>
                  </div>
                  <?php } ?>
               </div>
               <div class="col-md-6">
                  <?php $value=( isset($client) ? $client->address : ''); ?>
                  <?php echo render_textarea( 'address', 'client_address',$value); ?>
                  <?php $value=( isset($client) ? $client->city : ''); ?>
                  <?php echo render_input( 'city', 'client_city',$value); ?>
                  <?php $value=( isset($client) ? $client->state : ''); ?>
                  <?php echo render_input( 'state', 'client_state',$value); ?>
                  <?php $value=( isset($client) ? $client->zip : ''); ?>
                  <?php echo render_input( 'zip', 'client_postal_code',$value); ?>
                  <?php $countries= get_all_countries();
                     $customer_default_country = get_option('customer_default_country');
                     $selected =( isset($client) ? $client->country : $customer_default_country);
                     echo render_select( 'country',$countries,array( 'country_id',array( 'short_name')), 'clients_country',$selected,array('data-none-selected-text'=>_l('dropdown_non_selected_tex')));
                     ?>
               </div>
            </div>
         </div>
         <?php if(isset($client)){ ?>
         <div role="tabpanel" class="tab-pane" id="customer_admins">
            <?php if (has_permission('customers', '', 'create') || has_permission('customers', '', 'edit')) { ?>
            <a href="#" data-toggle="modal" data-target="#customer_admins_assign" class="btn btn-info mbot30"><?php echo _l('assign_admin'); ?></a>
            <?php } ?>
            <table class="table dt-table">
               <thead>
                  <tr>
                     <th><?php echo _l('staff_member'); ?></th>
                     <th><?php echo _l('customer_admin_date_assigned'); ?></th>
                     <?php if(has_permission('customers','','create') || has_permission('customers','','edit')){ ?>
                     <th><?php echo _l('options'); ?></th>
                     <?php } ?>
                  </tr>
               </thead>
               <tbody>
                  <?php foreach($customer_admins as $c_admin){ ?>
                  <tr>
                     <td><a href="<?php echo admin_url('profile/'.$c_admin['staff_id']); ?>">
                        <?php echo staff_profile_image($c_admin['staff_id'], array(
                           'staff-profile-image-small',
                           'mright5'
                           ));
                           echo get_staff_full_name($c_admin['staff_id']); ?></a>
                     </td>
                     <td data-order="<?php echo $c_admin['date_assigned']; ?>"><?php echo _dt($c_admin['date_assigned']); ?></td>
                     <?php if(has_permission('customers','','create') || has_permission('customers','','edit')){ ?>
                     <td>
                        <a href="<?php echo admin_url('clients/delete_customer_admin/'.$client->userid.'/'.$c_admin['staff_id']); ?>" class="btn btn-danger _delete btn-icon"><i class="fa fa-remove"></i></a>
                     </td>
                     <?php } ?>
                  </tr>
                  <?php } ?>
               </tbody>
            </table>
         </div>
         <?php } ?>
         <div role="tabpanel" class="tab-pane" id="billing_and_shipping">
            <div class="row">
               <div class="col-md-12">
                  <div class="row">
                     <div class="col-md-6">
                        <h4 class="no-mtop"><?php echo _l('billing_address'); ?> <a href="#" class="pull-right billing-same-as-customer"><small class="font-medium-xs"><?php echo _l('customer_billing_same_as_profile'); ?></small></a></h4>
                        <hr />
                        <?php $value=( isset($client) ? $client->billing_street : ''); ?>
                        <?php echo render_textarea( 'billing_street', 'billing_street',$value); ?>
                        <?php $value=( isset($client) ? $client->billing_city : ''); ?>
                        <?php echo render_input( 'billing_city', 'billing_city',$value); ?>
                        <?php $value=( isset($client) ? $client->billing_state : ''); ?>
                        <?php echo render_input( 'billing_state', 'billing_state',$value); ?>
                        <?php $value=( isset($client) ? $client->billing_zip : ''); ?>
                        <?php echo render_input( 'billing_zip', 'billing_zip',$value); ?>
                        <?php $selected=( isset($client) ? $client->billing_country : '' ); ?>
                        <?php echo render_select( 'billing_country',$countries,array( 'country_id',array( 'short_name')), 'billing_country',$selected,array('data-none-selected-text'=>_l('dropdown_non_selected_tex'))); ?>
                     </div>
                     <div class="col-md-6">
                        <h4 class="no-mtop">
                           <i class="fa fa-question-circle" data-toggle="tooltip" data-title="<?php echo _l('customer_shipping_address_notice'); ?>"></i>
                           <?php echo _l('shipping_address'); ?> <a href="#" class="pull-right customer-copy-billing-address"><small class="font-medium-xs"><?php echo _l('customer_billing_copy'); ?></small></a>
                        </h4>
                        <hr />
                        <?php $value=( isset($client) ? $client->shipping_street : ''); ?>
                        <?php echo render_textarea( 'shipping_street', 'shipping_street',$value); ?>
                        <?php $value=( isset($client) ? $client->shipping_city : ''); ?>
                        <?php echo render_input( 'shipping_city', 'shipping_city',$value); ?>
                        <?php $value=( isset($client) ? $client->shipping_state : ''); ?>
                        <?php echo render_input( 'shipping_state', 'shipping_state',$value); ?>
                        <?php $value=( isset($client) ? $client->shipping_zip : ''); ?>
                        <?php echo render_input( 'shipping_zip', 'shipping_zip',$value); ?>
                        <?php $selected=( isset($client) ? $client->shipping_country : '' ); ?>
                        <?php echo render_select( 'shipping_country',$countries,array( 'country_id',array( 'short_name')), 'shipping_country',$selected,array('data-none-selected-text'=>_l('dropdown_non_selected_tex'))); ?>
                     </div>
                     <?php if(isset($client) &&
                        (total_rows(db_prefix().'invoices',array('clientid'=>$client->userid)) > 0 || total_rows(db_prefix().'estimates',array('clientid'=>$client->userid)) > 0 || total_rows(db_prefix().'creditnotes',array('clientid'=>$client->userid)) > 0)){ ?>
                     <div class="col-md-12">
                        <div class="alert alert-warning">
                           <div class="checkbox checkbox-default">
                              <input type="checkbox" name="update_all_other_transactions" id="update_all_other_transactions">
                              <label for="update_all_other_transactions">
                              <?php echo _l('customer_update_address_info_on_invoices'); ?><br />
                              </label>
                           </div>
                           <b><?php echo _l('customer_update_address_info_on_invoices_help'); ?></b>
                           <div class="checkbox checkbox-default">
                              <input type="checkbox" name="update_credit_notes" id="update_credit_notes">
                              <label for="update_credit_notes">
                              <?php echo _l('customer_profile_update_credit_notes'); ?><br />
                              </label>
                           </div>
                        </div>
                     </div>
                     <?php } ?>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
   <?php echo form_close(); ?>
</div>
<?php if(isset($client)){ ?>
<?php if (has_permission('customers', '', 'create') || has_permission('customers', '', 'edit')) { ?>
<div class="modal fade" id="customer_admins_assign" tabindex="-1" role="dialog">
   <div class="modal-dialog">
      <?php echo form_open(admin_url('clients/assign_admins/'.$client->userid)); ?>
      <div class="modal-content">
         <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title"><?php echo _l('assign_admin'); ?></h4>
         </div>
         <div class="modal-body">
            <?php
               $selected = array();
               foreach($customer_admins as $c_admin){
                  array_push($selected,$c_admin['staff_id']);
               }
               echo render_select('customer_admins[]',$staff,array('staffid',array('firstname','lastname')),'',$selected,array('multiple'=>true),array(),'','',false); ?>
         </div>
         <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
            <button type="submit" class="btn btn-info"><?php echo _l('submit'); ?></button>
         </div>
      </div>
      <!-- /.modal-content -->
      <?php echo form_close(); ?>
   </div>
   <!-- /.modal-dialog -->
</div>
<!-- /.modal -->
<?php } ?>
<?php } ?>
<?php $this->load->view('admin/clients/client_group'); ?>

<?php // 2022-01-18 ?>
<style>
    .customer-profile-btn {
        position: relative;
        top: -10px;
    }
</style>

<script>
    document.addEventListener("DOMContentLoaded", function(event) {
        let $customerType2 =  $('#customers_customer_type');
        let $identificationType2 =  $('#customers_identification_type');
        let companyOptions2 = [['', ''],
            ['Business Registration', '<?php echo _l('opt_business_registration') ?>'],
            ['Others','<?php echo _l('opt_others') ?>']];
        let individualOptions2 = [['',''],
            ['ID Card','<?php echo _l('opt_id_card'); ?>'],
            ['Passport', '<?php echo _l('opt_passport'); ?>'], ['Others', '<?php echo _l('opt_others'); ?>']];

        function initIdentificationType2() {

            if ($customerType2.val() === 'Individual') {
                let currList = [];
                $identificationType2.find('option').each(function(){
                    let val = $(this).val();
                    if ( findValue(val, individualOptions2) === -1 ) {
                        $(this).remove();
                    } else {
                        currList.push($(this).val());
                    }
                });
                $.each(individualOptions2, function(i, v) {
                    if ($.inArray(v[0], currList) === -1 ) {
                        let $option = $('<option value="'+v[0]+'" >'+v[1]+'</option>');
                        $identificationType2.find('option:last').before($option);
                    }
                });
            }

            if ($customerType2.val() === 'Company') {
                let currList = [];
                $identificationType2.find('option').each(function(){
                    let val = $(this).val();
                    if ( findValue(val, companyOptions2) === -1 ) {
                        $(this).remove();
                    } else {
                        currList.push($(this).val());
                    }
                });
                $.each(companyOptions2, function(i, v) {
                    if ( $.inArray(v[0], currList) === -1 ) {
                        let $option = $('<option value="'+v[0]+'" >'+v[1]+'</option>');
                        $identificationType2.find('option:last').before($option);
                    }
                });
            }

            $identificationType2.selectpicker('refresh');
        }

        function findValue(val, pairList) {
            for (let i=0 ; i<pairList.length ; i++) {
                let item = pairList[i];
                if (item[0] == val) {
                    return i;
                }
            }
            return -1;
        }

        initIdentificationType2()
        $customerType2.on('change', function(){
            initIdentificationType2();
        });

        //=========================
        let $clientPortalID = $('[name="custom_fields[customers][16]"]'); // 2022-01-20
        let $customerType = $('[name="custom_fields[customers][17]"]');
        let $identificationType = $('[name="custom_fields[customers][22]"]');
        let companyOptions = ['', 'Business Registration', 'Others'];
        let individualOptions = ['', 'ID Card', 'Passport', 'Others'];

        function initIdentificationType() {

            if ($customerType.val() === 'Individual') {
                let currList = [];
                $identificationType.find('option').each(function(){
                    let val = $(this).val();
                    if ( $.inArray(val, individualOptions) === -1 ) {
                        $(this).remove();
                    } else {
                        currList.push($(this).val());
                    }
                });
                $.each(individualOptions, function(i, v) {
                    if ($.inArray(v, currList) === -1 ) {
                        let $option = $('<option value="'+v+'" >'+v+'</option>');
                        $identificationType.find('option:last').before($option);
                    }
                });
                $('[name="custom_fields[customers][16]"]').closest('.col-md-12').show();
                $('.customer-profile-btn').show("slow");
            }

            if ($customerType.val() === 'Company') {
                let currList = [];
                $identificationType.find('option').each(function(){
                    let val = $(this).val();
                    if ( $.inArray(val, companyOptions) === -1 ) {
                        $(this).remove();
                    } else {
                        currList.push($(this).val());
                    }
                });
                $.each(companyOptions, function(i, v) {
                    if ( $.inArray(v, currList) === -1 ) {
                        let $option = $('<option value="'+v+'" >'+v+'</option>');
                        $identificationType.find('option:last').before($option);
                    }
                });
                $('[name="custom_fields[customers][16]"]').closest('.col-md-12').show("slow");
                $('.customer-profile-btn').show("slow");
            }

            // 2022-02-10
            if ($customerType.val() === 'Vendor') {
                $('[name="custom_fields[customers][16]"]:visible').rules('remove', 'required'); //.rules("remove", "required")
                $('[name="custom_fields[customers][16]"]').closest('.col-md-12').hide("slow");
                $('[name="custom_fields[customers][16]"]').val('');
                $('.customer-profile-btn').hide("slow");
            } else {
                $('[name="custom_fields[customers][16]"]:visible').rules('add', { 'required' :  true });
                $('[name="custom_fields[customers][16]"]').closest('.col-md-12').show("slow");
                $('.customer-profile-btn').show("slow");
            }
            // $customerType = $('[name="custom_fields[customers][17]"]');
            //   $customerType.on('change', function(){
            //       initIdentificationType();
            //   });

            $identificationType.selectpicker('refresh');
        }



        initIdentificationType()
        $customerType.on('change', function(){
            initIdentificationType();
        });

        function disableButton($obj) {
            $($obj).prop('disable', true).text('<?php echo _l('checking'); ?>').css('opacity',0.3);
        }
        function enableButton($obj) {
            $($obj).prop('disable', false).text('<?php echo _l('check_id_duplication'); ?>').css('opacity', 1);
        }

        // 2022-01-20
        // Check ID duplication of Client Portal ID
        $('#check_id_depu').on('click', function(){
            checkIdExist(null);
        });

        $('#create_eshop_acc').on('click', function(){
            checkIdExist(function() {
                $('#modalLoginForm').modal('show');
            });
        });

        function checkIdExist(acceptCallBack){
            let url = '<?php echo admin_url('usercontrol/Depucheck/clientportalid/'); ?>';
            let id_code = $clientPortalID.val();
            let cid = $('[name=userid]').val();
            if (id_code.length == 0) {
                alert('<?php echo _l( 'portal_id_cannot_empty'); ?>');
                return;
            }

            // Check client portal id does no one registered in Client ZUU server
            btnObj = $('#check_id_depu');
            disableButton(btnObj);
            $.ajax({
                type: 'POST',
                url: url,
                dataType: 'JSON',
                data: { customer_id : cid, customer_code : id_code },
                success: function(resp) {
                    if (resp.rscode){
                        if (resp.rscode==200) {
                            if (resp.found) {
                                let msg = '<?php echo _l('portalid__found'); ?>';
                                alert_float('warning', msg);
                            } else {
                                if (acceptCallBack != null) {
                                    acceptCallBack();
                                } else {
                                    let msg = '<?php echo _l('portalid_not_found'); ?>';
                                    alert_float('success', msg);
                                }
                            }
                        } else {
                            let msg = '<?php echo _l('access_failed'); ?>';
                            alert_float('danger', msg);
                        }
                    }
                    enableButton(btnObj);
                },
                error: function(){
                    let msg = '<?php echo _l('access_failed'); ?>';
                    alert_float('danger', msg);
                    enableButton(btnObj);
                }
            });
        }

        $('#reg-button').on('click', function(){
                let email = $("#defaultForm-email").val();
                let passw = $("#defaultForm-pass").val();
                if (! ValidateEmail(email)) {
                    alert('Invalid email form, please input again!');
                    return;
                }

                if (passw === undefined || passw.length < 6) {
                    alert('Please input password at least 6 characters long!');
                    return;
                }

                startCreateAcc();
        });

        function startCreateAcc() {
            let email = $("#defaultForm-email").val();
            let passw = $("#defaultForm-pass").val();
            setTimeout(function(){
                $("#defaultForm-email").val('');
                $("#defaultForm-pass").val('');
                sendOutCreateAcc(email, passw);
            }, 500);
            $('#modalLoginForm').modal('hide');
        }

        function ValidateEmail(emailString) {
            if (emailString === undefined) return false;
            var atSymbol = emailString.indexOf("@");
            if(atSymbol < 1) return false;
            var dot = emailString.indexOf(".");
            // if(dot <= atSymbol + 1) return false;
            if (dot === emailString.length - 1) return false;
            return true;
        }

        function sendOutCreateAcc(email, passw) {
            let portal_id = $('[name="custom_fields[customers][16]"').val();
            let cid = $('[name=userid]').val();

            if (portal_id == '') {
                alert('<?php echo _l( 'portal_id_cannot_empty'); ?>');
                return;
            }

            let data = { email : email, password : passw, customer_id : cid, portal_id : portal_id  };

            let url = '<?php echo admin_url('usercontrol/Depucheck/createaccount/'); ?>';

            let btnObj = $('#create_eshop_acc');
            disableButton(btnObj);
            $.ajax({
                type: 'POST',
                url: url,
                dataType: 'JSON',
                data: { email : email, password : passw, customer_id : cid, portal_id : portal_id  },
                success: function (resp) {
                    let msg = '';
                    if (resp.rscode) {
                        if (resp.rscode == 200) {
                            msg = '<?php echo _l('account_created'); ?>';
                            alert(msg);
                            location.reload();
                        } else if (resp.rscode == 400) {
                            msg = resp.error_msg;
                            //alert_float('danger', msg);
                        } else {
                            msg = '<?php echo _l('fail_to_create_acc'); ?>';
                            //alert_float('danger', msg);
                        }
                        //alert(msg);
                    }
                    enableButton(btnObj);
                    alert(msg);
                },
                error: function () {
                    let msg = '<?php echo _l('access_failed'); ?>';
                    //alert_float('danger', msg);
                    enableButton(btnObj,);
                    alert(msg);
                }
            });

        }

    });


</script>
<div class="modal fade" id="modalLoginForm" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
     aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header text-center">
                <h4 class="modal-title w-100 font-weight-bold"><?php echo _l('signin_info'); ?></h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body mx-3">
                <div class="md-form mb-5">
                    <i class="fas fa-envelope prefix grey-text"></i>
                    <input type="email" id="defaultForm-email" class="form-control validate">
                    <label data-error="wrong" data-success="right" for="defaultForm-email"><?php echo _l('your_email'); ?></label>
                </div>

                <div class="md-form mb-4">
                    <i class="fas fa-lock prefix grey-text"></i>
                    <input type="password" id="defaultForm-pass" class="form-control validate">
                    <label data-error="wrong" data-success="right" for="defaultForm-pass"><?php echo _l('your_password'); ?></label>
                </div>

            </div>
            <div class="modal-footer d-flex justify-content-center">
                <button class="btn btn-default" id="reg-button"><?php echo _l('registration'); ?></button>
            </div>
        </div>
    </div>
</div>

<!--
<div class="text-center">
    <a href="" class="btn btn-default btn-rounded mb-4" data-toggle="modal" data-target="#modalLoginForm">
        <?php echo _l('portal_registration_form'); ?></a>
</div>
-->