<?php

defined('BASEPATH') or exit('No direct script access allowed');

$aColumns = [
    'description',
    'date',
    db_prefix().'activity_log.staffid',
    ];

// 2022-03-25
$sa = [];
if (! is_admin() || is_sys_oper()) {
	$users = $this->ci->db->where('admin = 1 AND sys_oper = 0')->get(db_prefix().'staff')->result_array();
	foreach($users as $user) {
		$name = trim($user['firstname'].' '.$user['lastname']);
		$sa[] = $name;
	}
}

$sWhere = [];

// 2022-03-25
if ($sa) {
	array_push($sWhere, ' AND staffid NOT IN ( "'.implode('","',$this->ci->db->escape_like_str($sa)).'" )');
}


if ($this->ci->input->post('activity_log_date')) {
    array_push($sWhere, 'AND date LIKE "' . $this->ci->db->escape_like_str(to_sql_date($this->ci->input->post('activity_log_date'))) . '%" ESCAPE \'!\'');
}
$sIndexColumn = 'id';
$sTable       = db_prefix().'activity_log';
$result       = data_tables_init($aColumns, $sIndexColumn, $sTable, [], $sWhere);
$output       = $result['output'];
$rResult      = $result['rResult'];
foreach ($rResult as $aRow) {
    $row = [];
    for ($i = 0; $i < count($aColumns); $i++) {
        $_data = $aRow[$aColumns[$i]];
        if ($aColumns[$i] == 'date') {
            $_data = _dt($_data);
        }
        $row[] = $_data;
    }
    $output['aaData'][] = $row;
}
