<?php

function mkOutFolder($mainFolder, $currLangFile) {
	// Make folders
	$parts = explode('/',$currLangFile);
	if (count($parts) > 1) {
		unset($parts[count($parts)-1]);
		$mkFolder = $mainFolder.implode('/', $parts);
		mkdir($mkFolder, 0777, true);
	}
}

function translateInternal($list,$from,$to) {
	$fromFile = dirname(__FILE__).'/translate_int/'.$from.'.php';
	if (! file_exists($fromFile)) {
		return false;
	}
	$toFile = dirname(__FILE__).'/translate_int/'.$to.'.php';
	if (! file_exists($toFile)) {
		return false;
	}

	$fromLang = getFileLang($fromFile);
	$toLang = getFileLang($toFile);

	$result = [];
	//$list = explode("\n", $text);
	foreach ($list as $txt) {
		$txt = trim($txt);
		$key = array_search($txt, $fromLang);
		if ($key === false) {
			$value = '';
		} else {
			$value = $toLang[$key];
		}
		$result[] = $value;
	}
	if (! $result) {
		return false;
	}
	return $result;
}

function getFileLang($filePath) {
	require $filePath;
	return $lang;
}

function getData_Curl($url,$postData=false){
	if( !extension_loaded('curl') ){
		echo 'You need to load/activate the cURL extension (http://www.php.net/cURL).';
		return false;
	}
	$useragent = "Mozilla/5.0 (Windows NT 5.1; rv:9.0.1) Gecko/20100101 Firefox/9.0.1";

	$curlHandle = curl_init(); // init curl
	curl_setopt($curlHandle, CURLOPT_COOKIEJAR,"cookie");
	curl_setopt($curlHandle, CURLOPT_COOKIEFILE,"cookie");
	curl_setopt($curlHandle, CURLOPT_USERAGENT, $useragent);
	curl_setopt($curlHandle, CURLOPT_URL, $url); // set the url to fetch
	curl_setopt($curlHandle, CURLOPT_HEADER, 0); // set headers (0 = no headers in result)
	curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, 1); // type of transfer (1 = to string)
	curl_setopt($curlHandle, CURLOPT_TIMEOUT, 10); // time to wait in
	curl_setopt($curlHandle, CURLOPT_POST, 0);
	if ( $postData!==false ) {
		curl_setopt($curlHandle, CURLOPT_POSTFIELDS, http_build_query($postData));
	}
	$content = curl_exec($curlHandle); // make the call
	curl_close($curlHandle); // close the connection
	return $content;
}

