<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Victory Theme
Description: Victory theme for CRM
Version: 1.0.0
Author: Developed by tag.digital Limited
Requires at least: 2.3.2
*/

define('ADMIN_LIGHT_THEME_MODULE_NAME', 'admin_light_theme');

$CI = &get_instance();

/**
 * Load the chat helper
 */
$CI->load->helper(ADMIN_LIGHT_THEME_MODULE_NAME . '/admin_light_theme');
/**
 * Register the activation chat
 */
register_activation_hook(ADMIN_LIGHT_THEME_MODULE_NAME, 'admin_light_theme_activation_hook');
/**
 * The activation function
 */
function admin_light_theme_activation_hook()
{
	require(__DIR__ . '/install.php');
}


hooks()->add_action('app_admin_head', 'admin_light_theme_admin_head');
hooks()->add_action('app_admin_authentication_head', 'admin_light_theme_admin_head');
hooks()->add_action('app_customers_head', 'admin_light_theme_clients_area_head');
hooks()->add_filter('module_admin_light_theme_action_links', 'admin_light_theme_action_links');
hooks()->add_action('admin_init', 'light_theme_style_init_menu_items');

/**
 * Add additional settings for this module in the module list area
 * @param  array $actions current actions
 * @return array
 */
function admin_light_theme_action_links($actions)
{
    $actions[] = '<a href="' . admin_url('admin_light_theme') . '">' . _l('settings') . '</a>';

    return $actions;
}
/**
 * Admin area applied styles
 * @return null
 */
function admin_light_theme_admin_head()
{
    admin_light_theme_render();
    // admin_light_theme_custom_css();
}

function admin_light_theme_clients_area_head()
{
    admin_light_theme_render();
    // admin_light_theme_custom_css();

  echo '
  <script>
      jQuery(document).ready(function() {
          $(".login-heading").html("'. admin_light_theme_lang(). '");    
      });
</script>      
    ';

}

// function admin_light_theme_lang2() {
//   $lang = $_COOKIE['contact_language'];
//   if (! $lang) {
//     $lang = 'english';
//   }        
//   $path =  dirname(__FILE__,4).'/modules/admin_light_theme/language/'.$lang.'/admin_light_theme'.'_lang.php';         
//   $lang = [];
//   require $path;
//   return $lang['admin_auth_login_welcome_back'];
// }


function admin_light_theme_custom_css()
{
    $colorArray = [
        "--body-bg-main"=> "#F4F5F7",
        "--color-secondary" =>"#660099",
        "--color-primary"=> "#2b187c",
        "--color-theme-100"=> "#FFFFFF",
        "--color-theme-200"=> "#F9F9F9",
        "--color-theme-300"=> "#EEEEEE",
        "--color-theme-400"=> "#DADADA",
        "--color-theme-500"=> "#BDBDBD",
        "--color-theme-600"=> "#8E8E8E",
        "--color-theme-700"=> "#737373",
        "--color-theme-800"=> "#616161",
        "--color-theme-900"=> "#373737",
        "--color-primary-700"=> "#5D2BFF",
        "--color-primary-800"=> "#4A21CD",
        "--color-primary-900"=> "#2b187c",
        "--color-secondary-700"=> "#5D2BFF",
        "--color-secondary-800"=> "#4A21CD",
        "--color-secondary-900"=> "#2b187c",
        "--color-sucess-green"=> "#64CD93",
        "--page-paper-main"=> "#FFFFFF",
        "--border-primary"=> "#DADADA",
        "--top-bar-background-color"=> "#DADADA",
        "--footbar-background-color"=> "#3abcd2"
    ];
    if (!get_option('admin_light_theme')){
        $admin_color = $colorArray;
        // $strJsonFileContents = file_get_contents("modules/admin_light_theme/admin-color.json");
        // $admin_color = json_decode($strJsonFileContents, true);
     }else{
        $admin_color = json_decode(get_option("admin_light_theme"), true);
        $admin_color = array_merge($admin_color,$colorArray);
     }
     echo "<style type='text/css'>\n:root{\n" . PHP_EOL;
        foreach ($admin_color as $key => $val) { 
          echo $key .":" .$val . ";\n" . PHP_EOL;
  
        }
     
    echo "} </style>" . PHP_EOL;
}


/**
 * Init theme style module menu items in setup in admin_init hook
 * @return null
 */
function light_theme_style_init_menu_items()
{
    if (is_admin()) {
        $CI = &get_instance();
        /**
         * If the logged in user is administrator, add custom menu in Setup
         */
        $CI->app_menu->add_setup_menu_item('admin_theme_light', [
            'href'     => admin_url('admin_light_theme'),
            'name'     => _l('Victory_Theme'),
            'position' => 65,
        ]);
    }
}


// echo "<script>console.log('".login_page_get_data()."');</script>";