<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Admin_light_theme extends AdminController
{
    public function __construct()
    {
        parent::__construct();

        if (!is_admin()) {
            access_denied('Admin_light_theme');
        }
    }
    public function index()
    {
        $data['title'] = _l('admin_light_theme');
        $this->load->view('admin_light_theme', $data);
    }

    public function reset()
    {
        $admin_color = [
            "--body-bg-main"=> "#F4F5F7",
            "--color-secondary" =>"#660099",
            "--color-primary"=> "#2b187c",
            "--color-theme-100"=> "#FFFFFF",
            "--color-theme-200"=> "#F9F9F9",
            "--color-theme-300"=> "#EEEEEE",
            "--color-theme-400"=> "#DADADA",
            "--color-theme-500"=> "#BDBDBD",
            "--color-theme-600"=> "#8E8E8E",
            "--color-theme-700"=> "#737373",
            "--color-theme-800"=> "#616161",
            "--color-theme-900"=> "#373737",
            "--color-primary-700"=> "#5D2BFF",
            "--color-primary-800"=> "#4A21CD",
            "--color-primary-900"=> "#2b187c",
            "--color-secondary-700"=> "#5D2BFF",
            "--color-secondary-800"=> "#4A21CD",
            "--color-secondary-900"=> "#2b187c",
            "--color-sucess-green"=> "#64CD93",
            "--page-paper-main"=> "#FFFFFF",
            "--border-primary"=> "#DADADA",
        "--top-bar-background-color"=> "#DADADA",
        "--footbar-background-color"=> "#3abcd2"
        ];
        add_option('admin_light_theme', json_encode($admin_color, true));
        redirect(admin_url('admin_light_theme'));
    }

    public function save()
    {
        
        update_option('admin_light_theme', $this->input->post('data'));

  
    }
}