<?php
/*
Module Name: Victory Theme
Description: blue flat elegant theme for Victory CRM
Version: 1.0.0
Author: tag.digital
Author URI: https://tag.digital
Requires at least: 2.3.2
*/
defined('BASEPATH') or exit('No direct script access allowed');

hooks()->add_action('app_admin_head', 'admin_light_theme_head_component');
hooks()->add_action('app_admin_footer', 'admin_light_theme_footer_js__component');
hooks()->add_action('admin_init', 'admin_light_theme_settings_tab');
hooks()->add_action('app_admin_authentication_head', 'admin_light_theme_staff_login');
$strJsonFileContents = file_get_contents("modules/admin_light_theme/admin-color.json");

$admin_color = json_decode($strJsonFileContents, true);
// $GLOBALS['body_bg_main'] = $admin_color["body_bg_main"];
// Check if customers theme is enabled
if (get_option('admin_light_theme_customers') == '1') {
    hooks()->add_action('app_customers_head', 'app_client_light_head_includes');
    hooks()->add_action('app_customers_footer', 'admin_light_theme_footer_js__component');
}

/**
 * Theme customers login includes
 * @return stylesheet / script
 */
function admin_light_theme_staff_login()
{
  // $language = get_option('active_language');
  //    echo '<link href="' . base_url('modules/admin_light_theme/assets/css/staff_login_styles.css') . '"  rel="stylesheet" type="text/css" >';
  //    echo '<script src="' . module_dir_url('admin_light_theme', 'assets/js/sign_in.js') . '"></script>';

  // 2022-01-19
  if (! isset($language)) {
      $language = get_option('active_language');
  }
  $login_page =json_encode(login_page_get_data());
  	  $admin_copyright = '© '.addslashes(date('Y').' '.  _l('clients_copyright', get_option('companyname'))); // 2202-04-20
      echo '<link href="' . base_url('modules/admin_light_theme/assets/css/admin_login.css') . '?' . rand() . '"  rel="stylesheet" type="text/css" >';
      echo '<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>';
      echo '<script> var login_page = '.$login_page .';var site_url = "' . site_url() .'";var language = "'. $language .'";var admin_copyright="'.$admin_copyright.'";</script>'; // 2202-04-20
  echo '<script src="' . module_dir_url('admin_light_theme', 'assets/js/weather.js').'?'.rand() . '"></script>';


  echo '
  <script>
      jQuery(document).ready(function() {
          $(".authentication-form h1").html("'. admin_light_theme_lang(). '");    
      });
</script>      
    ';

}

function admin_light_theme_lang() {
  $lang = $_COOKIE['contact_language'];
  $lang = urldecode($lang);
  if (! $lang) {
    $lang = 'english';
  }
  $path =  dirname(__FILE__,2).'/language/'.$lang.'/admin_light_theme'.'_lang.php';
  if (! file_exists($path)) {
        $lang = 'english';
        $path =  dirname(__FILE__,2).'/language/'.$lang.'/admin_light_theme'.'_lang.php';
  }
  $lang = [];
  require $path;
  return $lang['admin_auth_login_welcome_back'];
}


/**
 * Theme clients footer includes
 * @return stylesheet
 */
function app_client_light_head_includes()
{
//    echo '<link href="' . base_url('modules/admin_light_theme/assets/css/clients/clients.css') . '"  rel="stylesheet" type="text/css" >';
//    echo '<link href="' . base_url('modules/admin_light_theme/assets/css/animated.css') . '"  rel="stylesheet" type="text/css" >';
//    echo '<script src="' . module_dir_url('admin_light_theme', 'assets/js/third-party/waves076.min.js') . '"></script>';
//    echo '<script src="' . module_dir_url('admin_light_theme', 'assets/js/third-party/nanobar.js') . '"></script>';
echo '<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>';
if (is_client_logged_in()) {
echo '<link href="' . base_url('modules/admin_light_theme/assets/css/style.css') . '?' . rand() . '" rel="stylesheet" type="text/css" >';
echo '<link href="' . base_url('modules/admin_light_theme/assets/css/admin.css') . '?' . rand() . '"  rel="stylesheet" type="text/css" >';
}
    echo '<link href="' . base_url('modules/admin_light_theme/assets/css/client.css') . '?' . rand() . '"  rel="stylesheet" type="text/css" >';
}

/**
 * [admin_light_theme_settings_tab net menu item in setup->settings]
 * @return void
 */
function admin_light_theme_settings_tab()
{
    $CI = &get_instance();
    $CI->app_tabs->add_settings_tab('admin-theme-settings', [
        'name'     => '' . _l('Victory Theme') . '',
        'view'     => 'admin_light_theme/admin_theme_settings',
        'position' => 46,
    ]);
}

/**
 * Injects theme CSS
 * @return null
 */


function admin_light_theme_head_component()
{



//    echo '<link href="' . base_url('modules/admin_light_theme/assets/css/animated.css') . '"  rel="stylesheet" type="text/css" >';
//    echo '<script src="' . module_dir_url('admin_light_theme', 'assets/js/third-party/nanobar.js') . '"></script>';
//    echo '<script src="' . module_dir_url('admin_light_theme', 'modules/admin_light_theme/assets/weather.js') . '"></script>';
    echo '<link href="' . base_url('modules/admin_light_theme/assets/css/vendor-admin.css') . '?' . rand() . '" rel="stylesheet" type="text/css" >';
    echo '<link href="' . base_url('modules/admin_light_theme/assets/css/style.css') . '?' . rand() . '" rel="stylesheet" type="text/css" >';
    echo '<link href="' . base_url('modules/admin_light_theme/assets/css/admin.css') . '?' . rand() . '"  rel="stylesheet" type="text/css" >';

    // $weather = new DOMDocument();
    //       $weather -> load("http://rss.weather.gov.hk/rss/CurrentWeather_big5.xml");
    //       $temp=$weather->getElementsByTagName('item')->item(0)->getElementsByTagName('description')->item(0)->childNodes->item(0)->nodeValue;
    //       $temp = iconv("UTF-8", "big5", $temp);
}

/**
 * Injects theme js components in footer
 * @return null
 */
function admin_light_theme_footer_js__component()
{
//    echo '<script src="' . module_dir_url('admin_light_theme', 'assets/js/clients.js') . '"></script>';

}
function render_light_theme_styling_picker($value,$id)
{
    echo '<div class="input-group mbot15 colorpicker-component" ><input type="text" value="' . $value . '" data-id="' . $id . '" class="form-control" />
    <span class="input-group-addon"><i></i></span></div>';
}
// function theme_style_render($type)
function admin_light_theme_render()
{
    if (empty(get_option("admin_light_theme"))){
        $strJsonFileContents = file_get_contents("modules/admin_light_theme/admin-color.json");
        $admin_color = json_decode($strJsonFileContents, true);
     }else{
        $admin_color = json_decode(get_option("admin_light_theme"), true);
     }
     echo "<style type='text/css'>\n:root{\n" . PHP_EOL;
        foreach ($admin_color as $key => $val) {
          echo $key .":" .$val . ";\n" . PHP_EOL;

        }

    echo "} </style>" . PHP_EOL;
}