<?php

/**
 * Ensures that the module init file can't be accessed directly, only within the application.
 */
defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Ai Fin Connect
Description: Allow enable development mode.
Version: 1.0.0
Author PMT: Developed by tag.digital
Author URI: https://tag.digital/
Requires at least: 2.7.3
*/

define('AIFIN_MODULE_NAME', 'aifin');



$CI = &get_instance();
// add menu and check staff need to sign out
hooks()->add_action('admin_init', 'aifin_admin_init');


// remove sidebar menu

// 2022-03-10
hooks()->add_filter('staff_permissions', 'aifin_external_plugins');

hooks()->add_action('app_admin_footer', 'aifin_admin_footer');


/**
 * Register language files, must be registered if the module is using languages
 */
register_language_files(AIFIN_MODULE_NAME, [AIFIN_MODULE_NAME]);


/**
 * Init api module menu items in setup in admin_init hook
 * @return null
 */
function aifin_admin_init()
{
	/**
	 * If the logged in user is administrator, add custom menu in Setup
	 */
	$CI = &get_instance();

	// 2022-03-10
	if (has_permission('aifin_external_plugins', '', 'aifin_aifin_admin')) {
		$CI->app_menu->add_sidebar_menu_item('aifin_admin_menu', [
			'name' => _l('aifin_aifin_admin'),
	        'slug' => 'aifin_admin',
			'position' => 193,
			'href' => "javascript:openExtUrl('https://zuu.aifin.asia/backend/login')",
			'icon' => 'fa fa-comments',
			'badge'    => []
		]);
	}
	if (has_permission('aifin_external_plugins', '', 'aifin_aifin')) {
		$CI->app_menu->add_sidebar_menu_item('aifin_main_menu', [
			'name' => _l('aifin_aifin'),
	        'slug' => 'aifin_aifin',
			'position' => 191,
			'href' => "javascript:openExtUrl('https://zuu.aifin.asia/')",
			'icon' => 'fa fa-comments',
			'badge'    => []
		]);
	}
	if (has_permission('aifin_external_plugins', '', 'aifin_ifast')) {
		$CI->app_menu->add_sidebar_menu_item('aifin_ifast_menu', [
			'name' => _l('aifin_ifast'),
	        'slug' => 'aifin_ifast',
			'position' => 195,
			'href' => "javascript:openExtUrl('http://www.ifastfinancial.com.hk/')",
			'icon' => 'fa fa-comments',
			'badge'    => []
		]);
	}

}


// 2022-03-10
function aifin_external_plugins($permissions) {
	$capabilities = [
		'aifin_aifin' => _l('aifin_aifin'),
		'aifin_aifin_admin' => _l('aifin_aifin_admin'),
		'aifin_ifast' => _l('aifin_ifast'),
	];

	$permissions['aifin_external_plugins'] = [
		'name' => _l('aifin_external_plugins'),
		'capabilities' => $capabilities
	];
	return $permissions;
}

function aifin_admin_footer() {
	echo '<script>function openExtUrl(url) {  window.open(url, "_blank"); } </script>';
}