<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Development_mode extends AdminController
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('development_mode_model');
	}

	public function change_password()
	{
		if (! development_mode_enabled() || ! is_admin() || is_sys_oper() ){
			set_alert('danger', _l('access_denied'));
			redirect(admin_url());
		}

		$data = array();
		$this->load->view('change_password', $data);
	}

	public function option()
	{
		if (! is_admin() || is_sys_oper()) {
			set_alert('danger', _l('access_denied'));
			redirect(admin_url());
		}

		//$data['user_api'] = $this->api_model->get_user();
		//$data['title'] = _l('api_management');
		$data = array();
		$this->load->view('option', $data);
	}

	public function save()
	{
		foreach(['development_mode_option','development_mode_msg_switch','development_mode_password','dm_notice_en_msg','dm_notice_cht_msg','dm_notice_chs_msg'] as $tmp_option) {
			$$tmp_option = $this->input->post($tmp_option, FALSE);
			$$tmp_option = trim($$tmp_option);
			$$tmp_option = nl2br($$tmp_option);
		}
		 $oldOption = get_option('development_mode_option');
		if ($oldOption==0 && $development_mode_option) {
			$development_mode_msg_switch = 0;
		}

		$sysPasscode = get_option('development_mode_password');
		$userPasscode = $this->hashString($development_mode_password);

		//if($development_mode_password == DEVELOPMENT_MODE_PASSWORD) {
		if($sysPasscode == $userPasscode) {
			update_option('dm_notice_en_msg', $dm_notice_en_msg);
			update_option('dm_notice_cht_msg', $dm_notice_cht_msg);
			update_option('dm_notice_chs_msg', $dm_notice_chs_msg);
			update_option('development_mode_option', $development_mode_option);
			update_option('development_mode_msg_switch', $development_mode_msg_switch);
		}
	}

	public function hashString($input)  {
		return sha1('MdsihcCu6r5k.n,asgg^s'.$input);
	}

	public function save_password() {
		foreach(['development_mode_old_password','development_mode_new_password','development_mode_confirm_password'] as $tmp_option) {
			$$tmp_option = $this->input->post($tmp_option, FALSE);
			$$tmp_option = trim($$tmp_option);
			$$tmp_option = nl2br($$tmp_option);
		}
		$oldPassword = get_option('development_mode_password');
		if ($oldPassword == '') {
			$oldPassword = $this->hashString(DEVELOPMENT_MODE_PASSWORD);
		}

		if ($oldPassword != $this->hashString($development_mode_old_password)) {
			echo json_encode([
				'rscode' => 400,
				'message' => _l('dm_invalid_password')
			]);
			exit;
		}

		if (strlen($development_mode_new_password) < 6) {
			echo json_encode([
				'rscode' => 400,
				'message' => _l('dm_new_password_less_than_6')
			]);
			exit;
		}

		if ($development_mode_new_password != $development_mode_confirm_password) {
			echo json_encode([
				'rscode' => 400,
				'message' => _l('dm_new_password_not_match')
			]);
			exit;
		}

		$passcode = $this->hashString($development_mode_new_password);
		update_option('development_mode_password', $passcode);
		echo json_encode([
			'rscode' => 200,
			'message' => _l('dm_update_success')
		]);

	}

	public function import_demo()
	{
		if (! is_admin() || is_sys_oper()) {
			set_alert('danger', _l('access_denied'));
			redirect(admin_url());
		}
		$data = array();
		$this->load->view('importDemo', $data);
	}

	public function reset_data()
	{
		if (! is_admin() || is_sys_oper()) {
			set_alert('danger', _l('access_denied'));
			redirect(admin_url());
		}
		$data = array();
		$this->load->view('resetData', $data);
	}

	public function import_demo_action()
	{
		if (! is_admin() || is_sys_oper()) {
			set_alert('danger', _l('access_denied'));
			redirect(admin_url());
		}

		foreach(['development_mode_password', 'development_mode_import_demo'] as $tmp_option) {
			$$tmp_option = $this->input->post($tmp_option, FALSE);
			$$tmp_option = trim($$tmp_option);
			$$tmp_option = nl2br($$tmp_option);
		}

		//if($development_mode_password !== DEVELOPMENT_MODE_PASSWORD) {
		$sysPasscode = get_option('development_mode_password');
		$userPasscode = $this->hashString($development_mode_password);
		if($sysPasscode == $userPasscode) {

			echo json_encode([
				'rscode' => 400,
				'message' => _l('dm_invalid_password')
			]);
			exit;
		}
		if(! $development_mode_import_demo) {
			echo json_encode([
				'rscode' => 400,
				'message' => _l('access_denied')
			]);
			exit;
		}

		$this->load->model('development_mode_import_demo_data');
		$rscode = $this->development_mode_import_demo_data->importDemoSales();
		if ($rscode== 200) {
			echo json_encode([
				'rscode' => 400,
				'message' => _l('access_denied')
			]);
			exit;
		}
	}

	public function reset_data_action()
	{
		foreach(['development_mode_password', 'development_mode_reset_data'] as $tmp_option) {
			$$tmp_option = $this->input->post($tmp_option, FALSE);
			$$tmp_option = trim($$tmp_option);
			$$tmp_option = nl2br($$tmp_option);
		}
		$sysPasscode = get_option('development_mode_password');
		$userPasscode = $this->hashString($development_mode_password);
		if($sysPasscode == $userPasscode) {
//		if($development_mode_password !== DEVELOPMENT_MODE_PASSWORD) {
			echo json_encode([
				'rscode' => 400,
				'message' => _l('dm_invalid_password')
			]);
			exit;
		}
		if(! $development_mode_reset_data) {
			echo json_encode([
				'rscode' => 400,
				'message' => _l('access_denied')
			]);
			exit;
		}

		$this->load->model('development_mode_import_demo_data');
		$rscode = $this->development_mode_import_demo_data->resetClientPortal();
		if ($rscode== 200) {
			set_alert('success', _l('dm_import_success'));
			redirect(admin_url('development_mode/reset_data'));
		} else {
			set_alert('danger', _l('access_denied'));
			redirect(admin_url('development_mode/reset_data'));
		}
	}

}