<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Development_mode_import_demo_data extends App_Model
{
	private array $tablesInventory = [
		'ware_commodity_type',
		'ware_unit_type',
		'ware_size_type',
		'ware_style_type',
		'ware_body_type',
		'ware_color',
		'items_groups',
		'items',
		'goods_receipt',
		'goods_receipt_detail',
		'goods_transaction_detail',
		'goods_delivery',
		'goods_delivery_detail',
		'inventory_manage',
		'inventory_commodity_min',
		'wh_approval_setting',
		'wh_approval_details',
		'wh_approval_details',
		'wh_loss_adjustment',
		'wh_loss_adjustment_detail',
		'stock_take',
		'stock_take_detail' ];

	private array $tablesSales = [
		'sales_channel',
		'sales_channel_detailt',
		'woocommere_store',
		'woocommere_store_detailt',
		'cart',
		'cart_detailt',
		'omni_master_channel_woocommere',
		'omni_trade_discount',
		'omni_log_discount',
		'omni_trade_discount',
		'omni_log_sync_woo',
		'omni_setting_woo_store',
		'omni_customer_report',
		'omni_create_customer_report',
		'omni_create_customer_report_detail' ];

	private array $tablesLoyalty = [
		'loy_card',
		'loy_rule',
		'loy_rule_detail',
		'loy_redemp_detail',
		'loy_mbs_rule',
		'loy_mbs_program',
		'loy_program_detail',
		'loy_transation' ];

	public function __construct()
	{
		parent::__construct();
	}

	public function importDemoSales() {
		$CI = &get_instance();
		$this->makesalesInventory($CI);
		$this->makeSalesImages($CI);
		$this->makeSalesOmni($CI);
		$this->makeSalesLoyalty($CI);
		//echo 'DONE';
		echo json_encode([
			'rscode' => 200,
			'message' => _l('dm_import_success')
		]);
		exit;
	}

	public function resetClientPortal() {
		$CI = &get_instance();

		foreach ($this->tablesInventory as $table) {
			$this->truncateSalesTable($CI, $table);
		}
		foreach ($this->tablesSales as $table) {
			$this->truncateSalesTable($CI, $table);
		}
		foreach ($this->tablesLoyalty as $table) {
			$this->truncateSalesTable($CI, $table);
		}

		//echo 'DONE';
		echo json_encode([
			'rscode' => 200,
			'message' => _l('dm_reset_success')
		]);
		exit;
	}

	function makeSalesInventory($CI) { // warehouse
		foreach ($this->tablesInventory as $table) {
			$this->truncateSalesTable($CI, $table);
		}

		$table = 'ware_unit_type';
		$this->truncateSalesTable($CI, $table);
		$this->importSalesData($CI, $table,
			"`tblware_unit_type` (`unit_type_id`, `unit_code`, `unit_name`, `unit_symbol`, `order`, `display`, `note`) VALUES
		(2, 'test001', 'Test Unit', 'test', 1, 1, '0'); ");

		$table = 'items_groups';
		$this->truncateSalesTable($CI, $table);
		$this->importSalesData($CI, $table,
			" (`id`, `name`, `commodity_group_code`, `order`, `display`, `note`) VALUES
		(4, 'Digital Product', 'digital product', 1, 1, '0'); ");

		$table = 'items';
		$this->truncateSalesTable($CI, $table);
		$this->importSalesData($CI, $table,
			" (`id`, `description`, `long_description`, `rate`, `tax`, `tax2`, `unit`, `group_id`, `commodity_code`, `commodity_barcode`, `commodity_type`, `warehouse_id`, `origin`, `color_id`, `style_id`, `model_id`, `size_id`, `unit_id`, `sku_code`, `sku_name`, `purchase_price`, `sub_group`, `commodity_name`, `color`, `guarantee`, `profif_ratio`, `active`, `long_descriptions`, `without_checking_warehouse`, `series_id`, `parent_id`, `attributes`, `parent_attributes`) VALUES
		(5, '#phone X', '#Phone x share many of the same features. All-new Pro camera system for better low-light photos and videos, Cinematic mode, and macro photography. Super Retina XDR display with ProMotion for a faster and more responsive experience. A15 Bionic, the fastest chip in a smartphone. Superfast 5G.³ Durable design with Ceramic Shield. And all-day battery life.', 7899.00, 0, NULL, NULL, 4, '#phoneX', '97758650623', 0, 0, '', NULL, 0, 0, 0, 2, '#phone-0010', '#phone ', 7899.00, '', '', '', '', '0', 1, '', 0, NULL, 0, NULL, '[]'),
		(6, '#Pad Nano', '#Pad Nano is meticulously designed to be absolutely beautiful. An all-new enclosure features a new, larger edge-to-edge screen, along with narrow borders and elegant rounded corners.', 4699.00, 0, NULL, NULL, 4, '#Pad Nano', '74789752310', 0, 0, '', NULL, 0, 0, 0, 2, '#Pad-Nano-4621321312', '#Pad Nano', 4599.00, '', '', '', '', '2.1743857360295715', 1, '', 0, NULL, 0, NULL, '[]'),
		(7, 'Hash Watch', 'The stainless steel case is durable and polished to a shiny, mirror-like finish.\n\nThe Braided Solo Loop is made from recycled yarn and silicone threads for an ultracomfortable, stretchable design with no clasps or buckles.', 4988.00, 0, NULL, NULL, 4, 'HashWatch-987654', '27484865049', 0, 0, '', NULL, 0, 0, 0, 2, '00007', 'Hash Watch', 4688.00, '', '', '', '', '6.3993174061433455', 1, '', 0, NULL, 0, NULL, '[]'); ");

		$table = 'goods_receipt';
		$this->truncateSalesTable($CI, $table);
		$this->importSalesData($CI, $table,
			"TRUNCATE TABLE tblgoods_receipt;
		INSERT INTO `tblgoods_receipt` (`id`, `supplier_code`, `supplier_name`, `deliver_name`, `buyer_id`, `description`, `pr_order_id`, `date_c`, `date_add`, `goods_receipt_code`, `warehouse_id`, `total_tax_money`, `total_goods_money`, `value_of_inventory`, `total_money`, `addedfrom`, `approval`, `project`, `type`, `department`, `requester`, `expiry_date`, `invoice_no`) VALUES
		(1, '', 'test', 'test', 1, '', 0, '2022-03-08', '2022-03-08', 'NK4', 2, '0', '859300', '859300', '859300', 1, 1, '', '', 0, 0, '2022-03-08', 'INV-000212221'); ");


		$table = 'goods_receipt_detail';
		$this->truncateSalesTable($CI, $table);
		$this->importSalesData($CI, $table,
			" (`id`, `goods_receipt_id`, `commodity_code`, `commodity_name`, `warehouse_id`, `unit_id`, `quantities`, `unit_price`, `tax`, `tax_money`, `goods_money`, `date_manufacture`, `expiry_date`, `note`, `discount`, `discount_money`, `lot_number`) VALUES
		(1, 1, '5', NULL, '2', '2', '50', '7899', '0', '0', '394950', NULL, NULL, NULL, '', '', ''),
		(2, 1, '6', NULL, '2', '2', '50', '4599', '0', '0', '229950', NULL, NULL, NULL, '', '', ''),
		(3, 1, '7', NULL, '2', '2', '50', '4688', '0', '0', '234400', NULL, NULL, NULL, '', '', ''); ");

		$table = 'goods_transaction_detail';
		$this->truncateSalesTable($CI, $table);
		$this->importSalesData($CI, $table,
			" (`id`, `goods_receipt_id`, `goods_id`, `old_quantity`, `quantity`, `date_add`, `commodity_id`, `warehouse_id`, `note`, `status`, `purchase_price`, `price`, `expiry_date`, `lot_number`, `from_stock_name`, `to_stock_name`) VALUES
		(1, 1, 1, NULL, '50', '2022-03-08 13:18:52', 5, '2', NULL, 1, '7899', NULL, NULL, '', NULL, NULL),
		(2, 1, 2, NULL, '50', '2022-03-08 13:18:52', 6, '2', NULL, 1, '4599', NULL, NULL, '', NULL, NULL),
		(3, 1, 3, NULL, '50', '2022-03-08 13:18:52', 7, '2', NULL, 1, '4688', NULL, NULL, '', NULL, NULL); ");

		$table = 'inventory_manage';
		$this->truncateSalesTable($CI, $table);
		$this->importSalesData($CI, $table,
			" (`id`, `warehouse_id`, `commodity_id`, `inventory_number`, `date_manufacture`, `expiry_date`, `lot_number`) VALUES
		(1, 2, 5, '50', NULL, NULL, ''),
		(2, 2, 6, '50', NULL, NULL, ''),
		(3, 2, 7, '50', NULL, NULL, ''); ");

		$table = 'inventory_commodity_min';
		$this->truncateSalesTable($CI, $table);
		$this->importSalesData($CI, $table,
			" (`id`, `commodity_id`, `commodity_code`, `commodity_name`, `inventory_number_min`, `inventory_number_max`) VALUES
		(1, 5, '#phoneX', '#phone X', '0', '0'),
		(2, 6, '#Pad Nano', '#Pad Nano', '0', '0'),
		(3, 7, 'HashWatch-987654', 'Hash Watch', '0', '0'); ");
	}

	private function makeSalesOmni($CI) { // omni_sales
		foreach ($this->tablesSales as $table) {
			$this->truncateSalesTable($CI, $table);
		}

		$table = 'sales_channel';
		$this->truncateSalesTable($CI, $table);
		$this->importSalesData($CI, $table,
			" (`id`, `channel`, `status`) VALUES
		(1, 'pos', 'active'),
		(2, 'portal', 'active'),
		(3, 'woocommerce', 'deactive'); ");

		$table = 'sales_channel_detailt';
		$this->truncateSalesTable($CI, $table);
		$this->importSalesData($CI, $table,
			" (`id`, `group_product_id`, `product_id`, `sales_channel_id`, `prices`) VALUES
		(1, 4, 5, 2, 7899.00),
		(2, 4, 6, 2, 4699.00),
		(3, 4, 7, 2, 4988.00); ");

		$table = 'omni_log_discount';
		$this->truncateSalesTable($CI, $table);
		$this->importSalesData($CI, $table,
			" (`id`, `name_discount`, `client`, `price`, `product_id`, `product_quality`, `total_product`, `date_apply`, `voucher_coupon`, `order_number`, `total_order`, `discount`, `tax`, `total_after`, `channel_id`) VALUES
		(1, '[]', 1, 0, 0, 0, 0, '2022-03-08 14:18:18', '100', '36NWW1646720298', 'HKD4,699.00', 'HKD500.00', 'HKD0.00', 'HKD4,199.00', NULL),
		(2, '', 1, 0, 0, 0, 0, '2022-03-08 14:19:49', '', '36NZ11646720389', 'HKD7,899.00', 'HKD0.00', 'HKD0.00', 'HKD7,899.00', NULL),
		(3, '', 1, 0, 0, 0, 0, '2022-03-08 14:33:20', '', '36R2Y1646721200', 'HKD25,774.00', 'HKD0.00', 'HKD0.00', 'HKD25,774.00', NULL),
		(4, '', 1, 0, 0, 0, 0, '2022-03-08 14:51:32', '', '36S1M1646722292', 'HKD7,899.00', 'HKD1,000.00', 'HKD0.00', 'HKD6,899.00', NULL),
		(5, '', 1, 0, 0, 0, 0, '2022-03-08 14:55:18', '', '36S3J1646722518', 'HKD7,899.00', 'HKD7,899.00', 'HKD0.00', 'HKD0.00', NULL),
		(6, '', 1, 0, 0, 0, 0, '2022-03-08 15:06:17', '', '36SBV1646723177', 'HKD7,899.00', 'HKD7,899.00', 'HKD0.00', 'HKD0.00', NULL),
		(7, '', 1, 0, 0, 0, 0, '2022-03-08 15:09:40', '', '36SMH1646723380', 'HKD9,398.00', 'HKD0.00', 'HKD0.00', 'HKD9,398.00', NULL),
		(8, '', 1, 0, 0, 0, 0, '2022-03-08 19:20:59', '', '3TQWS1646738459', 'HKD14,675.00', 'HKD1,000.00', 'HKD0.00', 'HKD13,675.00', NULL); ");
	}

	private function makeSalesLoyalty($CI) { // loyalty
		foreach ($this->tablesLoyalty as $table) {
			$this->truncateSalesTable($CI, $table);
		}

		$table = 'loy_card';
		$this->truncateSalesTable($CI, $table);
		$this->importSalesData($CI, $table,
			" (`id`, `name`, `add_from`, `date_create`, `subject_card`, `client_name`, `membership`, `company_name`, `member_since`, `custom_field`, `custom_field_content`, `text_color`) VALUES
	(2, 'Membership Card One', 1, '2022-03-06', 1, 1, 1, 1, 1, 0, '', '#636363'); ");

		$table = 'loy_mbs_rule';
		$this->truncateSalesTable($CI, $table);
		$this->importSalesData($CI, $table,
			" (`id`, `name`, `add_from`, `date_create`, `client_group`, `client`, `loyalty_point_from`, `loyalty_point_to`, `card`, `description`) VALUES
		(1, 'membershipCard', 1, '2022-02-28', 0, '1', 1, 30000, 2, ''); ");

		$table = 'loy_redeem_log';
		$this->truncateSalesTable($CI, $table);
		$this->importSalesData($CI, $table,
			" (`id`, `client`, `cart`, `invoice`, `time`, `old_point`, `new_point`, `redeep_from`, `redeep_to`) VALUES
		(1, 1, 1, 11, '2022-03-08 14:18:18', 30000, 29500, 500, 500.00),
		(2, 1, 0, 13, '2022-03-08 14:36:44', 29500, 28900, 600, 600.00),
		(3, 1, 4, 14, '2022-03-08 14:51:32', 28900, 27900, 1000, 1000.00),
		(4, 1, 5, 15, '2022-03-08 14:55:18', 27900, 20001, 7899, 7899.00),
		(5, 1, 6, 16, '2022-03-08 15:06:17', 20001, 12102, 7899, 7899.00),
		(6, 1, 0, 17, '2022-03-08 18:38:07', 12102, 2714, 9388, 9388.00),
		(7, 1, 8, 18, '2022-03-08 19:20:59', 2714, 1714, 1000, 1000.00); ");

		$table = 'loy_redemp_detail';
		$this->truncateSalesTable($CI, $table);
		$this->importSalesData($CI, $table,
			" (`id`, `loy_rule`, `rule_name`, `point_from`, `point_to`, `point_weight`, `status`) VALUES
		(13, 1, 'Basic Rule', 1, 5000, 1.00, 'enable'),
		(14, 1, 'Advanced Rule', 5001, 10000, 1.00, 'enable'); ");

		$table = 'loy_rule';
		$this->truncateSalesTable($CI, $table);
		$this->importSalesData($CI, $table,
			" (`id`, `subject`, `add_from`, `date_create`, `enable`, `redeemp_type`, `min_poin_to_redeem`, `start_date`, `end_date`, `rule_base`, `minium_purchase`, `poin_awarded`, `purchase_value`, `note`, `redeem_portal`, `redeem_pos`, `client_group`, `client`, `max_amount_received`, `create_account_point`, `birthday_point`) VALUES
		(1, 'Basic Loyalty', 1, '2022-03-05', 1, 'partial', 5, '2022-03-01', '2022-04-30', 'card_total', 5, 200, 1000, '2 month sales', 1, 1, 0, '1', 100, 10000, 500); ");

		$table = 'tblloy_transation';
		$this->truncateSalesTable($CI, $table);
		$this->importSalesData($CI, $table,
			" (`id`, `reference`, `invoice`, `client`, `add_from`, `date_create`, `loyalty_point`, `type`, `note`) VALUES
		(1, 'manual_credit', NULL, 1, 1, '2022-03-01 23:53:13', 10000, 'credit', ''),
		(8, 'manual_credit', NULL, 1, 1, '2022-03-08 14:10:09', 20000, 'credit', ''); ");

	}

	private function makeSalesImages($CI) {
		$table = 'files';
		$CI->db->where('id BETWEEN 9 AND 21');
		$count = $CI->db->count_all_results(db_prefix().$table);
		if (! $count) {
			$this->truncateSalesTable($CI, $table);
			$this->importSalesData($CI, $table,
				" (`id`, `rel_id`, `rel_type`, `file_name`, `filetype`, `visible_to_customer`, `attachment_key`, `external`, `external_link`, `thumbnail_link`, `staffid`, `contact_id`, `task_comment_id`, `dateadded`) VALUES
				(9, 5, 'commodity_item_file', 'iphone-13-pro-silver-select.png', 'image/png', 0, 'c831b1b26c44b2b456a548208e075e66', NULL, NULL, NULL, 1, 0, 0, '2022-03-08 12:56:49'),
				(10, 5, 'commodity_item_file', 'iphone-13-pro-blue-select.png', 'image/png', 0, '11af605e021dd5a7b05d1a0d04bc953a', NULL, NULL, NULL, 1, 0, 0, '2022-03-08 12:56:49'),
				(11, 5, 'commodity_item_file', 'iphone-13-pro-gold-select.png', 'image/png', 0, '46274b8302f58b579ce5cc2011bc859d', NULL, NULL, NULL, 1, 0, 0, '2022-03-08 12:56:50'),
				(12, 5, 'commodity_item_file', 'iphone-13-pro-graphite-select.png', 'image/png', 0, '16aff8177f5d46d89379b13b077b8985', NULL, NULL, NULL, 1, 0, 0, '2022-03-08 12:56:50'),
				(13, 6, 'commodity_item_file', 'ipad-mini-select-wifi-space-gray-202109.png', 'image/png', 0, '6b6bca8b1facb97741cb71326cef58ce', NULL, NULL, NULL, 1, 0, 0, '2022-03-08 13:08:13'),
				(14, 6, 'commodity_item_file', 'ipad-mini-select-wifi-starlight-202109.png', 'image/png', 0, '62b0ecdb194ea4620dd3ee99df7d4b05', NULL, NULL, NULL, 1, 0, 0, '2022-03-08 13:08:13'),
				(15, 6, 'commodity_item_file', 'ipad-mini-select-wifi-pink-202109.png', 'image/png', 0, 'a94d8c1f3d54256dfa6a0db9549a0aaa', NULL, NULL, NULL, 1, 0, 0, '2022-03-08 13:08:13'),
				(16, 6, 'commodity_item_file', 'ipad-mini-select-wifi-purple-202109 (1).png', 'image/png', 0, '25bc0d1e0f56195a6048ddf8a43da4f6', NULL, NULL, NULL, 1, 0, 0, '2022-03-08 13:08:14'),
				(17, 6, 'commodity_item_file', 'ipad-mini-select-wifi-purple-202109.png', 'image/png', 0, '8924fd8e81f2bfe0342ca5a3c480d3b8', NULL, NULL, NULL, 1, 0, 0, '2022-03-08 13:08:14'),
				(18, 7, 'commodity_item_file', 'ML1Q3ref_VW_34FR+watch-45-alum-green-nc-7s_VW_34FR_WF_CO.jpg', 'image/jpeg', 0, '78b8081452b0b2e09bdb0deb9ceb1b7b', NULL, NULL, NULL, 1, 0, 0, '2022-03-08 13:13:23'),
				(19, 7, 'commodity_item_file', 'MKYD3ref_VW_34FR+watch-45-alum-green-nc-7s_VW_34FR_WF_CO.jpg', 'image/jpeg', 0, '0d26baa4cbb28db54848f127dfaa0bf0', NULL, NULL, NULL, 1, 0, 0, '2022-03-08 13:13:23'),
				(20, 7, 'commodity_item_file', 'ML233ref_VW_34FR+watch-45-alum-green-nc-7s_VW_34FR_WF_CO.jpg', 'image/jpeg', 0, 'ce825528bff417bb0b38e80752e5f9f3', NULL, NULL, NULL, 1, 0, 0, '2022-03-08 13:13:23'),
				(21, 7, 'commodity_item_file', 'ML173ref_VW_34FR+watch-45-alum-green-nc-7s_VW_34FR_WF_CO.jpg', 'image/jpeg', 0, 'b000680125f7db9ea035ff7acb6a2faa', NULL, NULL, NULL, 1, 0, 0, '2022-03-08 13:13:24'); );");

			$files = [
				'iphone-13-pro-silver-select.png',
				'iphone-13-pro-blue-select.png',
				'iphone-13-pro-gold-select.png',
				'iphone-13-pro-graphite-select.png',
				'ipad-mini-select-wifi-space-gray-202109.png',
				'ipad-mini-select-wifi-starlight-202109.png',
				'ipad-mini-select-wifi-pink-202109.png',
				'ipad-mini-select-wifi-purple-202109 (1).png',
				'ipad-mini-select-wifi-purple-202109.png',
				'ML1Q3ref_VW_34FR+watch-45-alum-green-nc-7s_VW_34FR_WF_CO.jpg',
				'MKYD3ref_VW_34FR+watch-45-alum-green-nc-7s_VW_34FR_WF_CO.jpg',
				'ML233ref_VW_34FR+watch-45-alum-green-nc-7s_VW_34FR_WF_CO.jpg',
				'ML173ref_VW_34FR+watch-45-alum-green-nc-7s_VW_34FR_WF_CO.jpg',
			];

			// Copy image files to system
			$destFolder = APP_MODULES_PATH.'warehouse/uploads/item_img/';
			$sourFolder = dirname(__FILE__,2).'/assets/demo/items/';
			if (file_exists($destFolder)) {
				$folders = scandir($sourFolder);
				foreach ($$folders as $folder) {
					if (in_array($folder, ['.', '..'])){
						continue;
					}

					$destFolderItem = $destFolder.$folder;
					if (! file_exists($destFolderItem)) {
						@mkdir($destFolderItem);
						@chmod($destFolderItem, 0777);
					}
					if (! file_exists($destFolderItem)) {
						$files = scandir($destFolderItem);
						foreach ($files as $file) {
							if (in_array($file, ['.', '..'])) {
								continue;
							}

							$sourceFile = $sourFolder.$folder.'/'.$file;
							$targetFile = $destFolderItem.'/'.$file;
							if (! file_exists($targetFile)) {
								continue;
							}
							copy($sourceFile, $targetFile);

						}
					}
				}
			}
		}

	}

	function truncateSalesTable($CI, $table) {
		if ($CI->db->table_exists(db_prefix() . $table)) {
			$CI->db->truncate(db_prefix().$table);
		}
	}

	function importSalesData($CI, $table, $data) {
		$CI->db->query('INSERT INTO `' . db_prefix() . $table.'` '.$data);
	}

}