function development_mode_save_option() {
	"use strict";
	$.post(admin_url + 'development_mode/save', {
		development_mode_option: ($('#development_mode_option').is(':checked')?"1":"0"),
		development_mode_msg_switch: ($('#development_mode_msg_switch').is(':checked')?"1":"0"),
		development_mode_password: $('#development_mode_password').val(),
		dm_notice_en_msg:   $('#dm_notice_en_msg').val(),
		dm_notice_cht_msg:  $('#dm_notice_cht_msg').val(),
		dm_notice_chs_msg:  $('#dm_notice_chs_msg').val(),
	}).done(function(response) {
		window.location = admin_url + 'development_mode/option';
	});
}

function development_mode_reset_password() {
	"use strict";
	let old_password = $('#development_mode_old_password').val();
	let new_password = $('#development_mode_new_password').val();
	let confirm_password = $('#development_mode_confirm_password').val();
	if (old_password.length == 0) {
		alert('Old password must not be empty');
		return;
	}
	if (new_password.length == 0) {
		alert('New password must not be empty');
		return;
	}
	if (new_password != confirm_password) {
		alert('New password and confirm password are not match');
		return;
	}
	$.post(admin_url + 'development_mode/save_password', {
		development_mode_old_password: old_password,
		development_mode_new_password: new_password,
		development_mode_confirm_password: confirm_password
	}).done(function(response) {
		response = JSON.parse(response);
		if (response.rscode == 200) {
			alert_float('success', response.message);
			window.location.href="/admin/development_mode/option";
		} else if (response.rscode == 400) {
			alert_float('danger', response.message);
		} else {
			alert_float('danger', 'Fail to access');
		}
		setTimeout(function(){
			window.location = admin_url + 'development_mode/change_password';
		}, 5000);
	});
}

function development_mode_import_demo() {
	"use strict";

	$.post(admin_url + 'development_mode/import_demo_action', {
		development_mode_import_demo: ($('#development_mode_import_demo').is(':checked')?"1":"0"),
		development_mode_password: $('#development_mode_password').val(),
	}).done(function(response) {
		response = JSON.parse(response);
		if (response.rscode == 200) {
			alert_float('success', response.message);
		} else if (response.rscode == 400) {
			alert_float('danger', response.message);
		} else {
			alert_float('danger', 'Fail to access');
		}
		//window.location = admin_url + 'development_mode/import_demo';
	});
}

function development_mode_reset_data() {
	"use strict";

	$.post(admin_url + 'development_mode/reset_data_action', {
		development_mode_reset_data: ($('#development_mode_reset_data').is(':checked')?"1":"0"),
		development_mode_password: $('#development_mode_password').val(),
	}).done(function(response) {
		response = JSON.parse(response);
		if (response.rscode == 200) {
			alert_float('success', response.message);
		} else if (response.rscode == 400) {
			alert_float('danger', response.message);
		} else {
			alert_float('danger', 'Fail to access');
		}
		//window.location = admin_url + 'development_mode/import_demo';
	});
}

document.addEventListener("DOMContentLoaded", function() {
	if ($('#development_mode_import_demo').length > 0) {

		$('#development_mode_import_demo').on('change', function () {
			checkImportButton();
		});

		$('#development_mode_password').on('change', function () {
			checkImportButton();
		});

		checkImportButton();

		function checkImportButton(obj) {
			let $importDemo = $('#development_mode_import_demo');
			let $password = $('#development_mode_password');
			let $submitButton = $('#dm_submit_button');

			if ($importDemo.prop('checked') && $password.val().length >= 4) {
				$submitButton.removeClass('disabled');
			} else {
				$submitButton.addClass('disabled');
			}
		}
	}
});

document.addEventListener("DOMContentLoaded", function() {
	if ($('#development_mode_reset_data').length > 0) {

		$('#development_mode_reset_data').on('change', function () {
			checkResetButton();
		});

		$('#development_mode_password').on('change', function () {
			checkResetButton();
		});

		checkResetButton();

		function checkResetButton(obj) {
			let $resetData = $('#development_mode_reset_data');
			let $password = $('#development_mode_password');
			let $submitButton = $('#dm_submit_button');

			if ($resetData.prop('checked') && $password.val().length >= 4) {
				$submitButton.removeClass('disabled');
			} else {
				$submitButton.addClass('disabled');
			}
		}
	}
});
