<?php

/**
 * Ensures that the module init file can't be accessed directly, only within the application.
 */
defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Development Mode
Description: Allow enable development mode.
Version: 1.0.0
Author PMT: tag.digital
Author URI: https://tag.digital/
Requires at least: 2.7.3
*/

define('DEVELOPMENT_MODE_MODULE_NAME', 'development_mode');
define('DEVELOPMENT_MODE_PASSWORD', 'pmtpmt');
define('DEVELOPMENT_MODE_ALLOW_STAFF_UIDS', array(1));

define('DEVELOPMENT_MODE_PREVENT_URL',array(
	'/admin/modules',
//	'/admin/api/api_management',		// 2022-04-19
	'/admin/menu_setup/main_menu',
	'/admin/menu_setup/setup_menu',
	'/admin/settings?group=update',
//	'/admin/settings?group=info',
	'/admin/inject_javascript',
// 2021-08-03	'/admin/clients'
));


$CI = &get_instance();
// add menu and check staff need to sign out
hooks()->add_action('admin_init', 'development_mode_admin_init');
hooks()->add_action('after_clients_area_init', 'development_mode_after_clients_area_init');


// remove sidebar menu
hooks()->add_filter('sidebar_menu_items', 'development_mode_sidebar_menu_items');
// remove setup menu
hooks()->add_filter('setup_menu_items', 'development_mode_setup_menu_items');
// 2022-03-06		Hide company setting if SysOper
hooks()->add_filter('settings_tabs', 'development_mode_hide_comp_set');
// 2022-03-08
hooks()->add_filter('staff_table_sql_where', 'development_mode_staff_where');

// 2022-03-10
//hooks()->add_filter('staff_permissions', 'development_mode_external_plugins');

// after_render_aside_menu
hooks()->add_action('after_render_aside_menu', 'development_mode_after_render_aside_menu');

// add hook for login
hooks()->add_action('after_staff_login','development_mode_redirect_staff_to_logout');
hooks()->add_action('after_contact_login','development_mode_redirect_contact_to_logout');

hooks()->add_action('after_admin_login_form_start', 'development_mode_display_error');
hooks()->add_action('clients_login_form_start', 'development_mode_display_error'); // 2022-03-07
hooks()->add_action('app_admin_footer', 'development_mode_admin_footer');


/**
 * Register language files, must be registered if the module is using languages
 */
register_language_files(DEVELOPMENT_MODE_MODULE_NAME, [DEVELOPMENT_MODE_MODULE_NAME]);


/**
 * Init api module menu items in setup in admin_init hook
 * @return null
 */
function development_mode_admin_init()
{
	/**
	 * If the logged in user is administrator, add custom menu in Setup
	 */
	$CI = &get_instance();

	if (is_admin() && !  is_sys_oper() && development_mode_enabled()) {
		// add_sidebar

		$CI->app_menu->add_setup_menu_item('development-mode-options', [
			'collapse' => true,
			'name'     => _l('dm_development_mode'),
			'position' => 80,
			'icon'     => '',
		]);
		$CI->app_menu->add_setup_children_item('development-mode-options', [
			'slug'     => 'development-mode-option',
			'name'     => _l('dm_option'),
			'href'     => admin_url('development_mode/option'),
			'position' => 5,
		]);
		$CI->app_menu->add_setup_children_item('development-mode-options', [
			'slug'     => 'development-mode-reset-data',
			'name'     => _l('dm_reset_data'),
			'href'     => admin_url('development_mode/reset_data'),
			'position' => 7,
		]);
		$CI->app_menu->add_setup_children_item('development-mode-options', [
			'slug'     => 'development-mode-import-data',
			'name'     => _l('dm_import_demo'),
			'href'     => admin_url('development_mode/import_demo'),
			'position' => 9,
		]);

	}

	if(is_admin() || is_staff_member()) {
		development_mode_redirect_staff_to_logout();
		//set_alert('danger', 'dm_system_maintenance');
	}

	if(is_admin() || is_staff_member()) {
		development_mode_prevent_url();
	}
//	echo '<script>function openExtUrl(url) {  window.open(url, "_blank"); } </script>';

}

// 2022-03-06
function development_mode_hide_comp_set($tabs) {
	// It would disable the whole setting
	// if (is_sys_oper()) {
	// 	if (isset($tabs['general'])) {
	// 		unset($tabs['general']);
	// 	}
	// }

	return $tabs;
}

// 2022-03-08
function development_mode_enabled() {
	return get_option('development_mode_option') == "1";
}

function development_mode_prevent_url() {
	if(get_option('development_mode_option') != "1") {
		foreach(DEVELOPMENT_MODE_PREVENT_URL as $tmpURL) {
			if(str_contains(current_full_url(), $tmpURL)) {
				access_denied();
				//redirect(site_url('admin/'));
				exit;
			}
		}
	}
}

function development_mode_after_clients_area_init() {
	if(is_client_logged_in()) {
		development_mode_redirect_contact_to_logout();
	}
}

function development_mode_sidebar_menu_items($menuItems1) {
	//echo "--sidebar--\r\n";
	//print_r($menuItems1);

	// admin/api/api_management
	// admin/clients
	if(get_option('development_mode_option') != "1") {
		unset($menuItems1["api-options"]);
// 2021-08-03		unset($menuItems1["customers"]);
	}
	return $menuItems1;
}

function development_mode_setup_menu_items($menuItems2) {
	//echo "--setup--\r\n";
	//print_r($menuItems2);

	// admin/modules
	// admin/menu_setup/main_menu
	// admin/menu_setup/setup_menu
	// admin/inject_javascript
	// admin/clients/groups
	if(get_option('development_mode_option') != "1") {
		unset($menuItems2["modules"]);
		unset($menuItems2["menu-options"]);
		unset($menuItems2["inject-javascript"]);
// 2021-08-03		unset($menuItems2["customers"]);

		if (!in_array(get_staff_user_id(), DEVELOPMENT_MODE_ALLOW_STAFF_UIDS)) {
			unset($menuItems2["development-mode-options"]);
		}
	}

	// 2022-03-06
	$is_sys_oper = is_sys_oper();
	$is_admin = is_admin();
	if ($is_admin && $is_sys_oper) {
		//unset($menuItems2['menu-options']);
		unset($menuItems2['admin_theme_light']);
		unset($menuItems2['theme-style']);
		unset($menuItems2['login_page']);
		unset($menuItems2['development-mode-options']);
		unset($menuItems2["admin_light_theme"]);
	}

	return $menuItems2;
}

function development_mode_after_render_aside_menu() {
	if(get_option('development_mode_option') != "1") {
		$hideAllBottomSettingBox = "<style>
/*
// hidden setup mennu
#setup-menu-item {
	display: none;
}
*/

/* hidden help item */
#setup-menu > li:last-child {
	display:none;
}
/* hidden system update, server info */
#settings-form > .row > .col-md-3 > .panel_s > .panel-body > a,
#settings-form > .row > .col-md-3 > .panel_s > .panel-body > hr {
	display:none;
}

#settings-form > .row > .col-md-3 > .panel_s > .panel-body {
	background: rgba(255,255,255,0);
	border: 0;
}
#settings-form > .row > .col-md-3 > .panel_s {
	box-shadow: none;
	-webkit-box-shadow: none;
}
</style>";

$hideSysUpgrade = '<style>
	.settings-group-system-update {
		display:none;
	}
	</style>
';
	}

	if (is_sys_oper()) {
		echo $hideSysUpgrade;
	}
}

// For Staff
function development_mode_redirect_staff_to_logout() {
	if(get_option('development_mode_option') == "1") {
		if (!in_array(get_staff_user_id(), DEVELOPMENT_MODE_ALLOW_STAFF_UIDS)) {
			$switch = get_option('development_mode_msg_switch');
			$m = get_option('dm_notice_en_msg');
			$msg = $m;
			if ($_COOKIE['contact_lang']=='English' && $m) {
				$msg = $m;
			}
			$m = get_option('dm_notice_cht_msg');
			if ($_COOKIE['contact_lang']=='繁體中文' && $m) {
				$msg = $m;
			}
			$m = get_option('dm_notice_chs_msg');
			if ($_COOKIE['contact_lang']=='简体中文' && $m) {
				$msg = $m;
			}
			if ($switch == "1") {
				setcookie("cross_page_msg1", $msg, time()+20);  // 2022-02-01
			}
			redirect(site_url('admin/authentication/logout'));
			exit;
		}
	}
}

// For Contact
function development_mode_redirect_contact_to_logout() {
	if(get_option('development_mode_option') == "1") {
		$switch = get_option('development_mode_msg_switch');
		$m = get_option('dm_notice_en_msg');
		$pageLang = get_cookie('contact_language'); // 2022-03-07
		$msg = $m;
		if ($pageLang=='English' && $m) {
			$msg = $m;
		}
		$m = get_option('dm_notice_cht_msg');
		if ($pageLang=='繁體中文' && $m) {
			$msg = $m;
		}
		$m = get_option('dm_notice_chs_msg');
		if ($pageLang=='简体中文' && $m) {
			$msg = $m;
		}
		if ($switch == "1") {
			setcookie("cross_page_msg1", $msg, time()+20);  // 2022-02-01
		}
		redirect(site_url('authentication/logout'));
		exit;
	}
}

function development_mode_display_error() {
	if (isset($_COOKIE['cross_page_msg1'])) {
		echo '<div class="alert alert-danger text-center">'.$_COOKIE['cross_page_msg1'].'</div>';
		setcookie('cross_page_msg1', '', time()-(3600 * 48));
	}
}

function logMsg($msg = '', $title='',$file='logmsg.txt') {
	if (is_array($msg) || is_object($msg)) {
		$msg = print_r($msg, true);
	}
	if ($msg === 'upper') {
		if (! $title) {
			$title = $msg;
		}
		$b = debug_backtrace();
		$data = array();
		for ($i=0 ; $i<3 ; $i++) {
			array_shift($b);
			$d = $b[0];
			unset($d['object']);
			$data[] = $d;
		}
		$msg = print_r($data, true);
	} elseif ($msg === 'trace' || $msg === 'trace1') {
		if (! $title) {
			$title = $msg;
		}
		$b = debug_backtrace();
		//unset($b[0]);
		array_shift($b);
		foreach ($b as $k => &$v) {
			if (isset($v['object'])) {
				unset($v['object']);
			}
			if ($msg === 'trace1' && isset($v['args'])) {
				unset($v['args']);
			}
		}
		$msg = print_r($b, true);
	}
	$outFile = dirname(__FILE__,3).'/uploads/'.$file;
	$b = debug_backtrace();
	$tmp = $b[1]['file'];
	$parts = explode('/application/',$tmp, 2);
	$codeFile = $tmp; //(is_array($parts) && count($parts >= 2)) ? $parts[1] : $tmp;
	$func = $b[1]['function'];

	if ($title) {
		$output = '['.$title.'] '.$msg;
	} else {
		$output = $msg;
	}

	if (substr($file, -4) == '.csv') {
		file_put_contents($outFile, file_get_contents($msg));
	} else {
		file_put_contents($outFile, date("Y-m-d H:i:s") . ' ' . $codeFile . '-' . $func . ' ' . $output . "\n", FILE_APPEND);
	}
	@chmod($outFile, 0777);
}

// 2022-03-08
function development_mode_staff_where($where){
	//if ((! is_admin() || is_sys_oper()) || ! development_mode_enabled()) {
//	if (! is_admin() || (function_exists('is_sys_oper') && is_sys_oper()) || (function_exists('development_mode_enabled') && ! development_mode_enabled())) {
//		$where = ['WHERE (admin = 0 OR sys_oper = 1) '];
//	}
	// // 2022-04-07
	// if (! is_admin() ||  (function_exists('development_mode_enabled') && ! development_mode_enabled())) {
	// 	$where = ['WHERE (admin = 0 AND sys_oper = 0) '];
	// }

	if (! is_admin()) {
		// staff caan see stafff only
		$where = ['WHERE (admin = 0 AND sys_oper = 0) '];
	} elseif  (is_sys_oper()) {
		// sys oper can see  other ssys oper and  staff
		$where = ['WHERE ((admin = 1 AND sys_oper = 1) OR (admin = 0 AND sys_oper = 0)) '];
	} else {
		// admin can see all
		$where = ['WHERE (  1  ) '];
	}

	return $where;
}


function development_mode_admin_footer() {
	echo '<script>function openExtUrl(url) {  window.open(url, "_blank"); } </script>';
}