<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Front_builder extends AdminController
{
	public const module_name = 'front_builder';

	public function __construct()
	{
		parent::__construct();
		$this->load->model('front_builder_model');
	}

	public function banners()
	{
		$data = array();

		$this->db->order_by('status', 'desc');
		$this->db->order_by('display_order', 'asc');
        $banners = $this->db->get(db_prefix() . 'front_builder')->result_array();

        foreach ($banners as $key => $banner) {
        	$banners[$key]['href'] = admin_url('front_builder/banner/'.$banner['id']);
        	$banners[$key]['del'] = admin_url('front_builder/delete_banner/'.$banner['id']);

    		if ($banner['banner_en']) {
    			$banners[$key]['img'] = site_url('modules/front_builder/uploads/'.$banner['banner_en']);
    		}
    		$id = $banner['id'];
        	foreach(['en','tc','sc'] as $lang) {
        		$field = 'banner_'.$lang;
        		if ($banner[$field]) {
        			$banners[$key]['banner_'.$lang.'_img'] = site_url('modules/front_builder/uploads/'.$id.'/'.$banner['banner_'.$lang]);
        		}
         	}

        }
		$data['banners'] = $banners;

        // Admin login page background
        $data['backend_background'] = get_option('backend_background');
        if ($data['backend_background']) {
			$data['backend_background'] = site_url('modules/front_builder/uploads/'.$data['backend_background']);
		}

        // Recruitment portal background
		$data['recruitment_banner'] = get_option('recruitment_banner');
		if ($data['recruitment_banner']) {
			$data['recruitment_banner'] = site_url('modules/front_builder/uploads/'.$data['recruitment_banner']);
		}

		$this->load->view('banners', $data);
	}

	public function bebg() {
		$image = handle_front_builder_image_upload();

	}

	public function banner($id=0) {
		$id = intval($id);

		if (! $id && (!is_admin() && !has_permission('front_builder','','edit'))) {
			set_alert('danger','access_denied');
			redirect(admin_url('front_builder/banners'));
			exit;
		}

		if ($id && !is_admin() && !has_permission('front_builder','','edit') ){
			set_alert('danger','access_denied');
			redirect(admin_url('front_builder/banners'));
			exit;
		}

		if ($id) {
			$this->db->where('id', $id);
        	$banner = $this->db->get(db_prefix() . 'front_builder')->row();

        	foreach(['en','tc','sc'] as $lang) {
        		$field = 'banner_'.$lang;
        		if ($banner->{$field}) {
        			$banner->{'banner_'.$lang.'_img'} = site_url('modules/front_builder/uploads/'.$id.'/'.$banner->{'banner_'.$lang});
        		}
         	}

		} else {
			$banner  = [
				'id' => 0,
			    'content_en' => '',
			    'content_tc' => '',
			    'content_sc' => '',
			    'title_en' => '',
			    'text_en' => '',
			    'button_text_en' => '',
			    'button_link_en' => '',
			    'title_tc' => '',
			    'text_tc' => '',
			    'button_text_tc' => '',
			    'button_link_tc' => '',
			    'title_sc' => '',
			    'text_sc' => '',
			    'button_text_sc' => '',
			    'button_link_sc' => '',
				'display_order' => 0,
			    'status' => 1
			];
			$banner = json_decode(json_encode($banner));
		}
		$data['banner'] = $banner;
		$this->load->view('banner', $data);

	}

	public function save_bebg() {
		$ret = handle_front_builder_bg_upload();

		if ($ret) {
			set_alert('success', _l('updated_successfully', _l('front_builder_background')));
    	} else {
    		set_alert('danger', _l('update_failed', _l('front_builder_background')));
    	}
		redirect(site_url('admin/front_builder/banners#tab-bebg'));
	}

	public function save_rcmt() {
		$ret = handle_front_builder_rcmt_upload();

		if ($ret) {
			set_alert('success', _l('updated_successfully', _l('front_builder_background')));
		} else {
			set_alert('danger', _l('update_failed', _l('front_builder_background')));
		}
		redirect(site_url('admin/front_builder/banners#tab-rcmt'));
	}

	public function save()
	{
		if (!is_admin() && !has_permission('front_builder','','edit') ) {
			set_alert('danger','access_denied');
			redirect(admin_url('front_builder/banners'));
			exit;
		}

		$targetPath = FCPATH.'uploads/front_builder';
		if (! file_exists($targetPath)) {
			mkdir($targetPath);
			//chmod($targetPath, 0755);
		}

		$data = $this->input->post();
		$updated = false;

    	$id = 0;
    	if (isset($data['banner_id']) && $data['banner_id']) {
    		$id = intval($data['banner_id']);
    	}
    	unset($data['banner_id']);

    	$langFields = [ 'title', 'text', 'button_text', 'button_link', 'content' ];
    	$copyto_tc = (isset($data['copyto_tc']));
    	$copyto_sc = (isset($data['copyto_sc']));
    	if ($copyto_tc) {
    		foreach($langFields as $field) {
    			$data[$field.'_tc'] = $data[$field.'_en'];
    		}
    		unset($data['copyto_tc']);
    	}
    	if ($copyto_sc) {
    		foreach($langFields as $field) {
    			$data[$field.'_sc'] = $data[$field.'_en'];
    		}
    		unset($data['copyto_sc']);
    	}

    	if ($id) {
	        $this->db->where('id', $id);
	        $this->db->update(db_prefix().'front_builder', $data);
		} else {
    		$data['status'] = 1;
			$this->db->insert(db_prefix().'front_builder', $data);
			$id = $this->db->insert_id();
	    }
	    if ($id) {
            $upd_en = handle_front_builder_image_upload($id, 'en');
            $updated = $updated || $upd_en;
            $upd_tc = handle_front_builder_image_upload($id, 'tc');
            $updated = $updated || $upd_tc;
            $upd_sc = handle_front_builder_image_upload($id, 'sc');
            $updated = $updated || $upd_sc;
	    }
//	    return 'success';

	    // Image copy from em
    	$imgs = [];
    	$this->db->where('id', $id);
    	$banner = $this->db->get(db_prefix() . 'front_builder')->row();
    	if ($copyto_tc) {
    		$imgs['banner_tc'] = $banner->banner_en;
    	}
    	if ($copyto_sc) {
    		$imgs['banner_sc'] = $banner->banner_en;
    	}
    	if ($imgs) {
    	 	$this->db->where('id', $id);
    		$banner = $this->db->update(db_prefix() . 'front_builder', $imgs);
		}
	    $updated = $updated || $this->db->affected_rows() > 0;



//	    if ($updated) {
        	set_alert('success', _l('updated_successfully', _l('banner')));
//    	} else {
//    		set_alert('danger', _l('update_failed', _l('banner')));
//    	}

		redirect(site_url('admin/front_builder/banners'));
	}

	function save_page() {
		$data = $this->input->post();
		$lang = $data['lang' ];
		if (! in_array($lang,['en', 'tc', 'sc'])) {
			$msg = _l('access_denied');
			echo  json_encode([
				'rscode' => 400,
				'message' => $msg
			]);
			exit;
		}
		$key = 'front_builder_'.$lang.'_page';
		update_option($key, $data['page']);
		$msg =  _l('updated_successfully', _l('home_page'));
		echo  json_encode([
			'rscode' => 200,
			'message' => $msg
		]);
	}

	function banners_order() {
		$data = $this->input->post();

//		$id = intval($data['id']);
//		$value = intval($data['value']);
//		// Set user value to order
//		$this->db->where('id', $id);
//		$this->db->update(db_prefix().'front_builder', [ 'display_order'=> $value ]);

		$original = $this->db->get(db_prefix().'front_builder')->result_array();

		if (! isset($_SESSION['offBanner'])) {
			$offBanner = [];
		} else {
			$offBanner = $_SESSION['offBanner'];
		}
		if (! isset($_SESSION['onBanner'])) {
			$onBanner = [];
		} else {
			$onBanner = $_SESSION['onBanner'];
		}
		if (isset($_POST['offBanner'])) {
			$offBanner = array_merge($offBanner, $_POST['offBanner']);
		}
		if ($offBanner && $onBanner) {
			foreach ($onBanner as $k => $v) {
				if (in_array($v, $onBanner)) {
					unset($onBanner[$k]);
				}
			}
		}
		if (isset($_POST['sortBanner'])) {
			$offBanner = [];
		}
		$_SESSION['offBanner'] = $offBanner;



		$keys = [];
		$activeKeys = [];
		if (isset($data['display_order'])) {
			$display_order = $data['display_order'];
		} else {
			$display_order = [];
		}
		if (isset($data['banner_status2'])) {
			$banner_status2 = $data['banner_status2'];
		} else {
			$banner_status2 = [];
		}
		$offItems = [];
		$backupProcess = [];
		$restoreProcess = [];
		$total = $this->db->count_all_results(db_prefix() . 'front_builder');

		foreach ($banner_status2 as $k => $v) {
			if ($v == 'off') {
				$offItems[] = $k;
			}
			$skipUpdate = false;
			foreach ($original as $val) {
				if ($val['id'] == $k) {
					if (($v=='on') == !!$val['status']) {
						$skipUpdate = true;
						break;
					} else {
						if ($v == 'off') {
							// Backup the existing order and set max value to display_order
							$total = $this->db->count_all_results(db_prefix() . 'front_builder');
							$this->db->where('id', $k);
							$this->db->update(db_prefix() . 'front_builder', [
								'temp_order' => $val['display_order'],
								'display_order' => $total
							]);
						} elseif ($v == 'on') {
							// Recover the old display_order
							$this->db->where('id', $k);
							$this->db->update(db_prefix() . 'front_builder', [
								'display_order' => $val['temp_order']
							]);
							if (in_array($k, $offBanner)){
								$restoreProcess[$k] = $val['temp_order'];
							} else {
								$restoreProcess[$k] = $total;
							}
						}
					}
				}
			}
			if ($skipUpdate) continue;

			$this->db->where('id', $k);
			$this->db->update(db_prefix().'front_builder', [ 'status' =>  $v=='on' ? 1 : 0 ]);
		}

		foreach($display_order as $k => $v) {
			if (in_array($k, $offItems) ) {  // off banner no need update display_order
				continue;
			}
			$this->db->where('id', $k);
			$this->db->update(db_prefix().'front_builder', [ 'display_order'=> $v ]);
		}

		// Restore after the update of display_order
		foreach ($restoreProcess as $k => $v ) {
			$this->db->where('id', $k);
			$this->db->update(db_prefix() . 'front_builder', [
				'display_order' => $v
			]);
		}

		// Sort active items
		$this->db->where('status', 1);
		$this->db->order_by('display_order', 'asc');
		$banners = $this->db->get(db_prefix().'front_builder')->result_array();
		$idx = 0;
		foreach ($banners as $banner) {
			$idx++;
			$this->db->where('id', $banner['id']);
			$this->db->update(db_prefix().'front_builder', ['display_order'=> $idx]);
		}

		$msg =  _l('updated_successfully', _l('front_builder_banners'));
//		echo  json_encode([
//			'rscode' => 200,
//			'message' => $msg
//		]);
		set_alert('success', $msg);
		redirect(admin_url('front_builder/banners'));
	}

	function delete_banner($id) {
		if (!is_admin() && !has_permission('front_builder','','edit') ) {
			set_alert('danger','access_denied');
			redirect(admin_url('front_builder/banners'));
			exit;
		}

        $path = get_upload_path_by_type('front_builder').$id.'/';

        if (is_dir($path)) {
            delete_files($path, true);
            rmdir($path);
        }

        $this->db->where('id', $id);
        $this->db->delete(db_prefix() . 'front_builder');
	    $updated = $this->db->affected_rows() > 0;
	    if ($updated) {
	    	set_alert('success', _l('deleted', _l('banner')));
	    } else {
	    	set_alert('warning', 'access_denied');
	    }
	    redirect(admin_url('front_builder/banners'));
	}

}