<?php

/**
 * Ensures that the module init file can't be accessed directly, only within the application.
 */
defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Front Builder
Description: Front Builder
Author: Developed by tag.digital
Version: 1.0.0
Requires at least: 1.0.0
*/

define('FRONT_BUILDER_MODULE_NAME', 'front_builder');
define('FRONT_BUILDER_PATH', 'modules/front_builder/uploads/');
define('FRONT_BUILDER_UPLOAD_FOLDER', module_dir_path(FRONT_BUILDER_MODULE_NAME, 'uploads'));

// Register activation module hook
register_activation_hook(FRONT_BUILDER_MODULE_NAME, 'front_builder_module_activation_hook');

$CI = &get_instance();

function front_builder_module_activation_hook()
{
    $CI = &get_instance();
    require_once __DIR__.'/install.php';
}

// add menu and check staff need to sign out
hooks()->add_action('admin_init', 'front_builder_init');
hooks()->add_action('admin_init', 'front_builder_permissions');
hooks()->add_action('before_admin_login_form_close', 'front_builder_admin_login_bg');
hooks()->add_action('app_customers_portal_footer', 'front_builder_recruitment_portal_banner');
/**
 * Register language files, must be registered if the module is using languages
 */
register_language_files(FRONT_BUILDER_MODULE_NAME, [FRONT_BUILDER_MODULE_NAME]);

$CI = &get_instance();
$CI->load->helper(FRONT_BUILDER_MODULE_NAME.'/front_builder');

/**
 * Init api module menu items in setup in admin_init hook
 * @return null
 */
function front_builder_init()
{
	if(is_admin() || (function_exists('is_sys_oper') && is_sys_oper()) || has_permission('front_builder','','edit')) {
		$CI = &get_instance();
		$CI->app_menu->add_setup_menu_item('front_builder', [
			'name'     => _l('front_builder_front_builder'),
			'position' => 80,
			'href'     => admin_url('front_builder/banners'),
			'icon'     => '',
		]);
	}

}

function front_builder_get_data() {


	if (isset($_COOKIE['contact_language']) && $_COOKIE['contact_language'] == '繁體中文') {
		$lang = 'tc';
	}
	elseif (isset($_COOKIE['contact_language']) && $_COOKIE['contact_language'] == '简体中文') {
		$lang = 'sc';
	} else {
		$lang = 'en';
	}

	$CI = &get_instance();
	$CI->db->order_by('display_order', 'asc');
	$CI->db->where('status', 1);
    $banners = $CI->db->get(db_prefix() . 'front_builder')->result_array();

    $items = [];
	$langFields = [ 'title', 'text', 'banner', 'button_text', 'button_link', 'content' ];
    foreach ($banners as $key => $banner) {
    	$item = [];
    	$item['id'] = $banner['id'];
		foreach($langFields as $field) {
			$item[$field] = $banner[$field.'_'.$lang];
			if ($field == 'banner') {
				$item['banner_img'] = site_url('modules/front_builder/uploads/'.$item['id'].'/'.$banner['banner_'.$lang]);
			}
		}
		$items[] = $item;
	}
	return $items;
}

function front_builder_get_page()
{
	if (isset($_COOKIE['contact_language']) && $_COOKIE['contact_language'] == '繁體中文') {
		$lang = 'tc';
	}
	elseif (isset($_COOKIE['contact_language']) && $_COOKIE['contact_language'] == '简体中文') {
		$lang = 'sc';
	} else {
		$lang = 'en';
	}

	return get_option('front_builder_'.$lang.'_page');
}

function front_builder_permissions()
{
    $capabilities = [];

    $capabilities['capabilities'] = [
            'edit'   => _l('permission_edit'),
    ];

    register_staff_capabilities('front_builder', $capabilities, _l('front_builder'));
}

// Inject upload folder location for front_builder module
hooks()->add_filter('get_upload_path_by_type', 'asset2_upload_folder', 10, 2);
function asset2_upload_folder($path, $type)
{
    if ('front_builder' == $type) {
        return FRONT_BUILDER_UPLOAD_FOLDER.'/';
    }

    return $path;
}

function front_builder_get_backend_background()
{
	if (isset($_COOKIE['contact_language']) && $_COOKIE['contact_language'] == '繁體中文') {
		$lang = 'tc';
	}
	elseif (isset($_COOKIE['contact_language']) && $_COOKIE['contact_language'] == '简体中文') {
		$lang = 'sc';
	} else {
		$lang = 'en';
	}

	return get_option('front_builder_'.$lang.'_page');
}

function front_builder_admin_login_bg() {
	$bg = get_option('backend_background');
	if ($bg) {
		$bg = site_url('modules/front_builder/uploads/'.$bg);
		echo '<style>
	body { background-image : url( '.$bg.' ); }
</style>';
	}
}

function front_builder_recruitment_portal_banner()
{
	$bg = get_option('recruitment_banner');
	if ($bg) {
		$bg = site_url('modules/front_builder/uploads/' . $bg);
		echo '<style>
	div.intro-slide { background-image : url( '.$bg.'  ) !important; }
</style>';
	}
	return $bg;
}
