<?php

defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Check whether column exists in a table
 * Custom function because Codeigniter is caching the tables and this is causing issues in migrations.
 *
 * @param string $column column name to check
 * @param string $table  table name to check
 * @param mixed  $id
 *
 * @return bool
 */

    function handle_front_builder_file($id, $lang) {
        if (isset($_FILES['file']['name']) && '' != $_FILES['file']['name']) {
            $path = FRONT_BUILDER_UPLOAD_FOLDER.'/'.$id.'/';
            // Get the temp file path
            $tmpFilePath = $_FILES['file']['tmp_name'];
            // Make sure we have a filepath
            if (!empty($tmpFilePath) && '' != $tmpFilePath) {
                _maybe_create_upload_path($path);
                $filename    = unique_filename($path, $_FILES['file']['name']);
                $newFilePath = $path.$filename;
                // Upload the file into the company uploads dir
                if (move_uploaded_file($tmpFilePath, $newFilePath)) {
                    $CI           = &get_instance();
                    $attachment   = [];
                    $attachment[] = [
                        'file_name' => $filename,
                        'filetype'  => $_FILES['file']['type'],
                        ];
                    $CI->misc_model->add_attachment_to_database($id, 'front_builder', $attachment);

                    return true;
                }
            }
        }

        return false;
    }

    function handle_front_builder_image_upload($banner_id, $lang) {
        $CI = &get_instance();
        if (isset($_FILES['banner_'.$lang]['name']) && '' != $_FILES['banner_'.$lang]['name']) {
            $path        = get_upload_path_by_type('front_builder').$banner_id.'/';
            if (! file_exists($path)) {
                mkdir($path, 0777);
            }
            $tmpFilePath = $_FILES['banner_'.$lang]['tmp_name'];
            if (!empty($tmpFilePath) && '' != $tmpFilePath) {
                $path_parts  = pathinfo($_FILES['banner_'.$lang]['name']);
                $extension   = $path_parts['extension'];
                $extension   = strtolower($extension);
                $filename    = 'banner_'.$banner_id.'_'.$lang.'_'.(time()%1000000).'.'.$extension;
                $newFilePath = $path.$filename;

                _maybe_create_upload_path($path);
                if (move_uploaded_file($tmpFilePath, $newFilePath)) {
                    $CI->front_builder_model->update_banner(['banner_'.$lang=>$filename], $banner_id);

                    return true;
                }
            }
        }

        return false;
    }

    // 2022-03-19
	function handle_front_builder_bg_upload() {
		$CI = &get_instance();
		if (isset($_FILES['backend_background']['name']) && '' != $_FILES['backend_background']['name']) {
			$path = get_upload_path_by_type('front_builder');
			if (! file_exists($path)) {
				mkdir($path, 0777);
			}
			$tmpFilePath = $_FILES['backend_background']['tmp_name'];
			if (!empty($tmpFilePath) && '' != $tmpFilePath) {
				$path_parts  = pathinfo($_FILES['backend_background']['name']);
				$extension   = $path_parts['extension'];
				$extension   = strtolower($extension);
				$filename    = 'backend_background_'.(time()%1000000).'.'.$extension;
				$newFilePath = $path.$filename;

				_maybe_create_upload_path($path);
				if (move_uploaded_file($tmpFilePath, $newFilePath)) {
					$old = get_option('backend_background');
					if ($old) {
						$filepath = $path.$old;
						if (file_exists($filepath)) {
							@unlink($filepath);
						}
					}

					update_option('backend_background', $filename);
					return true;
				}
			}
		}

		return false;
	}

// 2022-03-21
function handle_front_builder_rcmt_upload() {
	$CI = &get_instance();
	if (isset($_FILES['recruitment_banner']['name']) && '' != $_FILES['recruitment_banner']['name']) {
		$path = get_upload_path_by_type('front_builder');
		if (! file_exists($path)) {
			mkdir($path, 0777);
		}
		$tmpFilePath = $_FILES['recruitment_banner']['tmp_name'];
		if (!empty($tmpFilePath) && '' != $tmpFilePath) {
			$path_parts  = pathinfo($_FILES['recruitment_banner']['name']);
			$extension   = $path_parts['extension'];
			$extension   = strtolower($extension);
			$filename    = 'recruitment_banner_'.(time()%1000000).'.'.$extension;
			$newFilePath = $path.$filename;

			_maybe_create_upload_path($path);
			if (move_uploaded_file($tmpFilePath, $newFilePath)) {
				$old = get_option('recruitment_banner');
				if ($old) {
					$filepath = $path.$old;
					if (file_exists($filepath)) {
						@unlink($filepath);
					}
				}

				update_option('recruitment_banner', $filename);
				return true;
			}
		}
	}

	return false;
}
