<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<link href="<?php echo base_url('modules/front_builder/assets/main.css'); ?>" rel="stylesheet" type="text/css" />
<style>
    ._buttons a { margin: 5px; }
    a.de-btn { text-transform: none; background-color: inherit !important; color: black; cursor: default; }
    a.de-btn:hover { color: black;  }
    .tab_pane h3 { margin-top : 0; }
    .upload_file { border: none !important; }
    .copyto_sc, .copyto_tc {
        margin: 40px;
    }
</style>
<div id="wrapper">
	<div class="content">
        <form id="front_builder" action="<?php echo base_url('admin/front_builder/save'); ?>"  method="post" enctype="multipart/form-data">

        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <h1><?php
                            if ($banner->id) {
                                echo '#'.$banner->id.' - '.htmlspecialchars($banner->title_en);
                            }else {
                                echo _l('add_new', _l('front_builder_banner'));
                            }
                        ?></h1>
                        <input type="hidden" name="banner_id" value="<?php echo $banner->id; ?>" >

                        <div class="_buttons">
                            <a href="javascript:void(0);" class="btn btn-info pull-right display-block tab-btn" data-tab="banner_sc">简体中文</a>
                            <a href="javascript:void(0);" class="btn btn-info pull-right display-block tab-btn" data-tab="banner_tc">繁體中文</a>
                            <a href="javascript:void(0);" class="btn btn-info pull-right display-block tab-btn" data-tab="banner_en">English</a>
                            <a class="btn de-btn btn-info pull-right display-block"><?php echo _l('front_builder_banners'); ?></a>
                            <div class="clearfix"></div>
                            <!--
                            <a href="javascript:void(0);" class="btn btn-info pull-right display-block tab-btn" data-tab="content_sc">简体中文</a>
                            <a href="javascript:void(0);" class="btn btn-info pull-right display-block tab-btn" data-tab="content_tc">繁體中文</a>
                            <a href="javascript:void(0);" class="btn btn-info pull-right display-block tab-btn" data-tab="content_en">English</a>
                            <a class="btn de-btn btn-info pull-right display-block"><?php echo _l('front_builder_contents'); ?></a>
                            <div class="clearfix"></div>
                            -->
                        </div>
                    </div>
                </div>
            </div>
        </div>

         <?php foreach (['en', 'tc', 'sc'] as $lang) { ?>
        <div class="row hide tab_pane content_<?php echo $lang ?>">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <h3><?php
                            if ($lang == 'en') echo 'English';
                            if ($lang == 'tc') echo '繁體中文';
                            if ($lang == 'sc') echo '简体中文';
                        ?></h3><br/><br/>

                       <label for="content_<?php echo $lang; ?>" class="form-label"><?php echo _l("front_builder_content");?></label>
                        <?php echo render_textarea('content_'.$lang,'',$banner->{'content_'.$lang},array(),array(),'','tinymce');  ?>
                    </div>
                </div>
            </div>
        </div>
         <?php } ?>

         <?php foreach (['en', 'tc', 'sc'] as $lang) {  ?>
        <div class="row <?php if ($lang != 'en') echo 'hide'; ?> tab_pane banner_<?php echo $lang ?>">
			<div class="col-md-12 ">
				<div class="panel_s">
					<div class="panel-body">

                        <div class="row">
                            <div class="col-md-3">
                                <h3><?php
                                    if ($lang == 'en') echo 'English';
                                    if ($lang == 'tc') echo '繁體中文';
                                    if ($lang == 'sc') echo '简体中文';
                                ?></h3>

                                <!-- <img src="https://images.pexels.com/photos/1133957/pexels-photo-1133957.jpeg?auto=compress&cs=tinysrgb&h=750&w=1260" width="100%"> -->
                                <?php
                                    if (isset($banner->{'banner_'.$lang.'_img'})) {
                                        echo '<img src="'.$banner->{'banner_'.$lang.'_img'}.'" width="100%">';
                                    }
                                ?>
                                <div class="form-control">
                                <input type="file" class="form-group upload_file" name="banner_<?php echo $lang; ?>">
                                </div>
                            </div>
                            <div class="col-md-9">

                                 <div class="form-group">
                                    <label for="banner-title-<?php echo $lang; ?>"><?php echo _l('front_builder_title'); ?></label>
                                    <input type="text" id="banner-title-<?php echo $lang; ?>" class="form-control"
                                        name="title_<?php echo $lang; ?>"
                                       value="<?php echo htmlspecialchars($banner->{'title_'.$lang}); ?>"  <?php if ($lang=='en') echo 'required'; ?> >
                                 </div>

                                 <div class="form-group">
                                    <label for="banner-text-<?php echo $lang; ?>"><?php echo _l('front_builder_text'); ?></label>
                                    <textarea id="banner-text-<?php echo $lang; ?>" class="form-control" name="text_<?php echo $lang; ?>" ><?php echo htmlspecialchars($banner->{'text_'.$lang}); ?></textarea>
                                 </div>

                                 <div class="form-group">
                                    <label for="button-text-<?php echo $lang; ?>"><?php echo _l('front_builder_button_text'); ?></label>
                                    <input type="text" id="button-text-<?php echo $lang; ?>" class="form-control"
                                       name="button_text_<?php echo $lang; ?>"
                                       value="<?php echo htmlspecialchars($banner->{'button_text_'.$lang}); ?>">
                                 </div>

                                 <div class="form-group">
                                    <label for="button-link-<?php echo $lang; ?>"><?php echo _l('front_builder_button_link'); ?></label>
                                    <input type="url" id="button-link-<?php echo $lang; ?>" class="form-control"
                                       name="button_link_<?php echo $lang; ?>"
                                       value="<?php echo htmlspecialchars($banner->{'button_link_'.$lang}); ?>">
                                 </div>

                                 <?php if ($lang == 'en') { ?>
                                 <div class="input-group">
                                 <label> <?php echo _l('front_builder_copyto'); ?></label>
                                &nbsp; <input type="checkbox" id="copyto_tc" name="copyto_tc" > &nbsp;
                                     <label for="copyto_tc"> <?php echo _l('front_builder_copyto_tc'); ?></label>
                                &nbsp; <input type="checkbox" id="copyto_sc" name="copyto_sc" > &nbsp;
                                     <label for="copyto_sc"> <?php echo _l('front_builder_copyto_sc'); ?></label>
                                 </div>
                                 <?php } ?>

                              </div>
                         </div>

					</div>
				</div>
			</div>
        </div>
        <?php } ?>

            <div class="btn-bottom-toolbar text-right">
                <?php
                    if (is_admin() || has_permission('front_builder','','edit') ) {
                ?>
                   <button type="submit" class="btn btn-info" data-loading-text="<?php echo _l('wait_text'); ?>" data-form="#front
                    _builder">
                   <?php echo _l('front_builder_save'); ?>
                   </button>
                <?php } ?>

               <a class="btn btn-info" href="<?php echo admin_url('front_builder/banners');?>" >
               <?php echo _l('front_builder_close'); ?>
               </a>
            </div>

        </form>
	</div>
</div>

<?php init_tail(); ?>
<script src="<?php echo base_url('modules/front_builder/assets/main.js'); ?>"></script>

<script>
    jQuery(function() {
        $('.tab-btn').on('click', function(){
            $('.tab_pane').addClass('hide');
            console.log('change to '+$(this).data('tab'))
            $('.'+$(this).data('tab')).removeClass('hide');
        });

    });


</script>
