<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<link href="<?php echo base_url('modules/front_builder/assets/main.css'); ?>" rel="stylesheet" type="text/css" />

<style>
    .display-order {
        width: 100px;
        height: 30px !important;
    }
    .id-td {
        width: 10%;
    }
    .image-td {
        width: 10%;
    }
    .display-order-td {
        width: 10%;
    }
    .title-td {
        width: 20%;
        max-width: 100px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }
    .text-td {
        width: 20%;
        max-width: 100px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }
    .status-td {
        width: 10%;
    }

    input::-webkit-outer-spin-button,
    input::-webkit-inner-spin-button {
        -webkit-appearance: none;
        margin: 0;
    }

    input[type=number]{
        -moz-appearance: textfield;
    }
</style>

<div id="wrapper">
    <div class="content">
        <div class="row">
				<?php if (is_admin() || has_permission('front_builder','','edit')) { ?>
                    <!--
					<div class="col-md-12">
						<div class="panel_s">
							<div class="panel-body">
							</div>
						</div>
					</div>
					-->
				<?php } ?>

                <div class="col-md-12">
                    <div class="panel_s">
                        <div class="panel-body">
							<?php if (is_admin() || has_permission('front_builder','','edit')) { ?>
                                <a href="javascript:void(0);" class="btn btn-info btn-icon tab-main active " data-tab="tab-table" ><?php echo _l('front_builder_banner') ?></a>
                                <a href="javascript:void(0);" class="btn btn-info btn-icon tab-main"  data-tab="tab-en">ENGLISH <?php echo _l('home_page'); ?></a>
                                <a href="javascript:void(0);" class="btn btn-info btn-icon tab-main"  data-tab="tab-tc">繁體中文 <?php echo _l('home_page'); ?></a>
                                <a href="javascript:void(0);" class="btn btn-info btn-icon tab-main"  data-tab="tab-sc">简体中文 <?php echo _l('home_page'); ?></a>
                                <a href="javascript:void(0);" class="btn btn-info btn-icon tab-main"  data-tab="tab-bebg" id="tab-bebg-tab"><?php echo _l('front_builder_backend_background'); ?></a>
                                <?php if (defined('RECRUITMENT_MODULE_NAME')) { ?>
                                <a href="javascript:void(0);" class="btn btn-info btn-icon tab-main"  data-tab="tab-rcmt" id="tab-rcmt-tab"><?php echo _l('front_builder_recruitment_banner'); ?></a>
                                <?php } ?>    
                                <hr/>
							<?php } ?>

							<?php foreach (['en', 'tc', 'sc'] as $lang) { ?>
                                <div class="row hide tab_pane tab-<?php echo $lang ?>">
                                    <div class="col-md-12">
                                        <div class="panel_s">
                                            <div class="panel-body">
                                                <h3><?php
													if ($lang == 'en') echo 'English';
													if ($lang == 'tc') echo '繁體中文';
													if ($lang == 'sc') echo '简体中文';
													$content = get_option('front_builder_'.$lang.'_page');
													?></h3><br/><br/>

                                                <label for="content_<?php echo $lang; ?>" class="form-label"><?php echo _l("front_builder_content");?></label>
												<?php echo render_textarea('content_'.$lang,'',$content, array(),array(),'','tinymce');  ?>
                                                <input type="button" class="btn btn-info" onclick="saveFrontpage('<?php echo $lang; ?>')" value="<?php echo _l('front_builder_save'); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>
							<?php } ?>

                            <div class="tab_pane tab-table">
                                <form action="<?php echo base_url('admin/front_builder/banners_order'); ?>"  method="post" enctype="multipart/form-data" id="order_form">
								<?php if (is_admin() || has_permission('front_builder','','edit')) { ?>
                                    <a href="<?php echo admin_url('front_builder/banner/') ?>" class="btn btn-info"><?php echo _l("add_new",_l('front_builder_banner'));?></a>
								<?php } ?>
                                <table class="table">
                                    <tr>
                                        <th class="id-td" >ID</th>
                                        <th class="image-td" ><?php echo _l('front_builder_image'); ?></th>
                                        <th class="title-td"><?php echo _l('front_builder_title'); ?></th>
                                        <th class="text-td"><?php echo _l('front_builder_text'); ?></th>
                                        <th class="display-order-td""><?php echo _l('front_builder_display_order'); ?></th>
                                        <th class="status-td"><?php echo _l('front_builder_status'); ?></th>
                                        <th><?php echo _l('front_builder_action'); ?></th>
                                    </tr>
                                    <tbody>
									<?php foreach ($banners as $key => $banner) {  ?>
                                        <tr>
                                            <td class="id-td">
												<?php echo $banner['id']; ?>
                                            </td>
                                            <td class="image-td">
												<?php
												$lang = 'en';
												if (isset($banner['banner_'.$lang.'_img'])) {
													echo '<img src="'.$banner['banner_'.$lang.'_img'].'" height="50">';
												}
												?>
                                            </td>
                                            <td class="title-td">
												<?php echo htmlspecialchars($banner['title_en']); ?>
                                            </td>
                                            <td class="text-td">
												<?php echo htmlspecialchars($banner['text_en']); ?>
                                            </td>
                                            <td class="display-order-td">
												<?php
												echo render_input('display_order['.$banner['id'].']', '', $banner['display_order'], 'number', ['min'=>0, 'data-id' => $banner['id']], [], '', 'display-order    '.($banner['status'] ? '' : 'hide') );
												?>
                                            </td>
                                            <td class="status-td">
												<?php
												//echo $banner['status'] ? _l('front_builder_active') : _l('front_builder_disabled');
												?>
                                                <div class="onoffswitch">
                                                    <input type="checkbox" class="onoffswitch-checkbox banner-status" name="banner_status[<?php echo $banner['id']; ?>]" id="status_<?php echo $banner['id']; ?>" value="1"
														<?php if ($banner['status'] > 0) echo "checked"; ?>
                                                           data-id="<?php echo $banner['id']; ?>"
                                                           class="banner-status"
                                                    >
                                                    <label class="onoffswitch-label" for="status_<?php echo $banner['id']; ?>"></label>
                                                </div>
                                                <input type='hidden' id="status2_<?php echo $banner['id']; ?>" name="banner_status2[<?php echo $banner['id']; ?>]" value="<?php if ($banner['status'] > 0) echo "on"; else echo "off"; ?>" >
                                            </td>
                                            <td>
												<?php if (is_admin() || has_permission('front_builder','','edit')) { ?>
                                                    <a href="<?php echo $banner['href']; ?>"  class="btn btn-default btn-icon"><i class="fa fa-pencil-square-o"></i></a>
												<?php } ?>
												<?php if (is_admin() || has_permission('front_builder','','edit')) { ?>
                                                    <a href="<?php echo $banner['del']; ?>" class="btn btn-danger btn-icon _delete"><i class="fa fa-remove"></i></a>
												<?php } ?>
                                            </td>
                                        </tr>
									<?php } ?>
                                    </tbody>
                                </table>
                                </form>
                            </div>

                            <div class="row hide tab_pane tab-bebg">
                                <div class="col-md-12">
                                    <div class="panel_s">
                                        <div class="panel-body">
                                            <form action="<?php echo base_url('admin/front_builder/save_bebg'); ?>"  method="post" enctype="multipart/form-data" id="order_form">
                                                <h3><?php echo _l('front_builder_backend_background'); ?></h3><br/><br/>

                                                <?php if ($backend_background) { ?>
                                                <img src="<?php echo $backend_background;  ?>" width="300" >
                                                <?php } ?>
                                                <div class="form-control" style="width: 300px;">
                                                    <input type="file" class="form-group upload_file" name="backend_background" id="backend_background" style="border-width: 0;">
                                                </div>

                                                <input type="button" class="btn btn-info" onclick="saveBackendBackground(this)" value="<?php echo _l('front_builder_save'); ?>" style="width:300px;">
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row hide tab_pane tab-rcmt">
                                <div class="col-md-12">
                                    <div class="panel_s">
                                        <div class="panel-body">
                                            <form action="<?php echo base_url('admin/front_builder/save_rcmt'); ?>"  method="post" enctype="multipart/form-data" id="rcmt_form">
                                                <h3><?php echo _l('front_builder_recruitment_banner'); ?></h3><br/><br/>

												<?php if ($recruitment_banner) { ?>
                                                    <img src="<?php echo $recruitment_banner;  ?>" width="300" >
												<?php } ?>
                                                <div class="form-control" style="width: 300px;">
                                                    <input type="file" class="form-group upload_file" name="recruitment_banner" id="recruitment_banner" style="border-width: 0;">
                                                </div>

                                                <input type="button" class="btn btn-info" onclick="saveRecruitmentBanner(this)" value="<?php echo _l('front_builder_save'); ?>" style="width:300px;">
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>


        </div>
    </div>
</div>

<?php init_tail(); ?>
<script src="<?php echo base_url('modules/front_builder/assets/main.js'); ?>"></script>

<style>

    .temp-list {
        display: none;
    }

    .old-list,
    .file-list {
        padding : 10px;
        border: solid 1px #bbb;
        margin: 20px 0 5px 0;
    }
    .old-list .mb-3,
    .file-list .mb-3 {
        margin: 10px;
        padding : 10px;
        border: solid 1px #bbb;
    }
    .text-input {
        margin: 20px 0;
    }
</style>
<script>
    jQuery(function() {
        if (window.location.hash == '#tab-bebg') {
            $('.tab_pane').addClass('hide');
            $('.tab-bebg').removeClass('hide');
        }
        if (window.location.hash == '#tab-rcmt') {
            $('.tab_pane').addClass('hide');
            $('.tab-rcmt').removeClass('hide');
        }

        $( ".old-list" ).sortable();

        $('.front_builder_add').on('click', function(){
            let $upload = $('.temp-list .mb-3:first-child').clone();
            $upload.find('input').val(null);
            $upload.find('a').removeClass('hidden');
            $('.file-list').append($upload);
        });

        $('.tab-main').on('click', function(){
            let pane = $(this).data('tab');
            $('.tab-main').removeClass('active');
            $(this).addClass('active');
            $('.tab_pane').addClass('hide');
            $('.'+pane).removeClass('hide');

            // setTimeout(function(){
            //     tinymce.activeEditor.setContent(tinymce.activeEditor.getContent());
            // }, 1000);
        });

        var displayOrderTime = false;
        $('.display-order').on('change', function(){
            let id = $(this).data('id');
            $(this).closest('form').append('<input type="hidden" name="sortBanner" value="'+id+'"  >');
            var $theForm = $(this).closest('form');
            $theForm.submit();
        });

        $('.banner-status').on('change', function(){
            if ($('.banner-status:checked').length == 0) {
                $(this).prop('checked',true);
                alert_float('danger', '<?php echo _l('front_builder_disable_all_banners'); ?>');
                return;
            }

            let id = $(this).data('id');
            if (! $(this).prop('checked')) {
                $(this).closest('form').append('<input type="hidden" name="offBanner[]" value="'+id+'"  >');
            } else {
                $(this).closest('form').append('<input type="hidden" name="onBanner[]" value="'+id+'"  >');
            }

            var $theForm = $(this).closest('form');
            id = $(this).data('id');
            let val = $(this).prop('checked') ? 'on' : 'off';
            $('#status2_'+id).val(val);
            $theForm.submit();
        });

    });

    function delete_front_builder_old($obj) {
        let id = $($obj).data('id');
        let html = '<input type="hidden" name="del_images[]" value="'+id+'" >';
        $('.del-list').append(html);
        $($obj).closest('.mb-3').remove();
    }

    function delete_front_builder_image($obj) {
        $($obj).closest('.mb-3').remove();
    }

    function saveFrontpage(lang) {
        let data = {
            lang: lang,
            page: tinyMCE.activeEditor.getContent({format : 'raw'}),
//            page : tinyMCE.get("#content_"+lang).getContent()
        }
        $.post(admin_url + 'front_builder/save_page', data).done(function(data) {
            data = JSON.parse(data);
            if (data.rscode == 200) {
                alert_float('success', data.message);
            } else {
                if (data.rscode == 400) {
                    alert_float('warning', data.message);
                } else {
                    alert_float('danger', _l('update_failed'));
                }
            }
        });
    }

    function saveBackendBackground(obj) {
        if ($('#backend_background').val() == ''){
            alert_float('warning', '<?php echo _l('front_builder_upload_empty'); ?>');
        } else {
            $(obj).closest('form').submit();
        }
    }

    function saveRecruitmentBanner(obj) {
        if ($('#recruitment_banner').val() == ''){
            alert_float('warning', '<?php echo _l('front_builder_upload_empty'); ?>');
        } else {
            $(obj).closest('form').submit();
        }
    }
</script>
