<?php

class Lifebee extends AdminController {


	public function __construct()
	{
		parent::__construct();
		//$this->load->model('lifebee_model');
	}

	public function setup() {
		if (! is_admin()) {
			set_alert('danger', _l('access_denied'));
			redirect(admin_url());
		}

		$data = array();
		$this->load->view('setup', $data);
	}

	public function save_setup() {
		foreach(['lifebee_instance','lifebee_secret','lifebee_account_name'] as $tmp_option) {
			$$tmp_option = $this->input->post($tmp_option, FALSE);
			$$tmp_option = trim($$tmp_option);
			$$tmp_option = nl2br($$tmp_option);
		}
		update_option('lifebee_instance', 	$lifebee_instance);
		update_option('lifebee_secret', 	$lifebee_secret);
		update_option('lifebee_account_name', $lifebee_account_name);

		echo json_encode([
			'rscode' => 200,
			'message'  => _l('updated_successfully', _l('lifebee_setup')),
		]);
	}

	public function open_sales() {
		$this->openLink('sales');
	}

	public function open_admin() {
		$this->openLink('admin');
	}

	public function openLink($type) {
		$CI = & get_instance();
		$id = get_staff_user_id();
		$CI->db->where('staffid', $id);
		$user = $CI->db->get(db_prefix().'staff')->row();

		$instance = get_option('lifebee_instance');
		// logMsg($instance,'$instance');

		//		$accountName = get_option('lifebee_account_name');
		// 2022-04-08
		if ($type == 'admin')  $fid = 6; else $fid = 7;
		$CI->db->where('relid', $id);
		$CI->db->where('fieldid', $fid);
		$rec = $CI->db->get(db_prefix().'customfieldsvalues')->row();
		$accountName = $rec->value;
		// logMsg($id,'id');
		// logMsg($fid,'fid');
		// logMsg($type,'type');
		// logMsg($accountName,'$accountName');
		if (! $rec) {
			set_alert('danger', _l('access_denied' ));
			redirect(admin_url());
		}

		$firstName = $user->firstname;
		$lastName = $user->lastname;
		$secretKey = get_option('lifebee_secret');
		$token = md5($accountName.'&'.$firstName.'&'.$lastName.'&'.$type.'&'.$instance.'&'.$secretKey);
		// logMsg($firstName, 'firstName');
		// logMsg($lastName, 'lasttName');
		// logMsg($token,'token');

		$url = 'https://api.lifebee.tech/api/open/auth/authorize';

		$body = [
			"token" =>$token,
			"user" => [
				"accountName"=>$accountName,
				"firstName"=>$firstName,
				"lastName"=>$lastName,
				"type"=>$type
			]
		];
// logMsg($body);		

		$json = json_encode($body);
// logMsg($json);		

	    $headerArray =array(
	    	"Content-type:application/json;charset='utf-8'",
	    	"Accept:application/json",
	    	"X-BeeFintech-Instance: ".$instance
	    );
// logMsg($headerArray, '$headerArray');	    
	    $curl = curl_init();
	    curl_setopt($curl, CURLOPT_URL, $url);
	    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
	    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST,FALSE);
	    curl_setopt($curl, CURLOPT_HTTPHEADER,$headerArray);
	    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
	    curl_setopt($curl, CURLOPT_POSTFIELDS, $json);
	    $output = curl_exec($curl);
	    curl_close($curl);
	   $json = json_decode($output, true);

// logMsg($json);


	   if ($json['status'] == 200) {
	   		if ($json['code'] == 1000) {
	            $link = $json['data']['redirectUri'];
	            echo '<script>
					//openExtUrl("'. $link.'");
					window.open("'.$link.'", "_blank"); 
					 setTimeout("window.history.go(-1)",2000);
				</script>';
	   			redirect($link);
	   		} else {
	   			//echo $json['code'].' - '.$json['message'];
	   			set_alert('danger',$json['message'] );
	   			redirect(admin_url());
	   		}
	   }
	}

}