<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Life Bee
Description: Connect to Bee Fintech Integration
Version: 1.0.0
*/

define('LIFEBEE_MODULE_NAME', 'lifebee');

$CI = & get_instance();

//$CI->load->helper(LIFEBEE_MODULE_NAME . '/lifebee');

$CI = &get_instance();

hooks()->add_filter('sidebar_menu_items', 'app_admin_sidebar_custom_options', 999);
hooks()->add_filter('sidebar_menu_items', 'app_admin_sidebar_custom_positions', 998);

hooks()->add_filter('setup_menu_items', 'app_admin_setup_menu_custom_options', 999);
hooks()->add_filter('setup_menu_items', 'app_admin_setup_menu_custom_positions', 998);

hooks()->add_action('admin_init', 'lifebee_init_menu_items');
hooks()->add_filter('staff_permissions', 'lifebee_permission');


register_language_files(LIFEBEE_MODULE_NAME, [LIFEBEE_MODULE_NAME]);

/**
 * Init menu setup module menu items in setup in admin_init hook
 * @return null
 */
function lifebee_init_menu_items()
{
    /**
    * If the logged in user is administrator, add custom menu in Setup
    */
	$CI = &get_instance();
    if (is_admin()) {
        $CI->app_menu->add_setup_menu_item('lifebee-setup', [
			'slug'     => 'lifebee_setup',
			'name'     => _l('lifebee_setup'),
			'href'     => admin_url('lifebee/setup'),
            'position' => 60,
        ]);
    }

    if (has_permission('lifebee_group','','lifebee_sales') || has_permission('lifebee_group','','lifebee_admin') )  {
		$CI->app_menu->add_sidebar_menu_item('lifebee-group', [
			'collapse' => true,
			'name'     => _l('lifebee_external_apps'),
			'slug'     => 'lifebee',
			'icon'     => 'fa fa-user-o',
			'position' => 5,
			'badge'    => []
		]);

		if (has_permission('lifebee_group', '','lifebee_sales') ) {
			$CI->app_menu->add_sidebar_children_item('lifebee-group', [
				'name' => _l('lifebee_sales'),
				'slug' => 'lifebee_sales',
				'href' => "javascript:openExtUrl('" . admin_url('lifebee/open_sales') . "')",
				'icon' => 'fa fa-user-o',
				'position' => 5,
				'badge' => []
			]);
		}

		if (has_permission('lifebee_group', '', 'lifebee_admin') ) {
			$CI->app_menu->add_sidebar_children_item('lifebee-group', [
				'name' => _l('lifebee_admin'),
				'slug' => 'lifebee_admin',
				'href' => "javascript:openExtUrl('" . admin_url('lifebee/open_admin') . "')",
				'icon' => 'fa fa-user-o',
				'position' => 5,
				'badge' => []
			]);
		}
    }
}

function lifebee_permission($permissions) {
	$capabilities = [
		'lifebee_sales' => _l('lifebee_sales'),
		'lifebee_admin' => _l('lifebee_admin'),
		'lifebee_id' => 'LifeBee ID',
	];

	$permissions['lifebee_group'] = [
		'name' => _l('lifebee'),
		'capabilities' => $capabilities
	];
	return $permissions;
}
