<?php

/**
 * Ensures that the module init file can't be accessed directly, only within the application.
 */
defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Live Chat Connect
Description: Allow enable live chat.
Version: 1.0.0
Author PMT: Developed by tag.digital
Author URI: https://tag.digital/
Requires at least: 2.7.3
*/

define('LIVECHAT_MODULE_NAME', 'livechat');



$CI = &get_instance();
// add menu and check staff need to sign out
hooks()->add_action('admin_init', 'livechat_admin_init');
hooks()->add_action('app_customers_portal_footer', 'livechat_recruitment_portal');
hooks()->add_action('app_vendor_head', 'app_theme_vendor_head_hook');
hooks()->add_action('app_customers_head', 'livechat_client_portal');

// remove sidebar menu

// 2022-03-10
hooks()->add_filter('staff_permissions', 'livechat_external_plugins');

hooks()->add_action('app_admin_footer', 'livechat_admin_footer');


/**
 * Register language files, must be registered if the module is using languages
 */
register_language_files(LIVECHAT_MODULE_NAME, [LIVECHAT_MODULE_NAME]);


/**
 * Init api module menu items in setup in admin_init hook
 * @return null
 */
function livechat_admin_init()
{
	/**
	 * If the logged in user is administrator, add custom menu in Setup
	 */
	$CI = &get_instance();

	// 2022-03-10
	if(is_staff_member()) {
		if (has_permission('livechat_external_plugins', '', 'livechat')) {
			$CI->app_menu->add_sidebar_menu_item('livechat_main_menu', [
				'name' => _l('livechat'),
				'position' => 991,
				'href' => "javascript:openLivechatUrl('https://accounts.livechat.com')",
				'icon' => 'fa fa-comments',
			]);
		}
	}

	if (is_admin()) {
		// add_sidebar
		$CI->app_menu->add_setup_menu_item('livechat-options', [
			'collapse' => true,
			'name'     => _l('livechat_setup_title'),
			'position' => 80,
			'icon'     => '',
		]);
		$CI->app_menu->add_setup_children_item('livechat-options', [
			'slug'     => 'livechat-option',
			'name'     => _l('livechat_license'),
			'href'     => admin_url('livechat/option'),
			'position' => 5,
		]);
	}
}


// 2022-03-10
function livechat_external_plugins($permissions) {
	$capabilities = [
		'livechat' => _l('livechat'),
//		'livechat_admin' => _l('livechat_livechat_admin')
	];

	$permissions['livechat_external_plugins'] = [
		'name' => _l('livechat_external_plugins'),
		'capabilities' => $capabilities
	];
	return $permissions;
}

function livechat_admin_footer() {
	echo '<script>function openLivechatUrl(url) {  window.open(url, "_blank"); } </script>';
}


function getPublicLiveChat() {
	$encoded_js_data = '';
	$license = get_option('livechat_license');
	if (! $license) {
		$license = '13269696';
	}
	if ($license) {
		$js_data = '
		<!-- Start of LiveChat (www.livechatinc.com) code -->
		<script>
		    window.__lc = window.__lc || {};
		    window.__lc.license = '.$license.';
		    ;(function(n,t,c){function i(n){return e._h?e._h.apply(null,n):e._q.push(n)}var e={_q:[],_h:null,_v:"2.0",on:function(){i(["on",c.call(arguments)])},once:function(){i(["once",c.call(arguments)])},off:function(){i(["off",c.call(arguments)])},get:function(){if(!e._h)throw new Error("[LiveChatWidget] You can\'t use getters before load.");return i(["get",c.call(arguments)])},call:function(){i(["call",c.call(arguments)])},init:function(){var n=t.createElement("script");n.async=!0,n.type="text/javascript",n.src="https://cdn.livechatinc.com/tracking.js",t.head.appendChild(n)}};!n.__lc.asyncInit&&e.init(),n.LiveChatWidget=n.LiveChatWidget||e}(window,document,[].slice))
		</script>
		<noscript><a href="https://www.livechatinc.com/chat-with/'.$license.'/" rel="nofollow">Chat with us</a>, powered by <a href="https://www.livechatinc.com/?welcome" rel="noopener nofollow" target="_blank">LiveChat</a></noscript>
		<!-- End of LiveChat code -->
	    ';
		if ($js_data) {
			$encoded_js_data = $js_data; // json_encode($js_data, true);
			//echo json_decode($encoded_js_data);
		}
	}
	return $encoded_js_data;
}

function livechat_client_portal()
{
	$option = get_option('livechat_client_portal');
	if ($option) {
		echo getPublicLiveChat();
	}
}

function livechat_vendor_portal() {
	if (defined('PURCHASE_MODULE_NAME')) {
		$option = get_option('livechat_vendor_portal');
		if ($option) {
			echo getPublicLiveChat();
		}
	}
}

function livechat_recruitment_portal() {
	if(defined('RECRUITMENT_MODULE_NAME')) {
		$option = get_option('livechat_recruitment_portal');
		if ($option) {
			echo getPublicLiveChat();
		}
	}
}