<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Login_page extends AdminController
{
	public const module_name = 'login_page';

	public function __construct()
	{
		parent::__construct();
		$this->load->model('login_page_model');
	}

	public function option()
	{
		$data = array();
		$data['login_page_title'] = get_option('login_page_title');
		$data['login_page_text'] = get_option('login_page_text');
		$data['login_page_title_hk'] = get_option('login_page_title_hk');
		$data['login_page_text_hk'] = get_option('login_page_text_hk');
		$data['login_page_title_zh'] = get_option('login_page_title_zh');
		$data['login_page_text_zh'] = get_option('login_page_text_zh');
		$this->load->view('option', $data);
	}

	public function save()
	{
//		echo '<pre>'; print_r($_FILES);
/*
             [name] => Array
                (
                    [0] => Chalk.jpg
                )

            [type] => Array
                (
                    [0] => image/jpeg
                )

            [tmp_name] => Array
                (
                    [0] => /Applications/XAMPP/xamppfiles/temp/phpw6gYak
                )

            [error] => Array
                (
                    [0] => 0
                )

            [size] => Array
                (
                    [0] => 147885
                )
 */
		$targetPath = FCPATH.'uploads/login_page';
		if (! file_exists($targetPath)) {
			mkdir($targetPath);
			//chmod($targetPath, 0755);
		}

		$field = 'login_page_images';
		$old_images = $this->input->post('old_images', FALSE);
		$del_images = $this->input->post('del_images', FALSE);
		foreach ($del_images as $image) {
			if ($image) {
				$filePath = $targetPath . '/' . $image;
				if (file_exists($filePath)) {
					unlink($filePath);
				}
			}
		}

		$fileList = $old_images;
		if (isset($_FILES) && isset($_FILES[$field]['name']) && $_FILES[$field]['name']) {
			foreach ($_FILES[$field]['name'] as $k => $img_name) {
				$ext = pathinfo($img_name, PATHINFO_EXTENSION);
				$ext = strtolower($ext);
				if ($ext == 'jpeg') {
					$ext = 'jpg';
				}
				if (in_array($ext, ['jpg','png','gif']) && $_FILES[$field]['size'][$k] && !$_FILES[$field]['error'][$k]) {
					$newFile = date('ymdhis') . '_' . rand(100000, 999999) . '.' . $ext;
					if (file_exists($targetPath)) {
						$filePath = $targetPath.'/'.$newFile;
						move_uploaded_file($_FILES[$field]['tmp_name'][$k], $filePath);
						$fileList[] = $newFile;
					}
				}
			}
		}
		$imageFilesStr = implode(',',$fileList);
		update_option('login_page_images', $imageFilesStr);

		$fields = [
			'login_page_title',
			'login_page_text',
			'login_page_title_hk',
			'login_page_text_hk',
			'login_page_title_zh',
			'login_page_text_zh',
		];
		foreach($fields as $tmp_option) {
		 	$$tmp_option = $this->input->post($tmp_option, FALSE);
			update_option($tmp_option, $$tmp_option);
		}
		redirect(site_url('admin/login_page/option'));
	}

}