<?php

/**
 * Ensures that the module init file can't be accessed directly, only within the application.
 */
defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Login Page
Description: Login Page
Author: Developed by tag.digital
Version: 1.0.0
Requires at least: 1.0.0
*/

define('LOGIN_PAGE_MODULE_NAME', 'login_page');


$CI = &get_instance();
// add menu and check staff need to sign out
hooks()->add_action('admin_init', 'login_page_init');
hooks()->add_action('staff_member_created', 'login_page_staff_member_created');

/**
 * Register language files, must be registered if the module is using languages
 */
register_language_files(LOGIN_PAGE_MODULE_NAME, [LOGIN_PAGE_MODULE_NAME]);


/**
 * Init api module menu items in setup in admin_init hook
 * @return null
 */
function login_page_init()
{
	if(is_admin() || (function_exists('is_sys_oper') && is_sys_oper())) {
		$CI = &get_instance();
		$CI->app_menu->add_setup_menu_item('login_page', [
			'name'     => _l('login_page_login_page'),
			'position' => 80,
			'href'     => admin_url('login_page/option'),
			'icon'     => '',
		]);
	}

}

function login_page_get_data() {
	$images = get_option('login_page_images');
	$tmp = [];
	if (! $images) {
		$images = [];
	} else {
		$images = explode(',', $images);
		foreach ($images as $image) {
			$tmp[] = [
				'id' => $image,
				'url' => base_url('uploads/login_page/' . $image)
			];
		}
		$images = $tmp;
	}
	if (isset($_COOKIE['contact_language']) && $_COOKIE['contact_language'] == '繁體中文') {
		$login_page_title = get_option('login_page_title_hk');
		$login_page_text = get_option('login_page_text_hk');
	}
	elseif (isset($_COOKIE['contact_language']) && $_COOKIE['contact_language'] == '简体中文') {
		$login_page_title = get_option('login_page_title_zh');
		$login_page_text = get_option('login_page_text_zh');
	} else {
		$login_page_title = get_option('login_page_title');
		$login_page_text = get_option('login_page_text');
	}

	return [
		'images' => $images,
		'title' => $login_page_title,
		'text' => $login_page_text
	];
}

function login_page_staff_member_created($staff_id) {
	// Add permission of dashboard
	$CI = &get_instance();
	$CI->db->insert(db_prefix() . 'staff_permissions', [
		'staff_id' => $staff_id,
		'feature' => 'perfex_dashboard',
		'capability' => 'my_dashboard_view'
	]);
}
