<?php

defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Maibox Controller.
 */
class Mailbox extends AdminController
{
    /**
     * Controler __construct function to initialize options.
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('mailbox_model');
    }

    /**
     * Go to Mailbox home page.
     *
     * @return view
     */
    public function index()
    {
        $data['title'] = _l('mailbox');
        $group         = !$this->input->get('group') ? 'inbox' : $this->input->get('group');
        $data['group'] = $group;
        if ('config' == $group) {
            $this->load->model('staff_model');
            $member         = $this->staff_model->get(get_staff_user_id());
            $data['member'] = $member;
        }
        $data['booklist'] = $this->mailbox_model->booklist();
        $this->load->view('mailbox', $data);
    }

    /**
     * Go to Compose Form.
     *
     * @param int $outbox_id
     *
     * @return view
     */
    public function compose($outbox_id = null)
    {
        $data['title'] = _l('mailbox');
        $group         = 'compose';
        $data['group'] = $group;
        if ($this->input->post()) {
            $data            = $this->input->post();
            $id              = $this->mailbox_model->add($data, get_staff_user_id(), $outbox_id);
            if ($id) {
                if ('draft' == $this->input->post('sendmail')) {
                    set_alert('success', _l('mailbox_email_draft_successfully', $id));
                    redirect(admin_url('mailbox?group=draft'));
                } else {
                    set_alert('success', _l('mailbox_email_sent_successfully', $id));
                    redirect(admin_url('mailbox?group=sent'));
                }
            }
        }

        if (isset($outbox_id)) {
            $mail         = $this->mailbox_model->get($outbox_id, 'outbox');
            $data['mail'] = $mail;
        }
        $this->load->view('mailbox', $data);
    }

    /**
     * Get list email to dislay on datagrid.
     *
     * @param string $group
     *
     * @return
     */
    public function table($group = 'inbox')
    {
        if ($this->input->is_ajax_request()) {
            if ('sent' == $group || 'draft' == $group) {
                $this->app->get_table_data(module_views_path('mailbox', 'table_outbox'), [
                    'group' => $group,
                ]);
            } else {
                $this->app->get_table_data(module_views_path('mailbox', 'table'), [
                    'group' => $group,
                ]);
            }
        }
    }

    /**
     * Go to Inbox Page.
     *
     * @param int $id
     *
     * @return view
     */
    public function inbox($id)
    {
        $inbox = $this->mailbox_model->get($id, 'inbox');
        $this->mailbox_model->update_field('detail', 'read', 1, $id, 'inbox');
        $data['title']       = $inbox->subject;
        $group               = 'detail';
        $data['group']       = $group;
        $data['inbox']       = $inbox;
        $data['type']        = 'inbox';
        $data['attachments'] = $this->mailbox_model->get_mail_attachment($id, 'inbox');
        $this->load->view('mailbox', $data);
    }

    /**
     * Go to Outbox Page.
     *
     * @param int $id
     *
     * @return view
     */
    public function outbox($id)
    {
        $inbox               = $this->mailbox_model->get($id, 'outbox');
        $data['title']       = $inbox->subject;
        $group               = 'detail';
        $data['group']       = $group;
        $data['inbox']       = $inbox;
        $data['type']        = 'outbox';
        $data['attachments'] = $this->mailbox_model->get_mail_attachment($id, 'outbox');
        $this->load->view('mailbox', $data);
    }

    /**
     * update email status.
     *
     * @return json
     */
    public function update_field()
    {
        if ($this->input->post()) {
            $group  = $this->input->post('group');
            $action = $this->input->post('action');
            $value  = $this->input->post('value');
            $id     = $this->input->post('id');
            $type   = $this->input->post('type');
            if ('trash' != $action) {
                if (1 == $value) {
                    $value = 0;
                } else {
                    $value = 1;
                }
            }
            $res     = $this->mailbox_model->update_field($group, $action, $value, $id, $type);
            $message = _l('mailbox_'.$action).' '._l('mailbox_success');

            // 2022-02-22
            if ($action == 'trash' && $value == 0) {
                $message = _l('mailbox_recover').' '._l('mailbox_success');
            }
            
            if (false == $res) {
                $message = _l('mailbox_'.$action).' '._l('mailbox_fail');
            }
            echo json_encode([
                'success' => $res,
                'message' => $message,
            ]);
        }
    }

    /**
     * Action for reply, reply all and forward.
     *
     * @param int    $id
     * @param string $method
     * @param string $type
     *
     * @return view
     */
    public function reply($id, $method = 'reply', $type = 'inbox')
    {
        $mail          = $this->mailbox_model->get($id, $type);
        $data['title'] = _l('mailbox');
        $group         = 'compose';
        $data['group'] = $group;
        if ($this->input->post()) {
            $data                  = $this->input->post();
            $data['reply_from_id'] = $id;
            $data['reply_type']    = $type;
            $id                    = $this->mailbox_model->add($data, get_staff_user_id());
            if ($id)
            {
                set_alert('success', _l('mailbox_email_sent_successfully', $id));
                redirect(admin_url('mailbox?group=sent'));
            }
        }

        $data['group']       = $group;
        $data['type']        = 'reply';
        $data['action_type'] = $type;
        $data['method']      = $method;
        $data['mail']        = $mail;
        $this->load->view('mailbox', $data);
    }

    /**
     * Configure password to receice email from email server.
     *
     * @return redirect
     */
    public function config()
    {
        $this->scan_email_server();
        if ($this->input->post()) {
            $res  = $this->mailbox_model->update_config($this->input->post(), get_staff_user_id());
            if ($res) {
                set_alert('success', _l('mailbox_email_config_successfully'));
                redirect(admin_url('mailbox'));
            }
        }
    }
    function scan_email_server()
    {
        $enabled      = get_option('mailbox_enabled');
        $imap_server  = get_option('mailbox_imap_server');
        $encryption   = get_option('mailbox_encryption');
        $folder_scan  = get_option('mailbox_folder_scan');
        $check_every  = get_option('mailbox_check_every');
        $unseen_email = get_option('mailbox_only_loop_on_unseen_emails');
        if (1 == $enabled && strlen($imap_server) > 0) {
            $CI = &get_instance();
            $CI->db->select()
                ->from(db_prefix().'staff')
                ->where(db_prefix().'staff.mail_password !=', '');
            $staffs = $CI->db->get()->result_array();
            require_once APPPATH.'third_party/php-imap/Imap.php';
            include_once APPPATH.'third_party/simple_html_dom.php';
            foreach ($staffs as $staff) {
                $last_run    = $staff['last_email_check'];
                $staff_email = $staff['email'];
                $staff_id    = $staff['staffid'];
                $email_pass  = $staff['mail_password'];
                if (empty($last_run) || (time() > $last_run + ($check_every * 60))) {
                    require_once APPPATH.'third_party/php-imap/Imap.php';
                    $CI->db->where('staffid', $staff_id);
                    $CI->db->update(db_prefix().'staff', [
                        'last_email_check' => time(),
                    ]);
                    // open connection
                    $imap = new Imap($imap_server, $staff_email, $email_pass, $encryption);
                    if (false === $imap->isConnected()) {
                        log_activity('Failed to connect to IMAP from email: '.$staff_email, null);
                        continue;
                    }
                    if ('' == $folder_scan) {
                        $folder_scan = 'Inbox';
                    }
                    $imap->selectFolder($folder_scan);
                    if (1 == $unseen_email) {
                        $emails = $imap->getUnreadMessages();
                    } else {
                        $emails = $imap->getMessages();
                    }

                    foreach ($emails as $email) {
                        $plainTextBody = $imap->getPlainTextBody($email['uid']);
                        $plainTextBody = trim($plainTextBody);
                        if (!empty($plainTextBody)) {
                            $email['body'] = $plainTextBody;
                        }
                        /*if(strpos($email['body'],'sFmB2605')){
                            continue;
                        }*/
                        $email['body']       = handle_google_drive_links_in_text($email['body']);
                        $email['body']       = prepare_imap_email_body_html($email['body']);
                        $data['attachments'] = [];
                        $data                = [];
                        $data['attachments'] = [];
                        if (isset($email['attachments'])) {
                            foreach ($email['attachments'] as $key => $at) {
                                $_at_name = $email['attachments'][$key]['name'];
                                // Rename the name to filename the model expects filename not name
                                unset($email['attachments'][$key]['name']);
                                $email['attachments'][$key]['filename'] = $_at_name;
                                $_attachment                            = $imap->getAttachment($email['uid'], $key);
                                $email['attachments'][$key]['data']     = $_attachment['content'];
                            }
                            // Add the attchments to data
                            $data['attachments'] = $email['attachments'];
                        } else {
                            // No attachments
                            $data['attachments'] = [];
                        }

                        // Check for To
                        $data['to'] = [];
                        if (isset($email['to'])) {
                            foreach ($email['to'] as $to) {
                                $data['to'][] = trim(preg_replace('/(.*)<(.*)>/', '\\2', $to));
                            }
                        }

                        // Check for CC
                        $data['cc'] = [];
                        if (isset($email['cc'])) {
                            foreach ($email['cc'] as $cc) {
                                $data['cc'][] = trim(preg_replace('/(.*)<(.*)>/', '\\2', $cc));
                            }
                        }

                        if ('true' == hooks()->apply_filters('imap_fetch_from_email_by_reply_to_header', 'true')) {
                            $replyTo = $imap->getReplyToAddresses($email['uid']);

                            if (1 === count($replyTo)) {
                                $email['from'] = $replyTo[0];
                            }
                        }
                        $from_email       = preg_replace('/(.*)<(.*)>/', '\\2', $email['from']);
                        $data['fromname'] = preg_replace('/(.*)<(.*)>/', '\\1', $email['from']);
                        $data['fromname'] = trim(str_replace('"', '', $data['fromname']));
                        $inbox               = [];
                        $inbox['from_email'] = $email['from'];
                        $from_staff_id       = get_staff_id_by_email(trim($from_email));
                        if ($from_staff_id) {
                            $inbox['from_staff_id'] = $from_staff_id;
                        }
                        $inbox['to']                 = implode(',', $data['to']);
                        $inbox['cc']                 = implode(',', $data['cc']);
                        $inbox['sender_name']        = $data['fromname'];
                        $inbox['subject']            = $email['subject'];
                        $inbox['body']               = $email['body'];
                        $inbox['to_staff_id']        = $staff_id;
                        $inbox['date_received']      =  date('Y-m-d H:i:s');
                        $inbox['folder']             = 'inbox';

                        $CI->db->insert(db_prefix().'mail_inbox', $inbox);
                        $inbox_id = $CI->db->insert_id();
                        $path     = MAILBOX_MODULE_UPLOAD_FOLDER.'/inbox/'.$inbox_id.'/';
                        foreach ($data['attachments'] as $attachment) {
                            $filename      = $attachment['filename'];
                            $filenameparts = explode('.', $filename);
                            $extension     = end($filenameparts);
                            $extension     = strtolower($extension);
                            $filename      = implode('', array_slice($filenameparts, 0, 0 - 1));
                            $filename      = trim(preg_replace('/[^a-zA-Z0-9-_ ]/', '', $filename));
                            if (!$filename) {
                                $filename = 'attachment';
                            }
                            if (!file_exists($path)) {
                                mkdir($path, 0755);
                                $fp = fopen($path.'index.html', 'w');
                                fclose($fp);
                            }
                            $filename = unique_filename($path, $filename.'.'.$extension);
                            $fp       = fopen($path.$filename, 'w');
                            fwrite($fp, $attachment['data']);
                            fclose($fp);
                            $matt               = [];
                            $matt['mail_id']    = $inbox_id;
                            $matt['type']       = 'inbox';
                            $matt['file_name']  = $filename;
                            $matt['file_type']  = get_mime_by_extension($filename);
                            $CI->db->insert(db_prefix().'mail_attachment', $matt);
                        }
                        if (count($data['attachments']) > 0) {
                            $CI->db->where('id', $inbox_id);
                            $CI->db->update(db_prefix().'mail_inbox', [
                                'has_attachment' => 1,
                            ]);
                        }

                        if ($inbox_id) {
                            $imap->setUnseenMessage($email['uid']);
                        }
                    }
                }
            }
        }
        return false;
    }
    public function autocomplete_email()
    {
      if(!empty($_GET["keyword"])) {
      $html = '';
      $query ="SELECT * FROM ".db_prefix()."contacts WHERE email like '" . $_GET["keyword"] . "%' ORDER BY email LIMIT 0,5";
      $result = $this->db->query($query)->result_array();
      if(!empty($result)) {
      $html .= "<ul id='country-list'>";
      foreach($result as $email) {
      $html .= '<li onClick="selectEmail(this);" id="'.$email["email"].'" class="li_select">'.$email["email"].'</li>';
      }
      $html .= "</ul>";
      }
      echo $html;
      }
    }
    public function from_email_autocomplete()
    {
      if(!empty($_POST["keyword"])) {
      $html = '';
      $query ="SELECT * FROM ".db_prefix()."mail_inbox WHERE from_email like '%". $_POST["keyword"] ."%' GROUP BY from_email ORDER BY from_email LIMIT 10";
      $result = $this->db->query($query)->result_array();
      if(!empty($result)) {
      $html .= "<ul id='country-list'>";
      foreach($result as $email) {
      $html .= '<li onClick="selectFrom(this);" id="'.$email["from_email"].'" class="li_select">'.htmlspecialchars($email["from_email"]).'</li>';
      }
      $html .= "</ul>";
      }
      echo $html;
      }
    }
    public function bounceback()
    {
      $data['title']       = 'Bounce Back Email';
      $group         = 'bounceback';
      $data['group']       = $group;
      $merge = [];
      $datas = array();
      $maildata = "SELECT * FROM ".db_prefix()."mail_inbox WHERE subject like '%Failure%' || subject like '%Undeliverable%' ";
      $result = $this->db->query($maildata)->result_array();
      foreach ($result as $key)
      {
        $merge['subject'] = $key['subject'];
        if(strpos($key['subject'], 'Delivery') == 'true')
        {
          $data = explode('delivered to',$key['body']);
          $data1 = explode('because',$data[1]);
        }
        if(strpos($key['subject'], 'Undeliverable') == 'true')
        {
          $data = explode('<br>',$key['body']);
          $data1 = explode('(',$data[1]);
        }
        $dataemail = explode('.',$data1[0]);
        $a = $dataemail[0];
        $email_imap = substr($a,0,4);
        $mail_customer = "SELECT userid,firstname,lastname FROM ".db_prefix()."contacts WHERE email like '%".trim($email_imap)."%' ";
        $result1 = $this->db->query($mail_customer)->result_array();
        $merge['to'] = $data1[0];
        $merge['send_at'] = date('d-m-Y',strtotime($key['date_received']));
         if(!empty($result1))
         {
              foreach ($result1 as $key1)
                {
                  $merge['name'] = ucfirst($key1['firstname'])." ".ucfirst($key1['lastname']);
                  $merge['id'] = $key1['userid'];
                  $datas[] = $merge;
                }
         }
         else
         {
            $merge['name'] = 'No Customer';
            $merge['id'] = '';
            $datas[] = $merge;
         }


      }
      $data['datas'] = $datas;
      $this->load->view('bounceback', $data);
    }
    public function add_bookmark()
    {
      if($_POST)
      {
        $data['important'] = 1;
        $query = "SELECT * FROM ".db_prefix()."mail_inbox where from_email like '%".$_POST['from_email']."%' and important = 1";
        $bookmark_data = $this->db->query($query)->result_array();
        if(empty($bookmark_data))
        {
          $this->db->like('from_email', $_POST['from_email']);
          $this->db->update(db_prefix().'mail_inbox',$data);
          if($this->db->affected_rows() > 0)
          {
            set_alert('success','Added to bookmark list successfully');
          }
        }
        else {
          set_alert('warning','Bookmark already exist');
        }
        redirect('admin/mailbox');
      }
    }
    public function delete_bookmark()
    {
      $id = $_POST['id'];
      echo $id;
      $data['important'] = 0;
      $email = $this->db->query('Select from_email from '.db_prefix().'mail_inbox where id='.$id.'')->row();
      $this->db->like('from_email', $email->from_email);
      $this->db->update(db_prefix().'mail_inbox',$data);
      if($this->db->affected_rows() > 0)
      {
        set_alert('success','Deleted Successfully');
      }
    }
}
