<link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css" type="text/css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.6.2/css/buttons.dataTables.min.css" type="text/css">
<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<style>
.table-loading table thead tr
{
  height:auto !important;
}
.table-loading
{
  background: none !important;
}
.fa-fw
{
  margin-top: 75%;
}
.dataTables_wrapper .dataTables_paginate .paginate_button
{
  padding: 0px;
}
@media screen and (max-width:767px){
#example_filter
{
  margin-top: 10%;
  float: left;
}
}
</style>
<div id="wrapper">
	<div class="content">
		<div class="row">
      <div class="col-md-3">
          <div class="panel_s mbot5">
              <div class="">
                  <a href="<?php echo admin_url().'mailbox/compose'; ?>" class="btn btn-info display-block">
                      <i class="fa fa-edit"></i>
                      <?php echo _l('mailbox_compose'); ?>
                  </a>

              </div>
          </div>

          <ul class="nav navbar-pills navbar-pills-flat nav-tabs nav-stacked customer-tabs" role="tablist">
              <li>
                  <a data-group="inbox" href="<?php echo admin_url('mailbox?group=inbox'); ?>">
                      <i class="fa fa-inbox menu-icon" aria-hidden="true"></i>
                      <?php echo _l('mailbox_inbox'); ?>
                      <?php
                          $num_unread = total_rows(db_prefix().'mail_inbox', ['read' => '0', 'to_staff_id' => get_staff_user_id()]);
                          if ($num_unread > 0) {
                              ?>
                      <span class="badge menu-badge bg-warning"><?php echo $num_unread; ?></span>
                      <?php
                          }  ?>
                  </a>
              </li>
              <li>
                  <a data-group="starred" href="<?php echo admin_url('mailbox?group=starred'); ?>">
                      <i class="fa fa-star menu-icon orange" aria-hidden="true"></i>
                      <?php echo _l('mailbox_starred'); ?>
                  </a>
              </li>
              <li>
                  <a data-group="sent" href="<?php echo admin_url('mailbox?group=sent'); ?>">
                      <i class="fa fa-envelope-o menu-icon" aria-hidden="true"></i>
                      <?php echo _l('mailbox_sent'); ?>
                  </a>
              </li>
              <li>
                  <a data-group="important" href="<?php echo admin_url('mailbox?group=important'); ?>">
                      <i class="fa fa-bookmark menu-icon red" aria-hidden="true"></i>
                      <?php echo _l('mailbox_important'); ?>
                  </a>
              </li>
              <li>
                  <a data-group="draft" href="<?php echo admin_url('mailbox?group=draft'); ?>">
                      <i class="fa fa-file-o menu-icon" aria-hidden="true"></i>
                      <?php echo _l('mailbox_draft'); ?>
                  </a>
              </li>
              <li>
                  <a data-group="trash" href="<?php echo admin_url('mailbox?group=trash'); ?>">
                      <i class="fa fa-trash-o menu-icon" aria-hidden="true"></i>
                      <?php echo _l('mailbox_trash'); ?>
                  </a>
              </li>
              <li class="active">
                  <a data-group="bounceback" href="<?php echo admin_url('mailbox/bounceback'); ?>">
                      <i class="fa fa-file menu-icon" aria-hidden="true"></i>
                      <?php echo _l('Bounce Back Email'); ?>
                  </a>
              </li>
              <li>
                  <a data-group="trash" href="<?php echo admin_url('mailbox?group=config'); ?>">
                      <i class="fa fa-cogs menu-icon" aria-hidden="true"></i>
                      <?php echo _l('mailbox_config'); ?>
                  </a>
              </li>
          </ul>
      </div>
      <div class="col-md-9">
				<div class="panel_s">
					<div class="panel-body">
            <h4 class="customer-profile-group-heading">Bounce Back Email</h4>
            <div class="table-responsive">
						<table id="example" class="display" style="width:100%">
						        <thead>
						            <tr>
						                <th>Customer Name</th>
						                <th>Subject</th>
						                <th>To</th>
						                <th>Send At</th>
						            </tr>
						        </thead>
						        <tbody>
						              <?php
                          if(!empty($datas))
                          {
  						              foreach ($datas as $key)
  						              {
  						                ?>
  						                <tr>
  						                  <td><a target="_blank" href="<?php echo admin_url('clients/client/'.$key['id'].'?group=contacts'); ?>"><?=$key['name'];?></a></td>
  						                  <td><?=imap_utf8($key['subject']);?></td>
  						                  <td><?=$key['to'];?></td>
  						                  <td><?=$key['send_at'];?></td>
  						                </tr>
  						                <?php
  						              }
                          }
                          ?>
						        </tbody>
						    </table>
              </div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<?php init_tail(); ?>
  <script>
  $(document).ready(function() {
      $('#example').DataTable( {
          "pagingType": "full_numbers"
      } );
      $('#example_filter').addClass('col-sm-6');
      $('#example_filter').addClass('col-md-6');
      $('#example_length').addClass('col-sm-6');
      $('#example_length').addClass('col-md-6');
  } );
  </script>
</body>
</html>
