<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Multiaddr extends AdminController
{
	public function __construct()
	{
		parent::__construct();
//		parent::__construct();
	}

	private function addrMix($data) {
		$country = $data['country'];
		$countries = get_all_countries();
		foreach ($countries as $k => $v) {
		    if ($v['country_id'] == $country) {
		        $country = $v['short_name'];
		        break;
            }
        }
		$addr = [];
		if ($data['street']) $addr[] = $data['street'];
		if ($data['city']) $addr[] = $data['city'];
		if ($data['state']) $addr[] = $data['state'];
		if ($data['zip']) $addr[] = $data['zip'];
		if ($country) $addr[] = $country;
        return implode(', ', $addr);
    }

    private function reorderAddr($userid, $start=0) {
		$addressList = $this->db->where('userid', $userid)->order_by('seq', 'asc')->get(db_prefix().'multiaddr')->result_array();
		$idx = $start;
        foreach ($addressList as $k => $v) {
            $idx++;
            $this->db->where('id', $v['id']);
            $this->db->update(db_prefix().'multiaddr', [ 'seq'=> $idx ]);
        }
	}

	private function reorderLeadAddr($leadid, $start=0) {
		$addressList = $this->db->where('leadid', $leadid)->order_by('seq', 'asc')->get(db_prefix().'multiaddrleads')->result_array();
		$idx = $start;
		foreach ($addressList as $k => $v) {
			$idx++;
			$this->db->where('id', $v['id']);
			$this->db->update(db_prefix().'multiaddrleads', [ 'seq'=> $idx ]);
		}
	}

	public function update()
	{
		$data = $this->input->post();
		$action = $data['action'];
		$userid = $data['userid'];
		$addrid = $data['addrid'];  // if action is"order", it will be array value

		$updated = false;
		$CI = & self::get_instance();
		if ($action=='del') {
			$CI->db->where('userid', $userid);
			$CI->db->where('id', $addrid);
			$CI->db->delete(db_prefix().'multiaddr');
			$this->reorderAddr($userid);
			$updated = true;
		} elseif ($action=='upd') {
		    unset($data['addrid']);
			unset($data['userid']);
			$display = $this->addrMix($data);
			$upd=[
                'address_name' => $data['address_name'],
                'address_display' => $display,
                'street' => $data['street'],
				'city' => $data['city'],
				'state' => $data['state'],
				'zip' => $data['zip'],
				'country' => $data['country'],
            ];
			$CI->db->where('userid', $userid);
			$CI->db->where('id', $addrid);
			$CI->db->update(db_prefix().'multiaddr', $upd);
			$this->reorderAddr($userid);
			$updated = true;
		} elseif ($action=='add') {
			unset($data['addrid']);
			unset($data['userid']);
			$rows = $this->db->where('userid', $userid)->get(db_prefix().'multiaddr')->result_array();
			if (count($rows) < MULTIADDR_MAX_ADDRESS) {
				$this->reorderAddr($userid, 1);
				$display = $this->addrMix($data);
				$upd = [
					'seq' => 1,
					'address_name' => $data['address_name'],
					'address_display' => $display,
					'street' => $data['street'],
					'city' => $data['city'],
					'state' => $data['state'],
					'zip' => $data['zip'],
					'country' => $data['country'],
					'userid' => $userid,
				];
				$CI->db->insert(db_prefix() . 'multiaddr', $upd);

				$this->reorderAddr($userid);

				$updated = true;
			}
		} elseif ($action=='order') {
			//$this->reorderSetup($userid, $addrid);
            $seq = 0;
            foreach ($addrid as $id) {
                $seq++;
				$this->db->where('userid', $userid);
				$this->db->where('id', $id);
				$this->db->update(db_prefix().'multiaddr', [ 'seq' => $seq ]);
            }
			$updated = true; // already have order
        }
		if ($updated) {
			$addressList = $this->db->where('userid', $userid)->order_by('seq', 'asc')->get(db_prefix().'multiaddr')->result_array();

			ob_start();
			foreach ($addressList as $key => $address) {
			    $json = json_encode($address);
			?>
			<tr>
				<td><span class="ui-icon ui-icon-arrowthick-2-n-s"></span><?php echo $address['seq'] ?></td>
				<td><?php echo $address['address_name'] ?></td>
				<td><?php echo $address['address_display'] ?></td>
				<td data-userid="<?php echo $address['userid']; ?>" data-addrid="<?php echo $address['id'] ?>"  data-json='<?php echo $json; ?>' >
<!--					<a href='#' class="addr-del">--><?php //echo _l('delete'); ?><!--</a> |-->
<!--					<a href='#' class="addr-edit">--><?php //echo _l('edit'); ?><!--</a> |-->
<!--					<a href='#' class="addr-view">--><?php //echo _l('view'); ?><!--</a> |-->
<!--					<a href='#' class="addr-bill">--><?php //echo _l('multiaddr_set_billing'); ?><!--</a> |-->
<!--					<a href='#' class="addr-ship">--><?php //echo _l('multiaddr_set_shipping'); ?><!--</a>-->
<!--                    <input type="hidden" class="order_addr" value="--><?php //echo $address['id']; ?><!--">-->
                    <?php
                    $actions = [];
                    if (has_permission('customers','','delete')) {
                    $actions[] ='<a href="#" class="addr-del"  title="'. _l('delete').'"><button type="button" class="btn btn-danger"><i class="fa fa-close"></i></button></a>';
                    }
                    if (has_permission('customers','','edit')) {
                    $actions[] ='<a href="#" class="addr-edit" title="'. _l('edit').'"><button type="button" class="btn btn-primary"><i  class="fa fa-pencil"></i></button></a>';
                    }
                    if (has_permission('customers','','view')) {
                    $actions[] ='<a href="#" class="addr-view" title="'. _l('view').'"><button type="button" class="btn btn-info"><i class="fa fa-eye"></i></button></a>';
                    }
                    if (has_permission('customers','','edit')) {
                    $actions[] ='<a href="#" class="addr-bill" title="'. _l('multiaddr_set_billing').'"><button type="button" class="btn btn-info"><i class="fa fa-money"></i></button></a>';
					$actions[] ='<a href="#" class="addr-ship" title="'. _l('multiaddr_set_shipping').'"><button type="button" class="btn btn-info"><i class="fa fa-truck"></i></button></a>';
                    }
                    echo implode('', $actions);
                    ?>
                    <input type="hidden" class="order_addr"  value="<?php echo $address['id']; ?>">

                </td>
			</tr>
			<?php }

			$html = ob_get_contents();
			ob_end_clean();
			$return = [
				'rscode' => 200,
                 'html' => $html
			] ;
		} else {
			$return = [
				'rscode' => 400,
			];
		}
		echo json_encode($return);
		exit;
	}

	public function update_leads()
	{
//		ini_set("error_reporting",E_ALL);
//		ini_set("display_startup_errors",1);
//		ini_set("display_errors",1);

		$data = $this->input->post();
		$action = $data['action'];
		$leadid = $data['leadid'];
		$addrid = $data['addrid'];  // if action is"order", it will be array value

		$updated = false;
		$CI = & self::get_instance();
		if ($action=='del') {
			$CI->db->where('leadid', $leadid);
			$CI->db->where('id', $addrid);
			$CI->db->delete(db_prefix().'multiaddrleads');
			$this->reorderLeadAddr($leadid);
			$updated = true;
		} elseif ($action=='upd') {
			unset($data['addrid']);
			unset($data['leadid']);
			$display = $this->addrMix($data);
			$upd=[
				'address_name' => $data['address_name'],
				'address_display' => $display,
				'street' => $data['street'],
				'city' => $data['city'],
				'state' => $data['state'],
				'zip' => $data['zip'],
				'country' => $data['country'],
			];
			$CI->db->where('leadid', $leadid);
			$CI->db->where('id', $addrid);
			$CI->db->update(db_prefix().'multiaddrleads', $upd);
			$updated = true;
		} elseif ($action=='add') {
			unset($data['addrid']);
			unset($data['leadid']);
			$rows = $this->db->where('leadid', $leadid)->get(db_prefix().'multiaddrleads')->result_array();
			if (count($rows) < MULTIADDR_MAX_ADDRESS) {
				$this->reorderLeadAddr($leadid, 1);
				$display = $this->addrMix($data);
				$upd = [
					'seq' => 1,
					'address_name' => $data['address_name'],
					'address_display' => $display,
					'street' => $data['street'],
					'city' => $data['city'],
					'state' => $data['state'],
					'zip' => $data['zip'],
					'country' => $data['country'],
					'leadid' => $leadid,
				];
				$CI->db->insert(db_prefix() . 'multiaddrleads', $upd);

				$this->reorderLeadAddr($leadid);

				$updated = true;
			}
		} elseif ($action=='order') {
			//$this->reorderSetup($userid, $addrid);
			$seq = 0;
			foreach ($addrid as $id) {
				$seq++;
				$this->db->where('leadid', $leadid);
				$this->db->where('id', $id);
				$this->db->update(db_prefix().'multiaddrleads', [ 'seq' => $seq ]);
			}
			$updated = true; // already have order
		} elseif ($action=='get') {
			$updated = true; // 2022-04-03
		}
		if ($updated) {
			$addressList = $this->db->where('leadid', $leadid)->order_by('seq', 'asc')->get(db_prefix().'multiaddrleads')->result_array();

			ob_start();
			foreach ($addressList as $key => $address) {
				$json = json_encode($address);
				?>
                <tr>
                    <td><span class="ui-icon ui-icon-arrowthick-2-n-s"></span><?php echo $address['seq'] ?></td>
                    <td><?php echo $address['address_name'] ?></td>
                    <td><?php echo $address['address_display'] ?></td>
                    <td data-leadid="<?php echo $address['leadid']; ?>" data-addrid="<?php echo $address['id'] ?>"  data-json='<?php echo $json; ?>' >
<!--                        <a href='#' class="addr-del">--><?php //echo _l('delete'); ?><!--</a> |-->
<!--                        <a href='#' class="addr-edit">--><?php //echo _l('edit'); ?><!--</a> |-->
<!--                        <a href='#' class="addr-view">--><?php //echo _l('view'); ?><!--</a> |-->
<!--                        <a href='#' class="addr-bill">--><?php //echo _l('multiaddr_set_billing'); ?><!--</a> |-->
<!--                        <a href='#' class="addr-ship">--><?php //echo _l('multiaddr_set_shipping'); ?><!--</a>-->
<!--                        <input type="hidden" class="order_addr" value="--><?php //echo $address['id']; ?><!--">-->
						<?php
						$actions = [];
						if (has_permission('customers','','delete')) {
							$actions[] ='<a href="#" class="addr-del"  title="'. _l('delete').'"><button type="button" class="btn btn-danger"><i class="fa fa-close"></i></button></a>';
						}
						if (has_permission('customers','','edit')) {
							$actions[] ='<a href="#" class="addr-edit" title="'. _l('edit').'"><button type="button" class="btn btn-primary"><i  class="fa fa-pencil"></i></button></a>';
						}
						if (has_permission('customers','','view')) {
							$actions[] ='<a href="#" class="addr-view" title="'. _l('view').'"><button type="button" class="btn btn-info"><i class="fa fa-eye"></i></button></a>';
						}
						if (has_permission('customers','','edit')) {
							$actions[] ='<a href="#" class="addr-normal" title="'. _l('multiaddr_set_shipping').'"><button class="btn btn-info"><i class="fa fa-truck"></i></button></a>';
						}
						echo implode('', $actions);
						?>
                        <input type="hidden" class="order_addr"  value="<?php echo $address['id']; ?>">

                    </td>
                </tr>
			<?php }

			$html = ob_get_contents();
			ob_end_clean();
			$return = [
				'rscode' => 200,
				'html' => $html
			] ;
		} else {
			$return = [
				'rscode' => 400,
			];
		}
		echo json_encode($return);
		exit;
	}


	public function save()
	{
		foreach(['livechat_license','livechat_client_portal','livechat_vendor_portal','livechat_recruitment_portal'] as $tmp_option) {
			$$tmp_option = $this->input->post($tmp_option, FALSE);
			$$tmp_option = trim($$tmp_option);
			$$tmp_option = nl2br($$tmp_option);
		}
		update_option('livechat_license', $livechat_license);
		update_option('livechat_client_portal', $livechat_client_portal);
		update_option('livechat_vendor_portal', $livechat_vendor_portal);
		update_option('livechat_recruitment_portal', $livechat_recruitment_portal);
		$new = get_option('livechat_license');
		if ($new == $livechat_license) {
			echo json_encode([
				'rscode' => 200,
				'message'  => _l('updated_successfully', _l('livechat_license')),
			]);
		}
	}

	public function get_addresses() {
		$data = $this->input->post();
	    $q = $data['q'];
		$t = $data['t'];
		$n = $data['n'];
	    $langs = $data['langs']??'';
		$url = MULTIADDR_GOV_GEODATA_URL;
		$url .= '?q='.urlencode($q).'&n='.$n.'&t='.$t;

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		$output = curl_exec($ch);
		curl_close($ch);

        if ($langs == 'Eng') {
			$headerLangValue = 'en';
		} else if ($langs == 'Chi') {
			$headerLangValue = 'zh-Hant';
		} else {
			$headerLangValue = '*';
		}


//		// create curl resource
		$ch = curl_init();

		// set url
		curl_setopt($ch, CURLOPT_URL, $url);

		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			"Accept: application/xml",
			"Accept-Language: ".$headerLangValue));

		//return the transfer as a string
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

		// $output contains the output string
		$xmlstr = curl_exec($ch);

		// close curl resource to free up system resources
		curl_close($ch);


		$result = new SimpleXMLElement($xmlstr);

		foreach ( $result->SuggestedAddress  as $k => $address) {
			$record = $address->Address->PremisesAddress;

			$data = $record->EngPremisesAddress;
			$item = [];
			if (isset($data->EngBlock)) {
				$desc = (string)$data->EngBlock->BlockDescriptor; // BLK
				$no = (string)$data->EngBlock->BlockNo;  // A
				if (isset($data->EngBlock->BlockDescriptorPrecedenceIndicator)) {
					$prec = (string)$data->EngBlock->BlockDescriptorPrecedenceIndicator; // Y
				} else {
					$prec = 'N';
				}
				if ($prec && $prec == 'Y') {
					$item['Eng']['Block'] = $desc . ' ' . $no;
				} else {
					$item['Eng']['Block'] = $no . ' ' . $desc;
				}
			}
			if (isset($data->BuildingName)) {
				$item['Eng']['BuildingName'] = (string)$data->BuildingName;
			}
			if (isset($data->EngEstate->EstateName)) {
				$item['Eng']['Estate'] = (string)$data->EngEstate->EstateName;
				if (isset($data->EngEstate->EngPhase->PhaseName)) {
					$item['Eng']['Estate'] .= ' ' . ((string)$data->EngEstate->EngPhase->PhaseName);
				}
				if (isset($data->EngEstate->EngPhase->PhaseNo)) {
					$item['Eng']['Estate'] .= ' ' . ((string)$data->EngEstate->EngPhase->PhaseNo);
				}
			}
			if (isset($data->EngStreet->StreetName)) {
				$parts = [];
				if ($data->EngStreet->LocationName) {
					$parts[] = (string)$data->EngStreet->LocationName;
				}

				$parts[] = (string)$data->EngStreet->StreetName;
				if (isset($data->EngStreet->BuildingNoFrom)) {
					$parts[] = (string)$data->EngStreet->BuildingNoFrom;
				}
				$item['Eng']['Street'] = implode(' ', $parts);
			}

			if (isset($data->EngDistrict->DcDistrict)) {
				$item['Eng']['District'] = (string)$data->EngDistrict->DcDistrict;
			}
			if (isset($data->Region)) {
				$item['Eng']['Region'] = (string)$data->Region;
			}

			$info = [];
			$parts = [];
			if (isset($item['Eng']['Block'])) $parts[] = $item['Eng']['Block'];
			if (isset($item['Eng']['BuildingName'])) $parts[] = $item['Eng']['BuildingName'];
			if (isset($item['Eng']['Estate'])) $parts[] = $item['Eng']['Estate'];
			if (isset($item['Eng']['Street'])) $parts[] = $item['Eng']['Street'];
			if ($parts) {
				$info['Eng']['Street'] = implode(', ', $parts);
			}
			if (isset($item['Eng']['District'])) {
				$info['Eng']['City'] = $item['Eng']['District'];
			}
			if (isset($item['Eng']['Region'])) {
				$info['Eng']['State'] = $item['Eng']['Region'];
			}

			if ($info) {
				$infos[] = $info;
			}

			//-----------------------------------------------

			$data = $record->ChiPremisesAddress;
			$item = [];
			if (isset($data->ChiBlock)) {
				$desc = (string)$data->ChiBlock->BlockDescriptor; // BLK
				$no = (string)$data->ChiBlock->BlockNo;  // A
				if (isset($data->ChiBlock->BlockDescriptorPrecedenceIndicator)) {
					$prec = (string)$data->ChiBlock->BlockDescriptorPrecedenceIndicator; // Y
				} else {
					$prec = 'N';
				}
				if ($prec && $prec == 'Y') {
					$item['Chi']['Block'] = $desc . ' ' . $no;
				} else {
					$item['Chi']['Block'] = $no . ' ' . $desc;
				}
			}
			if (isset($data->BuildingName)) {
				$item['Chi']['BuildingName'] = (string)$data->BuildingName;
			}
			if (isset($data->ChiEstate->EstateName)) {
				$item['Chi']['Estate'] = (string)$data->ChiEstate->EstateName;
				if (isset($data->ChiEstate->ChiPhase->PhaseName)) {
					$item['Chi']['Estate'] .= ' ' . ((string)$data->ChiEstate->ChiPhase->PhaseName);
				}
				if (isset($data->ChiEstate->ChiPhase->PhaseNo)) {
					$item['Chi']['Estate'] .= ' ' . ((string)$data->ChiEstate->ChiPhase->PhaseNo);
				}
			}
			if (isset($data->ChiStreet->StreetName)) {
				$parts = [];
				if ($data->ChiStreet->LocationName) {
					$parts[] = (string)$data->ChiStreet->LocationName;
				}
				$parts[] = (string)$data->ChiStreet->StreetName;
				if (isset($data->ChiStreet->BuildingNoFrom)) {
					$parts[] = ((string)$data->ChiStreet->BuildingNoFrom) . '號';
				}
				$item['Chi']['Street'] = implode(' ', $parts);
			}

			if (isset($data->ChiDistrict->DcDistrict)) {
				$item['Chi']['District'] = (string)$data->ChiDistrict->DcDistrict;
			}
			if (isset($data->Region)) {
				$item['Chi']['Region'] = (string)$data->Region;
			}

			$info = [];
			$parts = [];
			if (isset($item['Chi']['Block'])) $parts[] = $item['Chi']['Block'];
			if (isset($item['Chi']['BuildingName'])) $parts[] = $item['Chi']['BuildingName'];
			if (isset($item['Chi']['Estate'])) $parts[] = $item['Chi']['Estate'];
			if (isset($item['Chi']['Street'])) $parts[] = $item['Chi']['Street'];
			if ($parts) {
				$info['Chi']['Street'] = implode(', ', $parts);
			}
			if (isset($item['Chi']['District'])) {
				$info['Chi']['City'] = $item['Chi']['District'];
			}
			if (isset($item['Chi']['Region'])) {
				$info['Chi']['State'] = $item['Chi']['Region'];
			}

			if ($info) {
				$infos[] = $info;
			}
		}
//		$infos = array_reverse($infos);
		header('Content-Type: application/json');
		echo json_encode($infos);
	}

}