<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Development_mode_model extends App_Model
{
	public function __construct()
	{
		parent::__construct();
	}

	// 2022-03-26
	/**
	 * Add new address
	 * @param array  $data               $_POST data
	 * @param mixed  $customer_id        customer id
	 */
	public function add_address($data, $customer_id)
	{

		$data = hooks()->apply_filters('before_create_address', $data);

		$data['userid'] = $customer_id;

		$this->db->insert(db_prefix() . 'multiaddr', $data);
		$addr_id = $this->db->insert_id();

		if ($addr_id) {
			log_activity('Address Created [ID: ' . $addr_id . ']');

			hooks()->do_action('address_created', $addr_id);

			return $addr_id;
		}

		return false;
	}

}
