<?php

/**
 * Ensures that the module init file can't be accessed directly, only within the application.
 */
defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Multi-address
Description: Client can input multiple address for selection
Version: 1.0.0
Author PMT: Developed by tag.digital
Author URI: https://tag.digital/
Requires at least: 2.7.3
*/

define('MULTIADDR_MODULE_NAME', 'multiaddr');
define('MULTIADDR_MAX_ADDRESS', 6);
define('MULTIADDR_GOV_GEODATA_URL', 'https://www.als.ogcio.gov.hk/lookup');



$CI = &get_instance();
// add menu and check staff need to sign out
hooks()->add_action('admin_init', 'multiaddr_admin_init');

//hooks()->add_filter('staff_permissions', 'multiaddr_access');



/**
 * Register language files, must be registered if the module is using languages
 */
register_language_files(MULTIADDR_MODULE_NAME, [MULTIADDR_MODULE_NAME]);

//register_activation_hook(MULTIADDR_MODULE_NAME, 'multiaddr_setup_permission');

/**
 * Init api module menu items in setup in admin_init hook
 * @return null
 */
function multiaddr_admin_init()
{
	/**
	 * If the logged in user is administrator, add custom menu in Setup
	 */
	$CI = &get_instance();

}

function multiaddr_module_activation_hook()
{
	$CI = &get_instance();
	require_once(__DIR__ . '/install.php');
}


function addrMix($data) {
	$country = $data['country'];
	$countries = get_all_countries();
	foreach ($countries as $k => $v) {
		if ($v['country_id'] == $country) {
			$country = $v['short_name'];
			break;
		}
	}
	$addr = [];
	if ($data['street']) $addr[] = $data['street'];
	if ($data['city']) $addr[] = $data['city'];
	if ($data['state']) $addr[] = $data['state'];
	if ($data['zip']) $addr[] = $data['zip'];
	if ($country) $addr[] = $country;
	return implode(', ', $addr);
}


//function multiaddr_setup_permission($permissions) {
//	$capabilities = [
//		'view' => _l('view'),
//		'create' => _l('create'),
//		'edit' => _l('edit'),
//		'delete' => _l('delete'),
//	];
//
//	$permissions['multiaddr_access'] = [
//		'name' => _l('multiaddr'),
//		'capabilities' => $capabilities
//	];
//	return $permissions;
//}


