<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Rocket_lms extends AdminController
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('rocket_lms_model');
	}


	public function option()
	{
		if (! is_admin() || is_sys_oper()) {
			set_alert('danger', _l('access_denied'));
			redirect(admin_url());
		}

		//$data['user_api'] = $this->api_model->get_user();
		//$data['title'] = _l('api_management');
		$data = array();
		$this->load->view('option', $data);
	}

	// 2022-03-19
	public function login_admin() {
		if (is_admin() || has_permission('rocket_lms', '', 'admin')) {
			$rocket_lms_url = get_option('rocket_lms_url').'/rocket-login';
			$rocket_lms_login = get_option('rocket_lms_login');

			$data = [
				'url' => $rocket_lms_url,
				'email' => $rocket_lms_login,
				'role' => 'admin'
			];
			$this->load->view('login', $data);
		}
	}

	// 2022-03-19
	public function login_staff() {
    	if(is_admin() || has_permission('rocket_lms', '', 'view')){
			$id = get_staff_user_id();
			$CI = & get_instance();
			$CI->db->where('staffid', $id);
			$current_user = $CI->db->get(db_prefix().'staff')->row();

			$rocket_lms_url = get_option('rocket_lms_url').'/rocket-login';

			$data = [
				'url' => $rocket_lms_url,
				'email' => $current_user->email,
				//'role' => $current_user->role == 2 ? 'staff' : 'user'
				'role' => 'user',
			];
			$this->load->view('login', $data);
		}
	}

	public function save()
	{
		foreach(['rocket_lms_login','rocket_lms_pass','rocket_lms_url'] as $tmp_option) {
			$$tmp_option = $this->input->post($tmp_option, FALSE);
			$$tmp_option = trim($$tmp_option);
			$$tmp_option = nl2br($$tmp_option);
		}

		$msg = '';
		if (! filter_var($rocket_lms_url, FILTER_VALIDATE_URL)) {
			$msg = _('rocket_lms_invalid_url');
		} else
		if (! filter_var($rocket_lms_login, FILTER_VALIDATE_EMAIL)) {
			$msg = _('rocket_lms_invalid_email');
		}
		if ($rocket_lms_pass) {
			$sysPasscode = get_option('rocket_lms_pass');
			$userPasscode = $this->hashString($rocket_lms_pass);
		}

		if ($msg) {
			set_alert('danger', $msg);
		} else {
			update_option('rocket_lms_url', $rocket_lms_url);
			update_option('rocket_lms_login', $rocket_lms_login);
			update_option('rocket_lms_pass', $rocket_lms_pass);
			set_alert('success', _l('rocket_lms_update_success'));
		}

	}

	public function hashString($input)  {
		return sha1('MdsihcCu6r5k.n,asgg^s'.$input);
	}

}