<?php

/**
 * Ensures that the module init file can't be accessed directly, only within the application.
 */
defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: LMS connector
Description: Remote login to LMS for training
Version: 1.0.0
Author PMT: tag.digital
Author URI: https://tag.digital/
Requires at least: 2.7.3
*/

define('ROCKET_LMS_MODULE_NAME', 'rocket_lms');
define('ROCKET_LMS_PASSWORD', 'pmtpmt');
define('ROCKET_LMS_ALLOW_STAFF_UIDS', array(1));



$CI = &get_instance();
// add menu and check staff need to sign out
hooks()->add_action('admin_init', 'rocket_lms_admin_init');
//hooks()->add_action('admin_init', 'rocket_lms_permissions');
//hooks()->add_action('after_clients_area_init', 'rocket_lms_after_clients_area_init');
//hooks()->add_action('after_render_top_search', 'rocket_lms_after_staff_top_menu'); // Show on top menu
hooks()->add_filter('staff_permissions', 'rocket_lms_permissions');
// 2022-03-19
hooks()->add_filter('before_staff_change_password', 'rocket_lms_change_password');// $data, $userid);
// 2022-03-20
hooks()->add_action('app_admin_footer', 'rocket_lms_admin_footer');

/**
 * Register language files, must be registered if the module is using languages
 */
register_language_files(ROCKET_LMS_MODULE_NAME, [ROCKET_LMS_MODULE_NAME]);


/**
 * Init api module menu items in setup in admin_init hook
 * @return null
 */
function rocket_lms_admin_init()
{
	/**
	 * If the logged in user is administrator, add custom menu in Setup
	 */
	$CI = &get_instance();

	if (is_admin() && !  is_sys_oper()) {
		// add_sidebar

		$CI->app_menu->add_setup_menu_item('rocket-lms-options', [
			'name'     => _l('rocket_lms_setup'),
			'href'     => admin_url('rocket_lms/option'),
			'position' => 80,
			'icon'     => '',
		]);
	}

	// 2022-03-19
//	if(is_staff_member()) {
		$staffP = (has_permission('rocket_lms', '', 'view')) ;
		$adminP =  (is_admin() || has_permission('rocket_lms', '', 'admin'));

		if ($adminP) {
			$CI->app_menu->add_sidebar_menu_item('rocket_admin', [
				'name' => _l('rocket_lms_admin'),
				'slug' => 'lms_admin',
				'position' => 993,
				'href' => "javascript:openExtUrl('".admin_url('rocket_lms/login_admin')."')",
				'icon' => 'fa fa-dashboard',
				'badge' => []
			]);
		}
		if ($staffP) {
            // Will be hidden by admin_footer action
			$CI->app_menu->add_sidebar_menu_item('rocket_staff', [
				'name' => _l('rocket_lms'),
				'slug' => 'lms_staff',
				'position' => 991,
				'href' => "javascript:openExtUrl('".admin_url('rocket_lms/login_staff')."')",
				'icon' => 'fa fa-user',
				'badge' => []
			]);
		}
//	}
}

function rocket_lms_after_staff_top_menu() {
    $id = get_staff_user_id();
    $CI = & get_instance();
    $CI->db->where('staffid', $id);
    $current_user = $CI->db->get(db_prefix().'staff')->row();
    // 2022-03-15 ?>
    <?php if($current_user->admin || has_permission('rocket_lms', '', 'admin')){ ?>
        <li class="icon header-todo" style="height: 63px;display: flex;align-items: center;padding: 1rem;">
            <!-- <form action="https://lms.zuu.com.hk/rocket-login" method="POST" target="_blank" style="height: 100%;"> -->
            <form action="<?php echo get_option('rocket_lms_url'); ?>/rocket-login" method="POST" target="_blank" style="height: 100%;">
                <input type="hidden" name="email" value="<?php echo $current_user->email ?>">
                <input type="hidden" name="role" value="admin">
                <button type="submit" style="padding: 0;background: transparent;color: white;border: 0;height: 100%;" data-toggle="tooltip" data-placement="bottom" title="Jump to Rocket Admin Panel">
                    <i class="fa fa-dashboard fa-fw fa-lg"></i>
                </button>
            </form>
        </li>
    <?php } ?>
    <?php if(has_permission('rocket_lms', '', 'view')){ ?>
        <li class="icon header-todo" style="height: 63px;display: flex;align-items: center;padding: 1rem;">
            <form action="<?php echo get_option('rocket_lms_url'); ?>/rocket-login" method="POST" target="_blank" style="height: 100%;">
                <input type="hidden" name="email" value="<?php echo $current_user->email ?>">
                <input type="hidden" name="role" value="staff">
                <button type="submit" style="padding: 0;background: transparent;color: white;border: 0;height: 100%;" data-toggle="tooltip" data-placement="bottom" title="Jump to Rocket User">
                    <i class="fa fa-user fa-fw fa-lg"></i>
                </button>
            </form>
        </li>
    <?php } ?>
	<?php if(has_permission('rocket_lms', '', 'view')){ ?>
        <?php if((int) $current_user->role === 2){ ?>
           <li class="icon header-todo" style="height: 63px;display: flex;align-items: center;padding: 1rem;">
               <form action="<?php echo get_option('rocket_lms_url'); ?>/rocket-login" method="POST" target="_blank" style="height: 100%;">
                   <input type="hidden" name="email" value="<?php echo $current_user->email ?>">
                   <input type="hidden" name="role" value="staff">
                   <button type="submit" style="padding: 0;background: transparent;color: white;border: 0;height: 100%;" data-toggle="tooltip" data-placement="bottom" title="Jump to Rocket Staff Panel">
                       <i class="fa fa-user fa-fw fa-lg"></i>
                   </button>
               </form>
           </li>
        <?php } ?>
        <?php if(!$current_user->admin && (int) $current_user->role !== 2){ ?>
            <li class="icon header-todo" style="height: 63px;display: flex;align-items: center;padding: 1rem;">
                <form action="<?php echo get_option('rocket_lms_url'); ?>/rocket-login" method="POST" target="_blank" style="height: 100%;">
                    <input type="hidden" name="email" value="<?php echo $current_user->email ?>">
                    <input type="hidden" name="role" value="user">
                    <button type="submit" style="padding: 0;background: transparent;color: white;border: 0;height: 100%;" data-toggle="tooltip" data-placement="bottom" title="Jump to Rocket User">
                        <i class="fa fa-user fa-fw fa-lg"></i>
                    </button>
                </form>
            </li>
        <?php } ?>
    <?php }

}

//function rocket_lms_permissions()
//{
//	$capabilities = [];
//
//	$capabilities['capabilities'] = [
//		'edit'   => _l('rocket_lms'),
//	];
//
////	'rocket_lms' => [  // 2022-03-15
////	'name'         => _l('Rocket Lms'),
////	'capabilities' => [
////		'view' => 'Access',
//////                   'admin-view' => 'Admin',
////	],
////],
//
//
//	register_staff_capabilities('rocket_lms', $capabilities, _l('rocket_lms_setup'));
//
//}

function rocket_lms_permissions($permissions) {
	$capabilities = [
		'view' => _l('rocket_lms'),
		'admin' => _l('rocket_lms_admin'),
	];

	$permissions['rocket_lms'] = [
		'name' => _l('rocket_lms_setup'),
		'capabilities' => $capabilities
	];
	return $permissions;
}

function rocket_lms_change_password($data, $userid=0) {
    return $data; // no need pass password

    if ($userid == 0) {
        $userid = get_staff_user_id();
    }
    $tmpData = array_merge($data);
	$CI = & get_instance();
	$member = $CI->staff_model->get($userid);
	// CHeck if member is active
	if  ($member->active == 0) {
		return $tmpData;
    }

	// Check new old password
	if (!app_hasher()->CheckPassword($data['oldpassword'], $member->password)) {
		return $tmpData;
	}

	if ($data['newpassword'] != $data['newpasswordr']) {
		return $tmpData;
    }

	$rocketUpdateData = [
		'_method' => 'PUT',
		'old_email' => $member->email,
		'password' => $data['newpasswordr'],
		'access' => (int) has_permission('rocket_lms', '', 'view')
	];

	$rocket_lms_url = get_option('rocket_lms_url').'/api/rocket-user/1';
	$resp = rocket_sendRequest($rocket_lms_url, $rocketUpdateData);
	return($tmpData);
}

function rocket_sendRequest($url, $data)
{
	$curl = curl_init($url);

	curl_setopt($curl, CURLOPT_POST, true);
	curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
	curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($curl, CURLOPT_VERBOSE, true);

	$response = curl_exec($curl);
	curl_close ($curl);

	return $response;
}

// 2022-03-24   for hr_profile
hooks()->add_action('staff_member_created', 'rocket_lms_staffmember_createde');
function staff_member_created($id){
    $data = $_POST;
	rocket_lms_after_add_staff($data, $id);
}
// 2022-03-19
hooks()->add_action('tg_after_add_staff', 'rocket_lms_after_add_staff', 10, 2);
function rocket_lms_after_add_staff($data, $id) {
    $CI = & get_instance();
	// 2022-03-115
	// Start - Send post request to rocket lms to create user
	$rocketData = [
		'full_name' => $data['firstname'].' '.$data['lastname'],
		'mobile' => $data['phonenumber'],
		'email' => $data['email'],
		'password' => substr(sha1($data['email']),-16), // $data['password'],
		'role' => 1, //$data['role'], // 1 = employee, 2 = staff, 3 = admin
		'access' => (int) has_permission('rocket_lms', '', 'view')
	];
	if(isset($_FILES['profile_image']['name']) && $_FILES['profile_image']['name'] != '') {
		$memberModel = $CI->staff_model->get($id);
		//$rocketData['avatar'] = 'https://lms.zuu.com.hk/crm/uploads/staff_profile_images/'.$id.'/thumb_'.$memberModel->profile_image;
		$rocketData['avatar'] = site_url('uploads/staff_profile_images/'.$id.'/thumb_'.$memberModel->profile_image);
	}
	//var_dump($this->sendRequest('https://lms.zuu.com.hk/api/rocket-user', $rocketData));
	$ret = (rocket_sendRequest(get_option('rocket_lms_url').'/api/rocket-user', $rocketData));
	// End - Send post request to rocket lms to update user
}

// 2022-03-19
hooks()->add_action('tg_before_update_staff', 'rocket_lms_before_update_staff', 10, 2);
function rocket_lms_before_update_staff($data, $id) {
	$CI = & get_instance();
	// 2022-03-15
	// Start - Send post request to rocket lms to update user
	$oldMember = $CI->staff_model->get($id);
	$rocketUpdateData = [
		'_method' => 'PUT',
		'full_name' => $data['firstname'].' '.$data['lastname'],
		'mobile' => $data['phonenumber']??$oldMember->phonenumber,
		'old_email' => $oldMember->email,
		'email' => $data['email']??$oldMember->email,
		'password' => substr(sha1($oldMember->email),-16), // $data['password'],
		'role' => 1, //$data['role']??$oldMember->role,     // 1 = User, 2 = Staff, 3 = Admin
		'access' => (int) has_permission('rocket_lms', '', 'view')
	];
	if(isset($_FILES['profile_image']['name']) && $_FILES['profile_image']['name'] != '') {
		//$rocketUpdateData['avatar'] = 'https://lms.zuu.com.hk/crm/uploads/staff_profile_images/'.$id.'/thumb_'.$oldMember->profile_image;
		$rocketUpdateData['avatar'] = site_url('uploads/staff_profile_images/'.$id.'/thumb_'.$oldMember->profile_image);
	}
	//var_dump($this->sendRequest('https://lms.zuu.com.hk/api/rocket-user/1', $rocketUpdateData));
	$ret = (rocket_sendRequest(get_option('rocket_lms_url').'/api/rocket-user/1', $rocketUpdateData));
	// End - Send post request to rocket lms to update user
}

// 2022-03-23
//hooks()->add_action('tg_before_delete_staff', 'rocket_lms_before_delete_staff', 10, 2);
hooks()->add_action('before_delete_staff_member', 'rocket_lms_before_delete_staff'); // 2022-03-23
function rocket_lms_before_delete_staff($data) {
	$CI = & get_instance();
	//$member = $CI->staff_model->get($CI->input->post('id'));
	$member = $CI->staff_model->get($data['id']);
	rocket_sendRequest(get_option('rocket_lms_url').'/api/rocket-user/1', [
		'_method' => 'DELETE',
		'email' => $member->email,
	]);
}

// 2022-03-19
hooks()->add_action('tg_after_change_staff_status', 'rocket_change_staff_status', 10, 2);
function rocket_change_staff_status($id, $status) {

     $CI = &get_instance();
	 $staff = $CI->staff_model->get($id);
	 //$this->sendRequest('https://lms.zuu.com.hk/api/rocket-user/status', [
	 $ret =  rocket_sendRequest(get_option('rocket_lms_url').'/api/rocket-user/status', [
	      'email' => $staff->email,
	      'status' => $status
	  ]);
}

function rocket_lms_admin_footer() {
    if (is_admin()) {
		echo '<style> .menu-item-rocket_staff, .sub-menu-item-rocket_staff {  display: none !important;  }  </style>';
	}
}